/*
 * Decompiled with CFR 0.152.
 */
package mindbright.security;

import mindbright.security.MessageDigest;

public class MD5State
extends MessageDigest {
    SubState state = new SubState();
    static byte[] padding;

    protected static int[] toIntArray(byte[] byArray, int n, int n2) {
        int[] nArray = new int[16];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            nArray[n4] = byArray[n3 + n] & 0xFF | (byArray[n3 + 1 + n] & 0xFF) << 8 | (byArray[n3 + 2 + n] & 0xFF) << 16 | (byArray[n3 + 3 + n] & 0xFF) << 24;
            ++n4;
            n3 += 4;
        }
        return nArray;
    }

    protected static byte[] toByteArray(int[] nArray, int n) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)(nArray[n3] & 0xFF);
            byArray[n2 + 1] = (byte)(nArray[n3] >>> 8 & 0xFF);
            byArray[n2 + 2] = (byte)(nArray[n3] >>> 16 & 0xFF);
            byArray[n2 + 3] = (byte)(nArray[n3] >>> 24 & 0xFF);
            ++n3;
            n2 += 4;
        }
        return byArray;
    }

    public String getName() {
        return "MD5";
    }

    public void reset() {
        this.state.reset();
    }

    private void update(SubState subState, byte[] byArray, int n, int n2) {
        int n3;
        if (n2 - n > byArray.length) {
            n2 = byArray.length - n;
        }
        int n4 = (int)(subState.count / 8L) % 64;
        subState.count += (long)(8 * n2);
        int n5 = 64 - n4;
        if (n2 >= n5) {
            System.arraycopy(byArray, n, subState.buffer, n4, n5);
            subState.transform(subState.buffer, 0);
            n3 = n5;
            while (n3 + 63 < n2) {
                subState.transform(byArray, n3);
                n3 += 64;
            }
            n4 = 0;
        } else {
            n3 = 0;
        }
        if (n3 < n2) {
            int n6 = n3;
            while (n3 < n2) {
                subState.buffer[n4 + n3 - n6] = byArray[n3 + n];
                ++n3;
            }
        }
    }

    public void update(byte[] byArray, int n, int n2) {
        this.update(this.state, byArray, n, n2);
    }

    public byte[] digest() {
        SubState subState = new SubState(this.state);
        byte[] byArray = new byte[]{(byte)subState.count, (byte)(subState.count >> 8), (byte)(subState.count >> 16), (byte)(subState.count >> 24), (byte)(subState.count >> 32), (byte)(subState.count >> 40), (byte)(subState.count >> 58), (byte)(subState.count >> 56)};
        int n = (int)(subState.count / 8L) % 64;
        int n2 = n < 56 ? 56 - n : 120 - n;
        this.update(subState, padding, 0, n2);
        this.update(subState, byArray, 0, 8);
        byte[] byArray2 = MD5State.toByteArray(subState.hash, 16);
        return byArray2;
    }

    public int blockSize() {
        return 64;
    }

    public int hashSize() {
        return 16;
    }

    static {
        byte[] byArray = new byte[64];
        byArray[0] = -128;
        padding = byArray;
    }

    public static class SubState {
        public int[] hash;
        public long count;
        public byte[] buffer = new byte[64];

        public SubState() {
            this.hash = new int[4];
            this.reset();
        }

        public void reset() {
            this.hash[0] = 1732584193;
            this.hash[1] = -271733879;
            this.hash[2] = -1732584194;
            this.hash[3] = 271733878;
            this.count = 0L;
        }

        public SubState(SubState subState) {
            this.hash = new int[4];
            System.arraycopy(subState.hash, 0, this.hash, 0, 4);
            System.arraycopy(subState.buffer, 0, this.buffer, 0, 64);
            this.count = subState.count;
        }

        public static int rotateLeft(int n, int n2) {
            return n << n2 | n >>> 32 - n2;
        }

        public static int uadd(int n, int n2) {
            long l = (long)n & 0xFFFFFFFFL;
            long l2 = (long)n2 & 0xFFFFFFFFL;
            return (int)(l + l2 & 0xFFFFFFFFL);
        }

        public static int uadd(int n, int n2, int n3) {
            long l = (long)n & 0xFFFFFFFFL;
            long l2 = (long)n2 & 0xFFFFFFFFL;
            long l3 = (long)n3 & 0xFFFFFFFFL;
            return (int)(l + l2 + l3 & 0xFFFFFFFFL);
        }

        public static int uadd(int n, int n2, int n3, int n4) {
            long l = (long)n & 0xFFFFFFFFL;
            long l2 = (long)n2 & 0xFFFFFFFFL;
            long l3 = (long)n3 & 0xFFFFFFFFL;
            long l4 = (long)n4 & 0xFFFFFFFFL;
            return (int)(l + l2 + l3 + l4 & 0xFFFFFFFFL);
        }

        public static int FF(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            n = SubState.uadd(n, n2 & n3 | ~n2 & n4, n5, n7);
            return SubState.uadd(SubState.rotateLeft(n, n6), n2);
        }

        public static int GG(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            n = SubState.uadd(n, n2 & n4 | n3 & ~n4, n5, n7);
            return SubState.uadd(SubState.rotateLeft(n, n6), n2);
        }

        public static int HH(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            n = SubState.uadd(n, n2 ^ n3 ^ n4, n5, n7);
            return SubState.uadd(SubState.rotateLeft(n, n6), n2);
        }

        public static int II(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            n = SubState.uadd(n, n3 ^ (n2 | ~n4), n5, n7);
            return SubState.uadd(SubState.rotateLeft(n, n6), n2);
        }

        public void transform(byte[] byArray, int n) {
            int n2 = this.hash[0];
            int n3 = this.hash[1];
            int n4 = this.hash[2];
            int n5 = this.hash[3];
            int[] nArray = MD5State.toIntArray(byArray, n, 64);
            n2 = SubState.FF(n2, n3, n4, n5, nArray[0], 7, -680876936);
            n5 = SubState.FF(n5, n2, n3, n4, nArray[1], 12, -389564586);
            n4 = SubState.FF(n4, n5, n2, n3, nArray[2], 17, 606105819);
            n3 = SubState.FF(n3, n4, n5, n2, nArray[3], 22, -1044525330);
            n2 = SubState.FF(n2, n3, n4, n5, nArray[4], 7, -176418897);
            n5 = SubState.FF(n5, n2, n3, n4, nArray[5], 12, 1200080426);
            n4 = SubState.FF(n4, n5, n2, n3, nArray[6], 17, -1473231341);
            n3 = SubState.FF(n3, n4, n5, n2, nArray[7], 22, -45705983);
            n2 = SubState.FF(n2, n3, n4, n5, nArray[8], 7, 1770035416);
            n5 = SubState.FF(n5, n2, n3, n4, nArray[9], 12, -1958414417);
            n4 = SubState.FF(n4, n5, n2, n3, nArray[10], 17, -42063);
            n3 = SubState.FF(n3, n4, n5, n2, nArray[11], 22, -1990404162);
            n2 = SubState.FF(n2, n3, n4, n5, nArray[12], 7, 1804603682);
            n5 = SubState.FF(n5, n2, n3, n4, nArray[13], 12, -40341101);
            n4 = SubState.FF(n4, n5, n2, n3, nArray[14], 17, -1502002290);
            n3 = SubState.FF(n3, n4, n5, n2, nArray[15], 22, 1236535329);
            n2 = SubState.GG(n2, n3, n4, n5, nArray[1], 5, -165796510);
            n5 = SubState.GG(n5, n2, n3, n4, nArray[6], 9, -1069501632);
            n4 = SubState.GG(n4, n5, n2, n3, nArray[11], 14, 643717713);
            n3 = SubState.GG(n3, n4, n5, n2, nArray[0], 20, -373897302);
            n2 = SubState.GG(n2, n3, n4, n5, nArray[5], 5, -701558691);
            n5 = SubState.GG(n5, n2, n3, n4, nArray[10], 9, 38016083);
            n4 = SubState.GG(n4, n5, n2, n3, nArray[15], 14, -660478335);
            n3 = SubState.GG(n3, n4, n5, n2, nArray[4], 20, -405537848);
            n2 = SubState.GG(n2, n3, n4, n5, nArray[9], 5, 568446438);
            n5 = SubState.GG(n5, n2, n3, n4, nArray[14], 9, -1019803690);
            n4 = SubState.GG(n4, n5, n2, n3, nArray[3], 14, -187363961);
            n3 = SubState.GG(n3, n4, n5, n2, nArray[8], 20, 1163531501);
            n2 = SubState.GG(n2, n3, n4, n5, nArray[13], 5, -1444681467);
            n5 = SubState.GG(n5, n2, n3, n4, nArray[2], 9, -51403784);
            n4 = SubState.GG(n4, n5, n2, n3, nArray[7], 14, 1735328473);
            n3 = SubState.GG(n3, n4, n5, n2, nArray[12], 20, -1926607734);
            n2 = SubState.HH(n2, n3, n4, n5, nArray[5], 4, -378558);
            n5 = SubState.HH(n5, n2, n3, n4, nArray[8], 11, -2022574463);
            n4 = SubState.HH(n4, n5, n2, n3, nArray[11], 16, 1839030562);
            n3 = SubState.HH(n3, n4, n5, n2, nArray[14], 23, -35309556);
            n2 = SubState.HH(n2, n3, n4, n5, nArray[1], 4, -1530992060);
            n5 = SubState.HH(n5, n2, n3, n4, nArray[4], 11, 1272893353);
            n4 = SubState.HH(n4, n5, n2, n3, nArray[7], 16, -155497632);
            n3 = SubState.HH(n3, n4, n5, n2, nArray[10], 23, -1094730640);
            n2 = SubState.HH(n2, n3, n4, n5, nArray[13], 4, 681279174);
            n5 = SubState.HH(n5, n2, n3, n4, nArray[0], 11, -358537222);
            n4 = SubState.HH(n4, n5, n2, n3, nArray[3], 16, -722521979);
            n3 = SubState.HH(n3, n4, n5, n2, nArray[6], 23, 76029189);
            n2 = SubState.HH(n2, n3, n4, n5, nArray[9], 4, -640364487);
            n5 = SubState.HH(n5, n2, n3, n4, nArray[12], 11, -421815835);
            n4 = SubState.HH(n4, n5, n2, n3, nArray[15], 16, 530742520);
            n3 = SubState.HH(n3, n4, n5, n2, nArray[2], 23, -995338651);
            n2 = SubState.II(n2, n3, n4, n5, nArray[0], 6, -198630844);
            n5 = SubState.II(n5, n2, n3, n4, nArray[7], 10, 1126891415);
            n4 = SubState.II(n4, n5, n2, n3, nArray[14], 15, -1416354905);
            n3 = SubState.II(n3, n4, n5, n2, nArray[5], 21, -57434055);
            n2 = SubState.II(n2, n3, n4, n5, nArray[12], 6, 1700485571);
            n5 = SubState.II(n5, n2, n3, n4, nArray[3], 10, -1894986606);
            n4 = SubState.II(n4, n5, n2, n3, nArray[10], 15, -1051523);
            n3 = SubState.II(n3, n4, n5, n2, nArray[1], 21, -2054922799);
            n2 = SubState.II(n2, n3, n4, n5, nArray[8], 6, 1873313359);
            n5 = SubState.II(n5, n2, n3, n4, nArray[15], 10, -30611744);
            n4 = SubState.II(n4, n5, n2, n3, nArray[6], 15, -1560198380);
            n3 = SubState.II(n3, n4, n5, n2, nArray[13], 21, 1309151649);
            n2 = SubState.II(n2, n3, n4, n5, nArray[4], 6, -145523070);
            n5 = SubState.II(n5, n2, n3, n4, nArray[11], 10, -1120210379);
            n4 = SubState.II(n4, n5, n2, n3, nArray[2], 15, 718787259);
            n3 = SubState.II(n3, n4, n5, n2, nArray[9], 21, -343485551);
            this.hash[0] = this.hash[0] + n2;
            this.hash[1] = this.hash[1] + n3;
            this.hash[2] = this.hash[2] + n4;
            this.hash[3] = this.hash[3] + n5;
        }
    }
}

