/*
 * Decompiled with CFR 0.152.
 */
package mindbright.security;

import java.util.Random;
import mindbright.security.MD5State;
import mindbright.security.Spinner;

public class SecureRandom
extends Random {
    MD5State.SubState ss = new MD5State.SubState();
    private int t;
    public static int secureLevel;
    byte[] unused;
    int unusedPos;
    int poolSweep;

    public SecureRandom() {
        this.t = Spinner.guessTime(1024);
        int n = secureLevel > 0 ? 2 : 1;
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.ss.buffer.length - 1;
            while (n3 >= 0) {
                this.ss.buffer[n3] = (byte)Spinner.spin(this.t);
                if (secureLevel < 2) {
                    this.ss.buffer[--n3] = (byte)System.currentTimeMillis();
                }
                --n3;
            }
            this.ss.transform(this.ss.buffer, 0);
            ++n2;
        }
        this.unused = new byte[16];
        this.unusedPos = 16;
    }

    public SecureRandom(byte[] byArray) {
        try {
            MD5State mD5State = new MD5State();
            mD5State.update(byArray);
            this.ss = mD5State.state;
        }
        catch (Exception exception) {
            System.out.println("Can't operate, MD5 not available...");
        }
        this.t = Spinner.guessTime(1024);
        this.unused = new byte[16];
        this.unusedPos = 16;
    }

    private void update() {
        if (secureLevel > 1) {
            int n = this.poolSweep++;
            this.ss.buffer[n] = (byte)(this.ss.buffer[n] + (Spinner.spin(this.t) + 1));
            int n2 = this.poolSweep++;
            this.ss.buffer[n2] = (byte)(this.ss.buffer[n2] + (Spinner.spin(this.t) + 1));
        } else {
            int n = this.poolSweep++;
            this.ss.buffer[n] = (byte)(this.ss.buffer[n] + Spinner.bogusSpin());
            int n3 = this.poolSweep;
            this.ss.buffer[n3] = (byte)(this.ss.buffer[n3] + this.ss.buffer[this.poolSweep - 1]);
        }
        ++this.poolSweep;
        this.poolSweep %= 64;
        this.ss.transform(this.ss.buffer, 0);
        SecureRandom.writeBytes(this.ss.hash[0], this.unused, 0, 4);
        SecureRandom.writeBytes(this.ss.hash[1], this.unused, 4, 4);
        SecureRandom.writeBytes(this.ss.hash[2], this.unused, 8, 4);
        SecureRandom.writeBytes(this.ss.hash[3], this.unused, 12, 4);
        this.unusedPos = 0;
    }

    protected synchronized int next(int n) {
        if (this.unusedPos == 16) {
            this.update();
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 = (n2 << 8) + this.unused[this.unusedPos++];
            n3 += 8;
        }
        return n2;
    }

    public static final void writeBytes(long l, byte[] byArray, int n, int n2) {
        int n3 = n + n2 - 1;
        while (n3 >= n) {
            byArray[n3] = (byte)l;
            l >>>= 8;
            --n3;
        }
    }
}

