/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import mindbright.ssh.SSH;
import mindbright.ssh.SSHChannelListener;

public abstract class SSHChannel
extends Thread {
    protected int channelId;
    protected SSHChannelListener listener;

    public SSHChannel(int n) {
        this.channelId = n;
        this.listener = null;
    }

    public void setSSHChannelListener(SSHChannelListener sSHChannelListener) {
        this.listener = sSHChannelListener;
    }

    public int getId() {
        return this.channelId;
    }

    public abstract void serviceLoop() throws Exception;

    public void close() {
    }

    public void run() {
        try {
            this.serviceLoop();
            return;
        }
        catch (Exception exception) {
            if (SSH.DEBUG) {
                System.out.println("--- channel exit:");
                exception.printStackTrace();
                System.out.println("---");
            }
            this.close();
            if (this.listener != null) {
                this.listener.close(this);
                return;
            }
        }
        catch (ThreadDeath threadDeath) {
            SSH.log("Channel killed " + this.channelId);
            throw threadDeath;
        }
    }
}

