/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;
import mindbright.security.Cipher;
import mindbright.ssh.SSH;
import mindbright.ssh.SSHChannel;
import mindbright.ssh.SSHChannelListener;
import mindbright.ssh.SSHClient;
import mindbright.ssh.SSHConnectChannel;
import mindbright.ssh.SSHConsole;
import mindbright.ssh.SSHListenChannel;
import mindbright.ssh.SSHPdu;
import mindbright.ssh.SSHPduInputStream;
import mindbright.ssh.SSHPduOutputStream;
import mindbright.ssh.SSHPduQueue;
import mindbright.ssh.SSHProtocolPlugin;
import mindbright.ssh.SSHRxChannel;
import mindbright.ssh.SSHServer;
import mindbright.ssh.SSHTunnel;
import mindbright.ssh.SSHTxChannel;

public final class SSHChannelController
extends SSH
implements SSHChannelListener {
    protected SSHTxChannel txChan;
    protected SSHRxChannel rxChan;
    protected SSHConnectChannel cnChan;
    protected SSHPduQueue txQueue;
    protected SSHPduQueue cnQueue;
    protected int nextEmptyChan;
    protected Vector tunnels;
    protected Vector listenChannels;
    protected SSH sshHook;
    protected SSHConsole console;
    protected Cipher sndCipher;
    protected Cipher rcvCipher;

    public SSHChannelController(SSH sSH, InputStream inputStream, OutputStream outputStream, Cipher cipher, Cipher cipher2, SSHConsole sSHConsole, boolean bl) {
        this.sndCipher = cipher;
        this.rcvCipher = cipher2;
        this.sshHook = sSH;
        this.console = sSHConsole;
        this.tunnels = new Vector();
        this.nextEmptyChan = 0;
        this.listenChannels = new Vector();
        this.txChan = new SSHTxChannel(outputStream, -1);
        this.rxChan = new SSHRxChannel(inputStream, -1);
        this.rxChan.setSSHChannelListener(this);
        this.txChan.setSSHChannelListener(this);
        this.rxChan.setSSHPduFactory(new SSHPduInputStream(-1, cipher2));
        this.txQueue = this.txChan.getQueue();
        if (bl) {
            this.cnChan = new SSHConnectChannel(this);
            this.cnChan.setSSHChannelListener(this);
            this.cnQueue = this.cnChan.getQueue();
            return;
        }
        this.cnQueue = new SSHPduQueue();
    }

    public void start() {
        this.txChan.start();
        this.rxChan.start();
        if (this.cnChan != null) {
            this.cnChan.start();
        }
    }

    public void waitForExit() throws InterruptedException {
        this.waitForExit(0L);
    }

    public void waitForExit(long l) throws InterruptedException {
        if (this.rxChan != null) {
            this.rxChan.join(l);
        }
        this.killListenChannels();
        if (this.txChan.isAlive()) {
            this.txChan.stop();
        }
        if (this.cnChan != null && this.cnChan.isAlive()) {
            this.cnChan.stop();
        }
    }

    public void killAll() {
        this.killListenChannels();
        if (this.rxChan.isAlive()) {
            this.rxChan.stop();
        }
        if (this.txChan.isAlive()) {
            this.txChan.stop();
        }
        if (this.cnChan != null && this.cnChan.isAlive()) {
            this.cnChan.stop();
        }
    }

    public synchronized int newChannelId() {
        int n = this.nextEmptyChan;
        if (this.nextEmptyChan < this.tunnels.size()) {
            int n2 = this.nextEmptyChan + 1;
            while (n2 < this.tunnels.size()) {
                if (this.tunnels.elementAt(n2) == null) break;
                ++n2;
            }
            this.nextEmptyChan = n2;
        } else {
            this.tunnels.addElement(null);
            ++this.nextEmptyChan;
        }
        return n;
    }

    public synchronized String listTunnels() {
        String string = "";
        int n = 0;
        while (n < this.tunnels.size()) {
            if (this.tunnels.elementAt(n) != null) {
                string = String.valueOf(string) + ((SSHTunnel)this.tunnels.elementAt(n)).getDescription() + "\r\n";
            }
            ++n;
        }
        return string;
    }

    public synchronized void addTunnel(SSHTunnel sSHTunnel) throws IOException {
        this.tunnels.setElementAt(sSHTunnel, sSHTunnel.channelId);
    }

    public synchronized SSHTunnel delTunnel(int n) {
        SSHTunnel sSHTunnel = (SSHTunnel)this.tunnels.elementAt(n);
        this.tunnels.setElementAt(null, n);
        this.nextEmptyChan = n < this.nextEmptyChan ? n : this.nextEmptyChan;
        return sSHTunnel;
    }

    public boolean haveHostInFwdOpen() {
        return this.sshHook.isProtocolFlagSet(2);
    }

    public SSHListenChannel newListenChannel(int n, String string, int n2, String string2) {
        SSHListenChannel sSHListenChannel = null;
        try {
            sSHListenChannel = SSHProtocolPlugin.getPlugin(string2).localListener(n, string, n2, this);
            sSHListenChannel.setSSHChannelListener(this);
            sSHListenChannel.start();
            Vector vector = this.listenChannels;
            synchronized (vector) {
                this.listenChannels.addElement(sSHListenChannel);
            }
        }
        catch (IOException iOException) {
            SSH.log("newListenChannel: " + iOException.toString());
        }
        return sSHListenChannel;
    }

    public void killListenChannel(int n) {
        Vector vector = this.listenChannels;
        synchronized (vector) {
            int n2 = 0;
            while (n2 < this.listenChannels.size()) {
                SSHListenChannel sSHListenChannel = (SSHListenChannel)this.listenChannels.elementAt(n2);
                if (sSHListenChannel.getListenPort() == n) {
                    this.listenChannels.removeElementAt(n2);
                    if (!sSHListenChannel.isAlive()) break;
                    sSHListenChannel.stop();
                    break;
                }
                ++n2;
            }
            return;
        }
    }

    public void killListenChannels() {
        Vector vector = this.listenChannels;
        synchronized (vector) {
            while (this.listenChannels.size() > 0) {
                SSHListenChannel sSHListenChannel = (SSHListenChannel)this.listenChannels.elementAt(0);
                if (sSHListenChannel.isAlive()) {
                    sSHListenChannel.stop();
                }
                this.listenChannels.removeElementAt(0);
            }
            return;
        }
    }

    public SSHPdu prepare(SSHPdu sSHPdu) {
        return sSHPdu;
    }

    public void transmit(SSHPdu sSHPdu) {
        this.txQueue.addLast(sSHPdu);
    }

    public void receive(SSHPdu sSHPdu) {
        SSHPduInputStream sSHPduInputStream = (SSHPduInputStream)sSHPdu;
        try {
            switch (sSHPduInputStream.type) {
                case 17: {
                    if (this.console != null) {
                        this.console.stdoutWriteString(sSHPduInputStream.readString());
                        return;
                    }
                    break;
                }
                case 18: {
                    if (this.console != null) {
                        this.console.stderrWriteString(sSHPduInputStream.readString());
                        return;
                    }
                    break;
                }
                case 20: {
                    SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(33, this.sndCipher);
                    int n = sSHPduInputStream.readInt();
                    if (this.console != null) {
                        if (n != 0) {
                            this.console.serverDisconnect(String.valueOf(this.sshAsClient().getServerAddr().getHostName()) + " disconnected: " + n);
                        } else {
                            this.console.serverDisconnect("Connection to " + this.sshAsClient().getServerAddr().getHostName() + " closed.");
                        }
                    }
                    this.transmit(sSHPduOutputStream);
                    this.sshAsClient().disconnect(true);
                    return;
                }
                case 27: 
                case 29: {
                    this.cnQueue.addLast(sSHPduInputStream);
                    return;
                }
                case 23: {
                    int n = sSHPduInputStream.readInt();
                    SSHTunnel sSHTunnel = (SSHTunnel)this.tunnels.elementAt(n);
                    if (sSHTunnel != null) {
                        sSHTunnel.transmit(sSHPdu);
                        return;
                    }
                    throw new Exception("Data on nonexistent channel: " + n);
                }
                case 21: {
                    int n = sSHPduInputStream.readInt();
                    SSHTunnel sSHTunnel = (SSHTunnel)this.tunnels.elementAt(n);
                    if (sSHTunnel != null) {
                        if (!sSHTunnel.setRemoteChannelId(sSHPduInputStream.readInt())) {
                            throw new Exception("Open confirmation on allready opened channel!");
                        }
                        sSHTunnel.start();
                        return;
                    }
                    throw new Exception("Open confirm on nonexistent: " + n);
                }
                case 22: {
                    int n = sSHPduInputStream.readInt();
                    if (this.delTunnel(n) != null) {
                        throw new Exception("Open failure on nonexistent channel: " + n);
                    }
                    break;
                }
                case 24: {
                    int n = sSHPduInputStream.readInt();
                    SSHTunnel sSHTunnel = (SSHTunnel)this.tunnels.elementAt(n);
                    if (sSHTunnel != null) {
                        sSHTunnel.receiveInputEOF();
                        return;
                    }
                    throw new Exception("Input eof on nonexistent channel: " + n);
                }
                case 25: {
                    int n = sSHPduInputStream.readInt();
                    SSHTunnel sSHTunnel = (SSHTunnel)this.tunnels.elementAt(n);
                    if (sSHTunnel != null) {
                        sSHTunnel.receiveOutputClosed();
                        return;
                    }
                    throw new Exception("Output closed on nonexistent channel: " + n);
                }
                case 1: {
                    this.disconnect("Peer disconnected: " + sSHPduInputStream.readString());
                    return;
                }
                case 19: {
                    System.out.println("!!! EOF received...");
                    return;
                }
                default: {
                    throw new Exception("Unknown packet type (" + sSHPduInputStream.type + "), disconnecting...");
                }
                case 11: 
                case 16: 
                case 33: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            System.out.println("\nplease send a mail to mats@mindbright.se with:");
            System.out.println("(I found a bug in MindTerm!), error: " + exception.getMessage());
            System.out.println(stringWriter.toString());
            this.sendDisconnect("please send a mail to mats@mindbright.se with:\n\r(I found a bug in MindTerm!), error: " + exception.getMessage() + "\n\r" + SSHChannelController.kludgeLF2CRLFMap(stringWriter.toString()));
        }
    }

    static String kludgeLF2CRLFMap(String string) {
        int n;
        int n2 = 0;
        String string2 = "";
        while ((n = string.indexOf(10, n2)) != -1) {
            string2 = String.valueOf(string2) + string.substring(n2, n) + "\n\r";
            n2 = n + 1;
        }
        string2 = String.valueOf(string2) + string.substring(n2);
        return string2;
    }

    public void close(SSHChannel sSHChannel) {
        if (sSHChannel instanceof SSHConnectChannel) {
            SSH.log("Controller connect-channel closed");
            return;
        }
        if (sSHChannel instanceof SSHTxChannel) {
            SSH.log("Controller TX-channel closed");
            return;
        }
        if (sSHChannel instanceof SSHRxChannel) {
            SSH.log("Controller RX-channel closed");
            return;
        }
        if (sSHChannel instanceof SSHListenChannel) {
            SSH.log("Listen channel for port " + ((SSHListenChannel)sSHChannel).getListenPort() + " closed");
            return;
        }
        SSH.log("ERROR: must be a bug !!!");
    }

    public void disconnect(String string) {
        if (this.sshHook instanceof SSHClient) {
            this.sshAsClient().disconnect(false);
        }
        this.txChan.setClosePending();
        if (this.console != null) {
            this.console.serverDisconnect("\r\nDisconnecting, " + string);
        } else {
            SSH.log("\r\nDisconnecting, " + string);
        }
        if (this.sshHook instanceof SSHServer) {
            this.rxChan.forceClose();
        }
    }

    public void sendDisconnect(String string) {
        try {
            SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(1, this.sndCipher);
            sSHPduOutputStream.writeString(string);
            this.txQueue.addFirst(sSHPduOutputStream);
            Thread.sleep(300L);
            this.disconnect(string);
            return;
        }
        catch (Exception exception) {
            SSH.log("Error in sendDisconnect: " + exception.toString());
            return;
        }
    }

    protected SSHClient sshAsClient() {
        return (SSHClient)this.sshHook;
    }

    public SSHPduQueue getCnQueue() {
        return this.cnQueue;
    }

    public void addHostMapTemporary(String string, String string2, int n) {
        this.cnChan.addHostMapTemporary(string, string2, n);
    }

    public void addHostMapPermanent(String string, String string2, int n) {
        this.cnChan.addHostMapPermanent(string, string2, n);
    }

    public void delHostMap(String string) {
        this.cnChan.delHostMap(string);
    }

    public Vector getHostMap(String string) {
        return this.cnChan.getHostMap(string);
    }
}

