/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Vector;
import mindbright.security.KeyPair;
import mindbright.security.MessageDigest;
import mindbright.security.RSACipher;
import mindbright.security.RSAPrivateKey;
import mindbright.security.RSAPublicKey;
import mindbright.security.SecureRandom;
import mindbright.ssh.SSH;
import mindbright.ssh.SSHAuthenticator;
import mindbright.ssh.SSHChannelController;
import mindbright.ssh.SSHClientUser;
import mindbright.ssh.SSHConsole;
import mindbright.ssh.SSHFtpPlugin;
import mindbright.ssh.SSHPduInputStream;
import mindbright.ssh.SSHPduOutputStream;
import mindbright.ssh.SSHProtocolPlugin;
import mindbright.ssh.SSHRSAKeyFile;
import mindbright.terminal.Terminal;

public class SSHClient
extends SSH {
    protected InetAddress serverAddr;
    protected InetAddress localAddr;
    protected String srvVersion;
    protected Vector localForwards;
    protected Vector remoteForwards;
    protected String commandLine;
    protected SSHChannelController controller;
    protected SSHConsole console;
    protected SSHAuthenticator authenticator;
    protected SSHClientUser user;
    protected Socket sshSocket;
    protected BufferedInputStream sshIn;
    protected BufferedOutputStream sshOut;
    protected boolean gracefulExit;
    protected boolean isConnected;
    protected int refCount;

    public SSHClient(SSHAuthenticator sSHAuthenticator, SSHClientUser sSHClientUser) {
        this.user = sSHClientUser;
        this.authenticator = sSHAuthenticator;
        this.localForwards = new Vector();
        this.remoteForwards = new Vector();
        this.srvVersion = null;
        this.refCount = 0;
    }

    public void setConsole(SSHConsole sSHConsole) {
        this.console = sSHConsole;
    }

    public SSHConsole getConsole() {
        return this.console;
    }

    public InetAddress getServerAddr() {
        return this.serverAddr;
    }

    public InetAddress getLocalAddr() {
        return this.localAddr;
    }

    public String getServerVersion() {
        return this.srvVersion;
    }

    public void addLocalPortForward(String string, boolean bl) throws Exception {
        String string2;
        if (string.charAt(0) == '/') {
            int n = string.lastIndexOf(47);
            if (n == 0) {
                throw new Exception("Invalid port forward spec.");
            }
            string2 = string.substring(1, n);
            string = string.substring(n + 1);
        } else {
            string2 = "default";
        }
        int n = string.indexOf(58);
        int n2 = string.lastIndexOf(58);
        if (n == n2) {
            throw new Exception("Invalid port forward spec.");
        }
        String string3 = string.substring(0, n);
        int n3 = Integer.parseInt(string3);
        String string4 = string.substring(n + 1, n2);
        string3 = string.substring(n2 + 1);
        int n4 = Integer.parseInt(string3);
        if (bl) {
            this.delLocalPortForward(n3);
            this.addLocalPortForward(n3, string4, n4, string2);
        }
    }

    public void addLocalPortForward(int n, String string, int n2, String string2) {
        this.localForwards.addElement(new LocalForward(n, string, n2, string2));
        if (this.isConnected) {
            this.requestLocalPortForward(n, string, n2, string2);
        }
    }

    public void delLocalPortForward(int n) {
        if (n == -1) {
            if (this.isConnected) {
                this.controller.killListenChannels();
            }
            this.localForwards = new Vector();
            return;
        }
        int n2 = 0;
        while (n2 < this.localForwards.size()) {
            LocalForward localForward = (LocalForward)this.localForwards.elementAt(n2);
            if (localForward.localPort == n) {
                this.localForwards.removeElementAt(n2);
                if (!this.isConnected) break;
                this.controller.killListenChannel(localForward.localPort);
                return;
            }
            ++n2;
        }
    }

    public int getLocalPortForwardPort(int n) {
        return ((LocalForward)this.localForwards.elementAt((int)n)).localPort;
    }

    public void addRemotePortForward(String string, boolean bl) throws Exception {
        String string2;
        if (string.charAt(0) == '/') {
            int n = string.lastIndexOf(47);
            if (n == 0) {
                throw new Exception("Invalid port forward spec.");
            }
            string2 = string.substring(1, n);
            string = string.substring(n + 1);
        } else {
            string2 = "default";
        }
        int n = string.indexOf(58);
        int n2 = string.lastIndexOf(58);
        if (n == n2) {
            throw new Exception("Invalid port forward spec.");
        }
        String string3 = string.substring(0, n);
        int n3 = Integer.parseInt(string3);
        String string4 = string.substring(n + 1, n2);
        string3 = string.substring(n2 + 1);
        int n4 = Integer.parseInt(string3);
        if (bl) {
            this.delRemotePortForward(n3);
            this.addRemotePortForward(n3, string4, n4, string2);
        }
    }

    public void addRemotePortForward(int n, String string, int n2, String string2) {
        this.remoteForwards.addElement(new RemoteForward(n, string, n2, string2));
    }

    public void delRemotePortForward(String string) {
        int n = 0;
        while (n < this.remoteForwards.size()) {
            RemoteForward remoteForward = (RemoteForward)this.remoteForwards.elementAt(n);
            if (remoteForward.plugin.equals(string)) {
                this.remoteForwards.removeElementAt(n);
                if (this.isConnected) {
                    this.controller.addHostMapPermanent(remoteForward.localHost, "127.0.0.1", 0);
                }
            }
            ++n;
        }
    }

    public void delRemotePortForward(int n) {
        if (n == -1) {
            if (this.isConnected) {
                int n2 = 0;
                while (n2 < this.remoteForwards.size()) {
                    RemoteForward remoteForward = (RemoteForward)this.remoteForwards.elementAt(n2);
                    this.controller.addHostMapPermanent(remoteForward.localHost, "127.0.0.1", 0);
                    ++n2;
                }
            }
            this.remoteForwards = new Vector();
            return;
        }
        int n3 = 0;
        while (n3 < this.remoteForwards.size()) {
            RemoteForward remoteForward = (RemoteForward)this.remoteForwards.elementAt(n3);
            if (remoteForward.remotePort == n) {
                this.remoteForwards.removeElementAt(n3);
                if (!this.isConnected) break;
                this.controller.addHostMapPermanent(remoteForward.localHost, "127.0.0.1", 0);
                return;
            }
            ++n3;
        }
    }

    public int getRemotePortForwardPort(int n) {
        return ((RemoteForward)this.remoteForwards.elementAt((int)n)).remotePort;
    }

    public void startExitMonitor() {
        this.startExitMonitor(0L);
    }

    public void startExitMonitor(long l) {
        new Thread(new ExitMonitor(this, l)).start();
    }

    public synchronized int addRef() {
        return ++this.refCount;
    }

    public void forcedDisconnect() {
        this.controller.sendDisconnect("exit");
    }

    public synchronized int delRef() {
        if (--this.refCount <= 0) {
            this.forcedDisconnect();
            this.waitForExit(2000L);
        }
        return this.refCount;
    }

    public void waitForExit(long l) {
        try {
            this.controller.waitForExit(l);
            return;
        }
        catch (InterruptedException interruptedException) {
            SSH.log("Error when shutting down SSHClient: " + interruptedException.getMessage());
            this.controller.killAll();
            return;
        }
    }

    public void doSingleCommand(String string, boolean bl, long l) throws IOException {
        this.commandLine = string;
        this.bootSSH(false);
        if (bl) {
            this.startExitMonitor(l);
            return;
        }
        this.waitForExit(l);
    }

    public void bootSSH(boolean bl) throws IOException {
        try {
            this.initiatePlugins(bl);
            this.serverAddr = InetAddress.getByName(this.user.getSrvHost());
            this.localAddr = InetAddress.getLocalHost();
            if (this.user.wantPrivileged()) {
                int n = 1023;
                while (n > 512) {
                    try {
                        this.sshSocket = new Socket(this.serverAddr, this.user.getSrvPort(), this.localAddr, n);
                        break;
                    }
                    catch (IOException iOException) {
                        if (iOException.getMessage().toLowerCase().indexOf("use") == -1) {
                            throw iOException;
                        }
                        --n;
                    }
                }
                if (n == 512) {
                    throw new IOException("No available privileged ports");
                }
            } else {
                this.sshSocket = new Socket(this.serverAddr, this.user.getSrvPort());
            }
            this.sshIn = new BufferedInputStream(this.sshSocket.getInputStream(), 8192);
            this.sshOut = new BufferedOutputStream(this.sshSocket.getOutputStream());
            this.negotiateVersion();
            String string = this.authenticator.getUsername(this.user);
            this.isConnected = true;
            this.user.connected(this);
            this.receiveServerData();
            this.cipherType = this.authenticator.getCipher(this.user);
            if (!this.isCipherSupported(this.cipherType)) {
                throw new IOException("Sorry, server does not support the '" + SSH.getCipherName(this.authenticator.getCipher(this.user)) + "' cipher.");
            }
            this.generateSessionId();
            this.generateSessionKey();
            this.initClientCipher();
            this.sendSessionKey(this.cipherType);
            this.authenticateUser(string);
            this.controller = new SSHChannelController(this, this.sshIn, this.sshOut, this.sndCipher, this.rcvCipher, this.console, bl);
            this.initiateSession();
            if (this.console != null) {
                this.console.serverConnect(this.controller, this.sndCipher);
            }
            this.controller.start();
            return;
        }
        catch (IOException iOException) {
            if (this.sshSocket != null) {
                this.sshSocket.close();
            }
            this.disconnect(false);
            throw iOException;
        }
    }

    protected void disconnect(boolean bl) {
        if (!this.isConnected) {
            return;
        }
        this.isConnected = false;
        this.gracefulExit = bl;
        this.user.disconnected(this, bl);
    }

    void negotiateVersion() throws IOException {
        byte[] byArray = new byte[256];
        int n = this.sshIn.read(byArray);
        this.srvVersion = new String(byArray, 0, n);
        if (this.srvVersion.indexOf("SSH-1.5") != 0 && this.srvVersion.indexOf("SSH-1.99") != 0) {
            throw new IOException("Version mismatch, can't talk to server");
        }
        this.srvVersion = this.srvVersion.substring(0, this.srvVersion.length() - 1);
        String string = SSH.getVersionId();
        string = String.valueOf(string) + "\n";
        byArray = string.getBytes();
        this.sshOut.write(byArray);
        this.sshOut.flush();
    }

    void receiveServerData() throws IOException {
        SSHPduInputStream sSHPduInputStream = new SSHPduInputStream(2, null);
        sSHPduInputStream.readFrom(this.sshIn);
        this.srvCookie = new byte[8];
        sSHPduInputStream.read(this.srvCookie, 0, 8);
        int n = sSHPduInputStream.readInt();
        BigInteger bigInteger = sSHPduInputStream.readBigInteger();
        BigInteger bigInteger2 = sSHPduInputStream.readBigInteger();
        this.srvServerKey = new KeyPair(new RSAPublicKey(bigInteger, bigInteger2), null);
        n = sSHPduInputStream.readInt();
        bigInteger = sSHPduInputStream.readBigInteger();
        bigInteger2 = sSHPduInputStream.readBigInteger();
        this.srvHostKey = new KeyPair(new RSAPublicKey(bigInteger, bigInteger2), null);
        if (!this.authenticator.verifyKnownHosts((RSAPublicKey)this.srvHostKey.getPublic())) {
            throw new IOException("Verification of known hosts failed");
        }
        this.protocolFlags = sSHPduInputStream.readInt();
        this.supportedCiphers = sSHPduInputStream.readInt();
        this.supportedAuthTypes = sSHPduInputStream.readInt();
    }

    void generateSessionKey() {
        SecureRandom secureRandom = SSH.secureRandom();
        this.sessionKey = new byte[32];
        secureRandom.nextBytes(this.sessionKey);
    }

    void sendSessionKey(int n) throws IOException {
        byte[] byArray = new byte[this.sessionKey.length + 1];
        byArray[0] = 0;
        System.arraycopy(this.sessionKey, 0, byArray, 1, this.sessionKey.length);
        int n2 = 0;
        while (n2 < this.sessionId.length) {
            int n3 = n2 + 1;
            byArray[n3] = (byte)(byArray[n3] ^ this.sessionId[n2]);
            ++n2;
        }
        BigInteger bigInteger = new BigInteger(byArray);
        if (((RSAPublicKey)this.srvServerKey.getPublic()).bitLength() < ((RSAPublicKey)this.srvHostKey.getPublic()).bitLength()) {
            RSACipher rSACipher = new RSACipher(this.srvServerKey);
            BigInteger bigInteger2 = RSACipher.doPad(bigInteger, ((RSAPublicKey)this.srvServerKey.getPublic()).bitLength(), SSH.secureRandom());
            bigInteger = rSACipher.doPublic(bigInteger2);
            rSACipher = new RSACipher(this.srvHostKey);
            bigInteger2 = RSACipher.doPad(bigInteger, ((RSAPublicKey)this.srvHostKey.getPublic()).bitLength(), SSH.secureRandom());
            bigInteger = rSACipher.doPublic(bigInteger2);
        } else {
            RSACipher rSACipher = new RSACipher(this.srvHostKey);
            BigInteger bigInteger3 = RSACipher.doPad(bigInteger, ((RSAPublicKey)this.srvHostKey.getPublic()).bitLength(), SSH.secureRandom());
            bigInteger = rSACipher.doPublic(bigInteger3);
            rSACipher = new RSACipher(this.srvServerKey);
            bigInteger3 = RSACipher.doPad(bigInteger, ((RSAPublicKey)this.srvServerKey.getPublic()).bitLength(), SSH.secureRandom());
            bigInteger = rSACipher.doPublic(bigInteger3);
        }
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(3, null);
        sSHPduOutputStream.writeByte((byte)n);
        sSHPduOutputStream.write(this.srvCookie, 0, this.srvCookie.length);
        sSHPduOutputStream.writeBigInteger(bigInteger);
        sSHPduOutputStream.writeInt(this.protocolFlags);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (!this.isSuccess()) {
            throw new IOException("Error while sending session key!");
        }
    }

    void authenticateUser(String string) throws IOException {
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(4, this.sndCipher);
        sSHPduOutputStream.writeString(string);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (this.isSuccess()) {
            this.user.report("Authenticated directly by server, no other authentication required");
            return;
        }
        int n = this.authenticator.getAuthType(this.user);
        if (!this.isAuthTypeSupported(n)) {
            throw new IOException("Server does not support '" + SSH.authTypeDesc[n] + "' authentication");
        }
        switch (n) {
            case 2: {
                this.doRSAAuth(false, string);
                return;
            }
            case 3: {
                this.doPasswdAuth(string);
                return;
            }
            case 4: {
                this.doRSAAuth(true, string);
                return;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                throw new IOException("We do not support selected authentication type " + SSH.authTypeDesc[n]);
            }
        }
    }

    void doPasswdAuth(String string) throws IOException {
        String string2 = this.authenticator.getPassword(this.user);
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(9, this.sndCipher);
        sSHPduOutputStream.writeString(string2);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (!this.isSuccess()) {
            throw new IOException("Permission denied");
        }
    }

    void doRSAAuth(boolean bl, String string) throws IOException {
        SSHPduOutputStream sSHPduOutputStream;
        SSHRSAKeyFile sSHRSAKeyFile = this.authenticator.getIdentityFile(this.user);
        RSAPublicKey rSAPublicKey = sSHRSAKeyFile.getPublic();
        if (bl) {
            sSHPduOutputStream = new SSHPduOutputStream(35, this.sndCipher);
            sSHPduOutputStream.writeString(string);
            sSHPduOutputStream.writeInt(rSAPublicKey.bitLength());
            sSHPduOutputStream.writeBigInteger(rSAPublicKey.getE());
            sSHPduOutputStream.writeBigInteger(rSAPublicKey.getN());
        } else {
            sSHPduOutputStream = new SSHPduOutputStream(6, this.sndCipher);
            sSHPduOutputStream.writeBigInteger(rSAPublicKey.getN());
        }
        sSHPduOutputStream.writeTo(this.sshOut);
        SSHPduInputStream sSHPduInputStream = new SSHPduInputStream(-1, this.rcvCipher);
        sSHPduInputStream.readFrom(this.sshIn);
        if (sSHPduInputStream.type == 15) {
            throw new IOException("Server refused our key" + (bl ? " or rhosts" : ""));
        }
        if (sSHPduInputStream.type != 7) {
            throw new IOException("Protocol error, expected RSA-challenge but got " + sSHPduInputStream.type);
        }
        BigInteger bigInteger = sSHPduInputStream.readBigInteger();
        RSAPrivateKey rSAPrivateKey = sSHRSAKeyFile.getPrivate("");
        if (rSAPrivateKey == null) {
            rSAPrivateKey = sSHRSAKeyFile.getPrivate(this.authenticator.getIdentityPassword(this.user));
        }
        if (rSAPrivateKey == null) {
            throw new IOException("Invalid password for key-file '" + sSHRSAKeyFile.getComment() + "'");
        }
        this.rsaChallengeResponse(rSAPrivateKey, bigInteger);
    }

    void rsaChallengeResponse(RSAPrivateKey rSAPrivateKey, BigInteger bigInteger) throws IOException {
        RSACipher rSACipher = new RSACipher(new KeyPair(null, rSAPrivateKey));
        bigInteger = rSACipher.doPrivate(bigInteger);
        bigInteger = RSACipher.stripPad(bigInteger);
        byte[] byArray = bigInteger.toByteArray();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            if (byArray[0] == 0) {
                messageDigest.update(byArray, 1, 32);
            } else {
                messageDigest.update(byArray, 0, 32);
            }
            messageDigest.update(this.sessionId);
            byArray = messageDigest.digest();
        }
        catch (Exception exception) {
            throw new IOException("MD5 not implemented, can't generate session-id");
        }
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(8, this.sndCipher);
        sSHPduOutputStream.write(byArray, 0, byArray.length);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (!this.isSuccess()) {
            throw new IOException("Permission denied");
        }
    }

    void initiateSession() throws IOException {
        int n;
        if (this.user.wantPTY()) {
            this.requestPTY();
        }
        if ((n = this.user.getMaxPacketSz()) > 0) {
            this.requestMaxPacketSz(n);
        }
        if (this.user.wantX11Forward()) {
            this.requestX11Forward();
        }
        this.initiateTunnels();
        if (this.commandLine != null) {
            this.requestCommand(this.commandLine);
            return;
        }
        this.requestShell();
    }

    void initiatePlugins(boolean bl) {
        if (bl) {
            SSHFtpPlugin sSHFtpPlugin = new SSHFtpPlugin();
            SSHProtocolPlugin.addPlugin("ftp", sSHFtpPlugin);
            sSHFtpPlugin.initiate(this);
        }
    }

    void initiateTunnels() throws IOException {
        Object object;
        int n = 0;
        while (n < this.localForwards.size()) {
            object = (LocalForward)this.localForwards.elementAt(n);
            this.requestLocalPortForward(((LocalForward)object).localPort, ((LocalForward)object).remoteHost, ((LocalForward)object).remotePort, ((LocalForward)object).plugin);
            ++n;
        }
        n = 0;
        while (n < this.remoteForwards.size()) {
            object = (RemoteForward)this.remoteForwards.elementAt(n);
            this.requestRemotePortForward(((RemoteForward)object).remotePort, ((RemoteForward)object).localHost, ((RemoteForward)object).localPort, ((RemoteForward)object).plugin);
            ++n;
        }
    }

    void requestCompression(int n) throws IOException {
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(37, this.sndCipher);
        sSHPduOutputStream.writeInt(n);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (!this.isSuccess()) {
            this.user.report("Error requesting compression level: " + n);
        }
    }

    void requestMaxPacketSz(int n) throws IOException {
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(38, this.sndCipher);
        sSHPduOutputStream.writeInt(n);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (!this.isSuccess()) {
            this.user.report("Error requesting max packet size: " + n);
        }
    }

    void requestX11Forward() throws IOException {
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(34, this.sndCipher);
        sSHPduOutputStream.writeString("MIT-MAGIC-COOKIE-1");
        sSHPduOutputStream.writeString("112233445566778899aabbccddeeff00");
        sSHPduOutputStream.writeInt(0);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (!this.isSuccess()) {
            this.user.report("Error requesting X11 forward");
        }
    }

    void requestPTY() throws IOException {
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(10, this.sndCipher);
        Terminal terminal = null;
        if (this.console != null) {
            terminal = this.console.getTerminal();
        }
        if (terminal != null) {
            sSHPduOutputStream.writeString(terminal.terminalType());
            sSHPduOutputStream.writeInt(terminal.rows());
            sSHPduOutputStream.writeInt(terminal.cols());
            sSHPduOutputStream.writeInt(terminal.vpixels());
            sSHPduOutputStream.writeInt(terminal.hpixels());
        } else {
            sSHPduOutputStream.writeString("");
            sSHPduOutputStream.writeInt(0);
            sSHPduOutputStream.writeInt(0);
            sSHPduOutputStream.writeInt(0);
            sSHPduOutputStream.writeInt(0);
        }
        sSHPduOutputStream.writeByte(0);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (!this.isSuccess()) {
            this.user.report("Error requesting PTY");
        }
    }

    void requestLocalPortForward(int n, String string, int n2, String string2) {
        this.controller.newListenChannel(n, string, n2, string2);
    }

    void requestRemotePortForward(int n, String string, int n2, String string2) throws IOException {
        SSHProtocolPlugin.getPlugin(string2).remoteListener(n, string, n2, this.controller);
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(28, this.sndCipher);
        sSHPduOutputStream.writeInt(n);
        sSHPduOutputStream.writeString(string);
        sSHPduOutputStream.writeInt(n2);
        sSHPduOutputStream.writeTo(this.sshOut);
        if (!this.isSuccess()) {
            this.user.report("Error requesting remote port forward: " + string2 + "/" + n + ":" + string + ":" + n2);
        }
    }

    void requestCommand(String string) throws IOException {
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(13, this.sndCipher);
        sSHPduOutputStream.writeString(string);
        sSHPduOutputStream.writeTo(this.sshOut);
    }

    void requestShell() throws IOException {
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(12, this.sndCipher);
        sSHPduOutputStream.writeTo(this.sshOut);
    }

    boolean isSuccess() throws IOException {
        boolean bl = false;
        SSHPduInputStream sSHPduInputStream = null;
        sSHPduInputStream = new SSHPduInputStream(-1, this.rcvCipher);
        sSHPduInputStream.readFrom(this.sshIn);
        if (sSHPduInputStream.type == 14) {
            bl = true;
        } else if (sSHPduInputStream.type == 15) {
            bl = false;
        } else {
            if (sSHPduInputStream.type == 1) {
                throw new IOException("Server disconnected: " + sSHPduInputStream.readString());
            }
            throw new IOException("Protocol error: got " + sSHPduInputStream.type + " when expecting success/failure");
        }
        return bl;
    }

    void setInteractive() {
        try {
            this.sshSocket.setTcpNoDelay(true);
            return;
        }
        catch (SocketException socketException) {
            this.user.report("Error setting interactive mode: " + socketException.getMessage());
            return;
        }
    }

    void stdinWriteChar(char c) {
        this.stdinWriteString(String.valueOf(c));
    }

    void stdinWriteString(String string) {
        try {
            SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(16, this.sndCipher);
            sSHPduOutputStream.writeString(string);
            this.controller.transmit(sSHPduOutputStream);
            return;
        }
        catch (Exception exception) {
            SSH.log("stdinWriteString: " + exception.toString());
            return;
        }
    }

    void stdinWriteString(byte[] byArray) {
        try {
            SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(16, this.sndCipher);
            sSHPduOutputStream.writeInt(byArray.length);
            sSHPduOutputStream.write(byArray, 0, byArray.length);
            this.controller.transmit(sSHPduOutputStream);
            return;
        }
        catch (Exception exception) {
            SSH.log("stdinWriteString: " + exception.toString());
            return;
        }
    }

    void signalWindowChanged(int n, int n2, int n3, int n4) {
        try {
            SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(11, this.sndCipher);
            sSHPduOutputStream.writeInt(n);
            sSHPduOutputStream.writeInt(n2);
            sSHPduOutputStream.writeInt(n3);
            sSHPduOutputStream.writeInt(n4);
            this.controller.transmit(sSHPduOutputStream);
            return;
        }
        catch (Exception exception) {
            SSH.log("sigWinch: " + exception.toString());
            return;
        }
    }

    public static class ExitMonitor
    implements Runnable {
        SSHClient client;
        long msTimeout;

        public ExitMonitor(SSHClient sSHClient, long l) {
            this.msTimeout = l;
            this.client = sSHClient;
        }

        public ExitMonitor(SSHClient sSHClient) {
            this(sSHClient, 0L);
        }

        public void run() {
            this.client.waitForExit(this.msTimeout);
            if (!this.client.gracefulExit) {
                this.client.disconnect(false);
            }
        }
    }

    public static class LocalForward {
        protected int localPort;
        protected String remoteHost;
        protected int remotePort;
        protected String plugin;

        public LocalForward(int n, String string, int n2, String string2) {
            this.localPort = n;
            this.remoteHost = string;
            this.remotePort = n2;
            this.plugin = string2;
        }
    }

    public static class RemoteForward {
        protected int remotePort;
        protected String localHost;
        protected int localPort;
        protected String plugin;

        public RemoteForward(int n, String string, int n2, String string2) {
            this.remotePort = n;
            this.localHost = string;
            this.localPort = n2;
            this.plugin = string2;
        }
    }
}

