/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.io.IOException;
import java.net.Socket;
import mindbright.ssh.SSHChannelController;
import mindbright.ssh.SSHListenChannel;
import mindbright.ssh.SSHPdu;
import mindbright.ssh.SSHTunnel;

public class SSHFtpTunnel
extends SSHTunnel {
    public static final String TUNNEL_NAME = "#FTP";
    public static final int MAX_REMOTE_LISTEN = 8;
    boolean waitingPASVResponse;
    String localAddrPASVStr;
    byte[][] newPortMsg;
    static int timeWaitKludgeToggler;
    static Object timeWaitKludgeCrit;
    static int TUNNEL_FIRST_PORT;

    public SSHFtpTunnel(Socket socket, int n, int n2, SSHChannelController sSHChannelController) throws IOException {
        super(socket, n, n2, sSHChannelController);
        byte[] byArray = sSHChannelController.sshAsClient().getServerAddr().getAddress();
        int n3 = byArray[0] & 0xFF;
        int n4 = byArray[1] & 0xFF;
        int n5 = byArray[2] & 0xFF;
        int n6 = byArray[3] & 0xFF;
        this.newPortMsg = new byte[8][1];
        int n7 = 0;
        while (n7 < 8) {
            int n8 = TUNNEL_FIRST_PORT + n7 >>> 8 & 0xFF;
            int n9 = TUNNEL_FIRST_PORT + n7 & 0xFF;
            String string = "PORT " + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n8 + "," + n9 + "\n";
            this.newPortMsg[n7] = string.getBytes();
            ++n7;
        }
        byte[] byArray2 = sSHChannelController.sshAsClient().getLocalAddr().getAddress();
        n3 = byArray2[0] & 0xFF;
        n4 = byArray2[1] & 0xFF;
        n5 = byArray2[2] & 0xFF;
        n6 = byArray2[3] & 0xFF;
        this.localAddrPASVStr = String.valueOf(n3) + "," + n4 + "," + n5 + "," + n6;
    }

    boolean parseHostAndPort(String string, int[] nArray) {
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        try {
            int n3 = 0;
            while (n3 < 6) {
                if (n3 == 5) {
                    n2 = string.indexOf(41, n);
                    if (n2 == -1) {
                        n2 = string.indexOf(13, n);
                    } else if (n2 == -1) {
                        n2 = string.indexOf(10, n);
                    }
                } else {
                    n2 = string.indexOf(44, n);
                }
                String string2 = string.substring(n, n2);
                n = n2 + 1;
                nArray[n3] = Integer.parseInt(string2);
                ++n3;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public void receive(SSHPdu sSHPdu) {
        String string = new String(sSHPdu.rawData(), sSHPdu.rawOffset(), sSHPdu.rawSize());
        if (string.startsWith("PORT ") || string.startsWith("port ")) {
            int[] nArray;
            if (this.parseHostAndPort(string = string.substring(5), nArray = new int[6])) {
                String string2;
                byte[] byArray;
                byte[] byArray2 = sSHPdu.rawData();
                Object object = timeWaitKludgeCrit;
                synchronized (object) {
                    byArray = this.newPortMsg[timeWaitKludgeToggler];
                    string2 = TUNNEL_NAME + timeWaitKludgeToggler;
                    timeWaitKludgeToggler = (timeWaitKludgeToggler + 1) % 8;
                }
                int n = byArray.length;
                int n2 = sSHPdu.rawOffset() - 4;
                byArray2[n2++] = (byte)(n >>> 24 & 0xFF);
                byArray2[n2++] = (byte)(n >>> 16 & 0xFF);
                byArray2[n2++] = (byte)(n >>> 8 & 0xFF);
                byArray2[n2++] = (byte)(n & 0xFF);
                System.arraycopy(byArray, 0, byArray2, n2, n);
                sSHPdu.rawAdjustSize(n2 + n);
                String string3 = String.valueOf(nArray[0]) + "." + nArray[1] + "." + nArray[2] + "." + nArray[3];
                int n3 = nArray[4] << 8 | nArray[5];
                this.controller.addHostMapTemporary(string2, string3, n3);
            }
        } else if (string.startsWith("PASV") || string.startsWith("pasv")) {
            this.waitingPASVResponse = true;
        }
        super.receive(sSHPdu);
    }

    public void transmit(SSHPdu sSHPdu) {
        String string = new String(sSHPdu.rawData(), sSHPdu.rawOffset(), sSHPdu.rawSize());
        if (this.waitingPASVResponse && string.startsWith("227 ")) {
            int[] nArray;
            this.waitingPASVResponse = false;
            if (this.parseHostAndPort(string = string.substring(27), nArray = new int[6])) {
                String string2 = String.valueOf(nArray[0]) + "." + nArray[1] + "." + nArray[2] + "." + nArray[3];
                int n = nArray[4] << 8 | nArray[5];
                SSHListenChannel sSHListenChannel = this.controller.newListenChannel(0, string2, n, "default");
                sSHListenChannel.setTemporaryListener(true);
                int n2 = sSHListenChannel.getListenPort();
                int n3 = n2 >>> 8 & 0xFF;
                int n4 = n2 & 0xFF;
                string = "227 Entering Passive Mode (" + this.localAddrPASVStr + "," + n3 + "," + n4 + ")\n";
                byte[] byArray = string.getBytes();
                sSHPdu.rawSetData(byArray);
            }
        }
        super.transmit(sSHPdu);
    }

    static {
        timeWaitKludgeCrit = new Object();
    }
}

