/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import mindbright.security.RSAPublicKey;
import mindbright.security.SecureRandom;
import mindbright.ssh.SSH;
import mindbright.ssh.SSHAuthenticator;
import mindbright.ssh.SSHChannelController;
import mindbright.ssh.SSHClient;
import mindbright.ssh.SSHClientUser;
import mindbright.ssh.SSHFtpPlugin;
import mindbright.ssh.SSHListenChannel;
import mindbright.ssh.SSHMenuHandler;
import mindbright.ssh.SSHPduOutputStream;
import mindbright.ssh.SSHRSAKeyFile;
import mindbright.ssh.SSHRSAPublicKeyFile;
import mindbright.ssh.SSHStdIO;
import mindbright.terminal.Terminal;
import mindbright.terminal.TerminalWin;

public final class SSHInteractiveClient
extends SSHClient
implements Runnable,
SSHClientUser,
SSHAuthenticator {
    Thread dumbConsoleThread;
    String sshHomeDir;
    String knownHosts;
    SSHRSAKeyFile keyFile;
    int numOfLocalFwd;
    int numOfRemoteFwd;
    public static final int PROP_NAME = 0;
    public static final int PROP_VALUE = 1;
    public static final int PROP_DESC = 2;
    public static final int PROP_ALLOWED = 3;
    public static final Properties defaultProperties = new Properties();
    public static final String[][] defaultPropDesc = new String[][]{{"server", "", "name of server to connect to", ""}, {"port", String.valueOf(22), "port on server to connect to", ""}, {"usrname", "", "username to login as", ""}, {"cipher", SSH.getCipherName(3), "name of block cipher to use", "( " + SSH.listSupportedCiphers() + ")"}, {"authtyp", "passwd", "method of authentication", "( " + SSH.listSupportedAuthTypes() + ")"}, {"idfile", "identity", "name of file containing identity (rsa-keys)", ""}, {"display", "localhost:0", "display definition (i.e. <host>:<screen>)", ""}, {"mtu", "0", "maximum packet size to use (0 means use default)", "(4096 - 256k)"}, {"escseq", "~$", "sequence of characters to type to enter local command-shell", ""}, {"secrand", "0", "level of security in random-seed (for generating session-key)", "(0-2, 0=low and 2=high)"}, {"x11fwd", "false", "indicates whether X11 display is forwarded or not", "(true/false)"}, {"prvport", "false", "indicates whether to use a privileged port or not (locally)", "(true/false)"}, {"forcpty", "true", "indicates whether to allocate a pty or not", "(true/false)"}, {"remfwd", "false", "indicates whether we allow remote connects to local forwards", "(true/false)"}, {"idhost", "true", "indicates whether to check hosts host-key in 'known_hosts'", "(true/false)"}, {"portftp", "false", "indicates whether to enable ftp 'PORT' command support", "(true/false)"}};
    Properties props;
    boolean propsChanged;
    boolean setPropPending;
    boolean isLoadingProperties;
    protected boolean usePropFiles;
    protected boolean useDefPropOnly;

    public static String copyright() {
        return "Copyright (c) 1998,99 by Mindbright Technology AB, Stockholm, Sweden";
    }

    public SSHInteractiveClient(String string, String string2) {
        super(null, null);
        this.authenticator = this;
        this.user = this;
        this.sshHomeDir = string;
        this.knownHosts = "known_hosts";
        this.setDefaultProperties();
        this.propsChanged = false;
        this.usePropFiles = true;
        this.useDefPropOnly = false;
        this.setPropPending = false;
        this.isLoadingProperties = false;
        this.numOfLocalFwd = 0;
        this.numOfRemoteFwd = 0;
        if (string2 != null) {
            ((Hashtable)this.props).put("usrname", string2);
        }
        this.setConsole(new SSHStdIO());
        ((SSHStdIO)this.console).setClient(this);
    }

    public void printCopyright() {
        this.console.println(SSHInteractiveClient.copyright());
    }

    public void run() {
        this.console.print("Initializing random generator, please wait...");
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {}
        SSH.initSeedGenerator();
        this.console.println("done");
        boolean bl = true;
        while (bl) {
            boolean bl2 = false;
            try {
                this.console.println("");
                this.console.println("(press <ctrl> + <mouse3> for main-menu, or");
                this.console.println(" press <ctrl> + 'D' to enter local command-shell)");
                if (this.isDumb()) {
                    this.console.println("(...you might have to press ENTER also...");
                }
                this.console.println("");
                this.bootSSH(true);
                if (this.isDumb()) {
                    this.startDumbConsole();
                }
                this.controller.waitForExit();
                if (this.isDumb()) {
                    this.stopDumbConsole();
                }
                Thread.sleep(1000L);
            }
            catch (SSHStdIO.CtrlDPressedException ctrlDPressedException) {
                bl2 = true;
            }
            catch (UnknownHostException unknownHostException) {
                this.console.println("Unknown host: " + this.getProperty("server"));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.console.println("File not found: " + fileNotFoundException.getMessage());
            }
            catch (Exception exception) {
                this.console.println("Error connecting to " + this.getProperty("server") + ", reason:");
                this.console.println("-> " + exception.getMessage());
            }
            catch (ThreadDeath threadDeath) {
                if (this.controller != null) {
                    this.controller.killAll();
                }
                if (SSH.bogusThread != null && SSH.bogusThread.isAlive()) {
                    SSH.bogusThread.stop();
                }
                throw threadDeath;
            }
            this.console.println("");
            if (!bl2) continue;
            bl = ((SSHStdIO)this.console).doCommandShell();
        }
    }

    public boolean isDumb() {
        return this.console.getTerminal() == null;
    }

    public TerminalWin getTerminalWin() {
        Terminal terminal = this.console.getTerminal();
        if (terminal != null && terminal instanceof TerminalWin) {
            return (TerminalWin)terminal;
        }
        return null;
    }

    public void startDumbConsole() {
        DumbConsoleThread dumbConsoleThread = new DumbConsoleThread(this.controller, (SSHStdIO)this.console);
        this.dumbConsoleThread = new Thread(dumbConsoleThread);
        this.dumbConsoleThread.start();
    }

    public void stopDumbConsole() {
        this.dumbConsoleThread.stop();
    }

    public String promptLine(String string, String string2, boolean bl) throws IOException {
        return ((SSHStdIO)this.console).promptLine(string, string2, bl);
    }

    public void updateTitle() {
        ((SSHStdIO)this.console).updateTitle();
    }

    public void setSSHHomeDir(String string) {
        if (!string.endsWith(File.separator)) {
            string = String.valueOf(string) + File.separator;
        }
        this.sshHomeDir = string;
    }

    public String getSSHHomeDir() {
        return this.sshHomeDir;
    }

    public void setUsePropertyFiles(boolean bl) {
        this.usePropFiles = bl;
    }

    public void setUseOnlyDefaultProperties(boolean bl) {
        this.useDefPropOnly = bl;
    }

    public Properties mergeProperties(Properties properties, Properties properties2) {
        String string;
        Properties properties3 = new Properties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            ((Hashtable)properties3).put(string, properties.getProperty(string));
        }
        if (properties2 != null) {
            enumeration = properties2.propertyNames();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                ((Hashtable)properties3).put(string, properties2.getProperty(string));
            }
        }
        return properties3;
    }

    public void setDefaultProperties() {
        this.props = this.mergeProperties(defaultProperties, null);
    }

    public boolean loadDefaultProperties() {
        return this.loadProperties("mindterm_def");
    }

    public boolean saveDefaultProperties() {
        return this.saveProperties("mindterm_def");
    }

    public boolean saveCurrentProperties() {
        boolean bl = true;
        if (this.useDefPropOnly) {
            if (this.propsChanged && (bl = this.saveProperties("mindterm_def"))) {
                this.console.println("Saved default property-file.");
            }
        } else {
            String string = this.getProperty("server");
            if (string != null && !string.equals("") && this.propsChanged && (bl = this.saveProperties(string))) {
                this.console.println("Saved property-file '" + this.sshHomeDir + string + ".mtprops" + "'.");
            }
        }
        return bl;
    }

    public boolean loadProperties(String string) {
        if (!this.usePropFiles) {
            return true;
        }
        TerminalWin terminalWin = this.getTerminalWin();
        try {
            try {
                FileInputStream fileInputStream = new FileInputStream(String.valueOf(this.sshHomeDir) + string + ".mtprops");
                Properties properties = new Properties();
                properties.load(fileInputStream);
                this.isLoadingProperties = true;
                this.numOfLocalFwd = 0;
                this.numOfRemoteFwd = 0;
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    try {
                        try {
                            this.setProperty(string2, properties.getProperty(string2));
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            if (terminalWin == null) continue;
                            try {
                                terminalWin.setProperty(string2, properties.getProperty(string2));
                            }
                            catch (NoSuchElementException noSuchElementException2) {
                                this.console.println("No such property: " + string2);
                            }
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.console.println(illegalArgumentException.getMessage());
                    }
                }
            }
            catch (IOException iOException) {
                boolean bl = false;
                Object var6_9 = null;
                this.isLoadingProperties = false;
                return bl;
            }
            Object var6_10 = null;
            this.isLoadingProperties = false;
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            this.isLoadingProperties = false;
            throw throwable;
        }
        return true;
    }

    public boolean saveProperties(String string) {
        Object object;
        if (!this.usePropFiles) {
            return true;
        }
        File file = new File(this.sshHomeDir);
        if (!file.exists()) {
            try {
                object = this.promptLine("Directory '" + this.sshHomeDir + "' does not exist, create it (yes/no)? ", "", false);
                if (((String)object).equalsIgnoreCase("yes") || ((String)object).equals("y")) {
                    file.mkdir();
                }
            }
            catch (IOException iOException) {}
        }
        Properties properties = this.getTerminalWin() != null ? this.getTerminalWin().getProperties() : null;
        try {
            object = new FileOutputStream(String.valueOf(this.sshHomeDir) + string + ".mtprops");
            this.props.save((OutputStream)object, "MindTerm ssh-properties");
            if (properties != null) {
                properties.save((OutputStream)object, "MindTerm terminal-properties");
            }
            ((FileOutputStream)object).close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    /*
     * Unable to fully structure code
     */
    public void setProperty(String var1_1, String var2_2) throws IllegalArgumentException, NoSuchElementException {
        var3_3 = var2_2.equals(this.getProperty(var1_1)) == false;
        var4_4 = false;
        if (var1_1.equals("cipher")) {
            if (SSH.getCipherType(var2_2) == 8) {
                throw new IllegalArgumentException("cipher " + var2_2 + " not supported");
            }
        } else if (var1_1.equals("authtyp")) {
            if (SSH.getAuthType(var2_2) == SSH.AUTH_NOTSUPPORTED) {
                throw new IllegalArgumentException("authtype " + var2_2 + " not supported");
            }
        } else if (var1_1.equals("x11fwd") || var1_1.equals("prvport") || var1_1.equals("forcpty") || var1_1.equals("remfwd") || var1_1.equals("idhost") || var1_1.equals("portftp")) {
            if (!var2_2.equals("true") && !var2_2.equals("false")) {
                throw new IllegalArgumentException("value for " + var1_1 + " must be 'true' or 'false'");
            }
            if (var1_1.equals("remfwd")) {
                SSHListenChannel.setAllowRemoteConnect(new Boolean(var2_2));
            } else if (var1_1.equals("portftp")) {
                SSHFtpPlugin.supportPORT = new Boolean(var2_2);
            }
        } else if (var1_1.equals("port") || var1_1.equals("mtu") || var1_1.equals("secrand")) {
            try {
                var5_5 = Integer.valueOf(var2_2);
                if (var1_1.equals("port") && (var5_5 > 65535 || var5_5 < 0)) {
                    throw new IllegalArgumentException("not a valid port number: " + var2_2);
                }
                if (var1_1.equals("mtu") && var5_5 != 0 && (var5_5 > 262144 || var5_5 < 4096)) {
                    throw new IllegalArgumentException("mtu must be between 4k and 256k");
                }
                if (!var1_1.equals("secrand")) ** GOTO lbl83
                if (var5_5 < 0 || var5_5 > 2) {
                    throw new IllegalArgumentException("secrand must be 0-2");
                }
                SecureRandom.secureLevel = var5_5;
            }
            catch (NumberFormatException v0) {
                throw new IllegalArgumentException("value for " + var1_1 + " must be an integer");
            }
        } else if (var1_1.equals("server")) {
            if (!this.setPropPending) {
                if (this.isConnected) {
                    throw new IllegalArgumentException("server can only be set while not connected");
                }
                var5_6 = this.getProperty("server");
                if (!var5_6.equals(var2_2)) {
                    if (!this.useDefPropOnly) {
                        if (!this.saveCurrentProperties()) {
                            this.console.println("Error saving property-file for '" + var5_6 + "'.");
                        }
                        this.setPropPending = true;
                        if (!this.loadProperties(var2_2)) {
                            this.console.println("No property-file found for '" + var2_2 + "', will be created later.");
                        } else {
                            var4_4 = true;
                            var3_3 = false;
                        }
                        this.setPropPending = false;
                    }
                } else {
                    var3_3 = false;
                }
            }
        } else if (!(var1_1.equals("usrname") || var1_1.equals("idfile") || var1_1.equals("display") || var1_1.equals("escseq"))) {
            if (var1_1.startsWith("local")) {
                try {
                    var5_7 = Integer.parseInt(var1_1.substring(5));
                    if (!this.isLoadingProperties && var5_7 > this.numOfLocalFwd) {
                        throw new IllegalArgumentException("port forwards must be given in sequence");
                    }
                    if (this.isLoadingProperties) {
                        ++this.numOfLocalFwd;
                    } else if (var5_7 == this.numOfLocalFwd) {
                        ++this.numOfLocalFwd;
                    }
                    this.addLocalPortForward(var2_2, true);
                }
                catch (Exception v1) {
                    throw new IllegalArgumentException("not a valid port forward: " + var1_1 + " : " + var2_2);
                }
            } else if (var1_1.startsWith("remote")) {
                try {
                    var5_8 = Integer.parseInt(var1_1.substring(6));
                    if (!this.isLoadingProperties && var5_8 > this.numOfRemoteFwd) {
                        throw new IllegalArgumentException("port forwards must be given in sequence");
                    }
                    if (this.isLoadingProperties) {
                        ++this.numOfRemoteFwd;
                    } else if (var5_8 == this.numOfRemoteFwd) {
                        ++this.numOfRemoteFwd;
                    }
                    this.addRemotePortForward(var2_2, true);
                }
                catch (Exception v2) {
                    throw new IllegalArgumentException("not a valid port forward: " + var1_1 + " : " + var2_2);
                }
            } else {
                throw new NoSuchElementException("unknown ssh-property '" + var1_1 + "'");
            }
        }
lbl83:
        // 12 sources

        if (!this.propsChanged || var4_4) {
            this.propsChanged = var3_3;
        }
        this.props.put(var1_1, var2_2);
        this.updateTitle();
    }

    public Enumeration propertyNames() {
        return this.props.propertyNames();
    }

    public int getNumOfLocalForwards() {
        return this.numOfLocalFwd;
    }

    public int getNumOfRemoteForwards() {
        return this.numOfRemoteFwd;
    }

    public String getUsername(SSHClientUser sSHClientUser) throws IOException {
        String string = this.getProperty("usrname");
        if (this.commandLine == null || string == null) {
            string = this.promptLine(String.valueOf(this.getProperty("server")) + " login: ", string, false);
            this.setProperty("usrname", string);
        }
        return string;
    }

    public String getPassword(SSHClientUser sSHClientUser) throws IOException {
        String string = this.promptLine(String.valueOf(this.getProperty("usrname")) + "@" + this.getProperty("server") + "'s password: ", "", true);
        return string;
    }

    public int getAuthType(SSHClientUser sSHClientUser) {
        return SSH.getAuthType(this.getProperty("authtyp"));
    }

    public int getCipher(SSHClientUser sSHClientUser) {
        return SSH.getCipherType(this.getProperty("cipher"));
    }

    public SSHRSAKeyFile getIdentityFile(SSHClientUser sSHClientUser) throws IOException {
        this.keyFile = new SSHRSAKeyFile(String.valueOf(this.sshHomeDir) + File.separator + this.getProperty("idfile"));
        return this.keyFile;
    }

    public String getIdentityPassword(SSHClientUser sSHClientUser) throws IOException {
        String string = this.promptLine("key-file '" + this.keyFile.getComment() + "' password: ", "", true);
        return string;
    }

    public boolean verifyKnownHosts(RSAPublicKey rSAPublicKey) throws IOException {
        int n;
        Object object;
        String string;
        if (!Boolean.valueOf(this.getProperty("idhost")).booleanValue()) {
            return true;
        }
        String string2 = String.valueOf(this.sshHomeDir) + File.separator + this.knownHosts;
        File file = new File(string2);
        if (!file.exists()) {
            string = this.promptLine("File '" + string2 + "' not found, do you want to create it (yes/no)? ", "", false);
            if (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("y")) {
                object = new FileOutputStream(file);
                ((FileOutputStream)object).close();
            } else {
                throw new IOException("When 'idhost' is true, file 'known_hosts' must be accessible for read/write");
            }
        }
        if ((n = ((SSHRSAPublicKeyFile)(object = new SSHRSAPublicKeyFile(string2, true))).checkPublic(rSAPublicKey.getN(), this.getProperty("server"))) == SSH.SRV_HOSTKEY_KNOWN) {
            return true;
        }
        if (n == SSH.SRV_HOSTKEY_NEW) {
            this.console.println("Host key not found from the list of known hosts.");
            string = this.promptLine("Do you want to add this host to your set of known hosts (yes/no)? ", "", false);
        } else {
            this.console.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
            this.console.println("@       WARNING: HOST IDENTIFICATION HAS CHANGED!         @");
            this.console.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
            this.console.println("IT IS POSSIBLE THAT SOMEONE IS DOING SOMETHING NASTY,");
            this.console.println("ONLY PROCEED IF YOU KNOW WHAT YOU ARE DOING!");
            string = this.promptLine("Do you want to replace the identification of this host (yes/no)? ", "", false);
            ((SSHRSAPublicKeyFile)object).removePublic(this.getProperty("server"));
        }
        if (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("y")) {
            ((SSHRSAPublicKeyFile)object).addPublic(this.getProperty("server"), null, rSAPublicKey.getE(), rSAPublicKey.getN());
            file = new File(String.valueOf(string2) + ".tmp");
            File file2 = new File(string2);
            file2.renameTo(file);
            try {
                ((SSHRSAPublicKeyFile)object).saveToFile(string2);
            }
            catch (IOException iOException) {
                file2 = new File(string2);
                file.renameTo(file2);
                throw iOException;
            }
        } else {
            return false;
        }
        file.delete();
        return true;
    }

    public String getSrvHost() throws IOException {
        String string = this.getProperty("server");
        if (this.commandLine == null || string == null) {
            string = this.promptLine("SSH-server: ", string, false);
            this.setProperty("server", string);
        }
        return string;
    }

    public int getSrvPort() {
        return Integer.valueOf(this.getProperty("port"));
    }

    public String getDisplay() {
        return this.getProperty("display");
    }

    public int getMaxPacketSz() {
        return Integer.valueOf(this.getProperty("mtu"));
    }

    public boolean wantX11Forward() {
        return Boolean.valueOf(this.getProperty("x11fwd"));
    }

    public boolean wantPrivileged() {
        return Boolean.valueOf(this.getProperty("prvport"));
    }

    public boolean wantPTY() {
        return Boolean.valueOf(this.getProperty("forcpty"));
    }

    public void connected(SSHClient sSHClient) {
        SSHMenuHandler.updateMenus();
        this.updateTitle();
        this.console.println("Connected to server running " + this.srvVersion);
        this.console.println("(command-shell escape-sequence is '" + ((SSHStdIO)this.console).escapeString + "')");
        this.console.println("");
    }

    public void disconnected(SSHClient sSHClient, boolean bl) {
        SSHMenuHandler.updateMenus();
        this.srvVersion = null;
        this.updateTitle();
    }

    public void report(String string) {
        this.console.println(string);
        this.console.println("");
    }

    static {
        int n = 0;
        while (n < defaultPropDesc.length) {
            ((Hashtable)defaultProperties).put(defaultPropDesc[n][0], defaultPropDesc[n][1]);
            ++n;
        }
    }

    public static class DumbConsoleThread
    implements Runnable {
        SSHChannelController controller;
        SSHStdIO console;

        public DumbConsoleThread(SSHChannelController sSHChannelController, SSHStdIO sSHStdIO) {
            this.controller = sSHChannelController;
            this.console = sSHStdIO;
        }

        public void run() {
            try {
                while (true) {
                    String string = this.console.promptLine("", "", false);
                    SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(16, this.console.sndCipher);
                    sSHPduOutputStream.writeString(String.valueOf(string) + "\n");
                    this.controller.transmit(sSHPduOutputStream);
                    Thread.sleep(400L);
                }
            }
            catch (SSHStdIO.CtrlDPressedException ctrlDPressedException) {
                this.controller.sendDisconnect("exit");
                return;
            }
            catch (Exception exception) {
                SSH.log("console-thread: " + exception.toString());
                return;
            }
        }
    }
}

