/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import mindbright.ssh.SSH;
import mindbright.ssh.SSHChannel;
import mindbright.ssh.SSHChannelController;
import mindbright.ssh.SSHPduOutputStream;
import mindbright.ssh.SSHTunnel;

public class SSHListenChannel
extends SSHChannel {
    static boolean allowRemoteConnect;
    SSHChannelController controller;
    ServerSocket listenSocket;
    String remoteHost;
    int remotePort;
    InetAddress localHost1;
    InetAddress localHost2;
    boolean temporaryListener;

    public SSHListenChannel(int n, String string, int n2, SSHChannelController sSHChannelController) throws IOException {
        super(-3);
        this.controller = sSHChannelController;
        this.listenSocket = new ServerSocket(n);
        this.remoteHost = string;
        this.remotePort = n2;
        this.localHost1 = InetAddress.getLocalHost();
        this.localHost2 = InetAddress.getByName("127.0.0.1");
    }

    public int getListenPort() {
        return this.listenSocket.getLocalPort();
    }

    public static synchronized void setAllowRemoteConnect(boolean bl) {
        allowRemoteConnect = bl;
    }

    static synchronized boolean getAllowRemoteConnect() {
        return allowRemoteConnect;
    }

    public SSHTunnel newTunnel(Socket socket, int n, int n2, SSHChannelController sSHChannelController) throws IOException {
        return new SSHTunnel(socket, n, n2, sSHChannelController);
    }

    public void setTemporaryListener(boolean bl) {
        this.temporaryListener = bl;
    }

    public void serviceLoop() throws IOException {
        SSH.log("Starting listen-chan: " + this.listenSocket.getLocalPort());
        while (true) {
            Socket socket = this.listenSocket.accept();
            if (!(SSHListenChannel.getAllowRemoteConnect() || socket.getInetAddress().equals(this.localHost1) || socket.getInetAddress().equals(this.localHost2))) {
                SSH.log("Remote connect rejected: " + socket.getInetAddress());
                socket.close();
                continue;
            }
            SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(29, this.controller.sndCipher);
            int n = this.controller.newChannelId();
            SSHTunnel sSHTunnel = this.newTunnel(socket, n, -4, this.controller);
            this.controller.addTunnel(sSHTunnel);
            sSHTunnel.setRemoteDesc(String.valueOf(this.remoteHost) + ":" + this.remotePort);
            sSHPduOutputStream.writeInt(n);
            sSHPduOutputStream.writeString(this.remoteHost);
            sSHPduOutputStream.writeInt(this.remotePort);
            SSH.log("got connect for: " + this.remoteHost + " : " + this.remotePort + ", " + n);
            sSHPduOutputStream.writeString(socket.getInetAddress().getHostAddress());
            this.controller.transmit(sSHPduOutputStream);
            if (this.temporaryListener) break;
        }
        this.listenSocket.close();
    }
}

