/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import mindbright.ssh.SSH;
import mindbright.ssh.SSHInteractiveClient;
import mindbright.ssh.SSHMenuHandler;
import mindbright.ssh.SSHStdIO;
import mindbright.terminal.TerminalWin;

public class SSHMenuHandler {
    SSHInteractiveClient client;
    Frame parent;
    TerminalWin term;
    static SSHMenuHandler menus;
    MenuItem disconnect;
    MenuItem loadDef;
    MenuItem saveDef;
    MenuItem commandSh;
    MenuItem genKey;
    Dialog settingsDialog;
    Choice choiceCipher;
    Choice choiceAuthTyp;
    Choice choiceX11;
    Choice choicePrvPrt;
    Choice choiceRemFwd;
    Choice choiceIdHost;
    TextField textSrv;
    TextField textPort;
    TextField textUser;
    TextField textId;
    TextField textDisp;
    TextField textMtu;
    Label lblAlert;
    Label lblSrv;
    String[] cipher;
    String[] authtyp;
    String[] bool;
    Panel srvPanel;
    CardLayout srvCard;
    TunnelEditor localEdit;
    TunnelEditor remoteEdit;
    Dialog tunnelDialog;

    public SSHMenuHandler(SSHInteractiveClient sSHInteractiveClient, Frame frame, TerminalWin terminalWin) {
        this.client = sSHInteractiveClient;
        this.parent = frame;
        this.term = terminalWin;
        menus = this;
    }

    public MenuItem getMindTermMenu() {
        Menu menu = new Menu("MindTerm Main");
        this.disconnect = new MenuItem("Disconnect from sshd");
        menu.add(this.disconnect);
        this.loadDef = new MenuItem("Load default properties");
        menu.add(this.loadDef);
        this.saveDef = new MenuItem("Save default properties");
        menu.add(this.saveDef);
        this.commandSh = new MenuItem("Local command-shell");
        menu.add(this.commandSh);
        this.genKey = new MenuItem("Generate identity (RSA key-pair)");
        menu.add(this.genKey);
        this.disconnect.addActionListener(new 1());
        this.loadDef.addActionListener(new 2());
        this.saveDef.addActionListener(new 3());
        this.commandSh.addActionListener(new 4());
        this.genKey.addActionListener(new 5());
        this.genKey.setEnabled(false);
        this.updateMindTermMenu();
        return menu;
    }

    public void updateMindTermMenu() {
        if (this.client.isConnected) {
            this.disconnect.setEnabled(true);
            this.loadDef.setEnabled(false);
            if (this.client.useDefPropOnly || !this.client.usePropFiles) {
                this.saveDef.setEnabled(false);
            } else {
                this.saveDef.setEnabled(true);
            }
            this.commandSh.setEnabled(true);
            return;
        }
        this.disconnect.setEnabled(false);
        if (this.client.useDefPropOnly || !this.client.usePropFiles) {
            this.loadDef.setEnabled(false);
            this.saveDef.setEnabled(false);
        } else {
            this.loadDef.setEnabled(true);
            this.saveDef.setEnabled(true);
        }
        this.commandSh.setEnabled(false);
    }

    public static void updateMenus() {
        menus.updateMindTermMenu();
    }

    public MenuItem getSettingsMenu() {
        MenuItem menuItem = new MenuItem("SSH Settings");
        menuItem.addActionListener(new 6());
        return menuItem;
    }

    public MenuItem getTunnelsMenu() {
        MenuItem menuItem = new MenuItem("SSH Tunnels");
        menuItem.addActionListener(new 7());
        return menuItem;
    }

    public final void sshSettingsMenu() {
        this.cipher = SSH.getCiphers();
        this.authtyp = SSH.getAuthTypes();
        this.bool = new String[2];
        this.bool[0] = "true";
        this.bool[1] = "false";
        this.settingsDialog = new 8(this.parent, "SSH Settings", true);
        this.settingsDialog.setLayout(new BorderLayout(5, 5));
        Panel panel = new Panel(new GridLayout(12, 2, 2, 2));
        panel.add(new Label("Server:"));
        this.srvCard = new CardLayout();
        this.srvPanel = new Panel(this.srvCard);
        this.textSrv = new TextField("", 12);
        this.srvPanel.add("text", this.textSrv);
        this.lblSrv = new Label("");
        this.srvPanel.add("label", this.lblSrv);
        panel.add(this.srvPanel);
        panel.add(new Label("Port:"));
        this.textPort = new TextField("", 12);
        panel.add(this.textPort);
        panel.add(new Label("Username:"));
        this.textUser = new TextField("", 12);
        panel.add(this.textUser);
        panel.add(new Label("Cipher:"));
        this.choiceCipher = new Choice();
        int n = 0;
        while (n < this.cipher.length) {
            this.choiceCipher.add(this.cipher[n]);
            ++n;
        }
        panel.add(this.choiceCipher);
        panel.add(new Label("Type of auth.:"));
        this.choiceAuthTyp = new Choice();
        n = 0;
        while (n < this.authtyp.length) {
            this.choiceAuthTyp.add(this.authtyp[n]);
            ++n;
        }
        panel.add(this.choiceAuthTyp);
        panel.add(new Label("Identity file:"));
        this.textId = new TextField("", 12);
        panel.add(this.textId);
        panel.add(new Label("Display (x11-fwd):"));
        this.textDisp = new TextField("", 12);
        panel.add(this.textDisp);
        panel.add(new Label("Max. pkt size:"));
        this.textMtu = new TextField("", 12);
        panel.add(this.textMtu);
        panel.add(new Label("Allow X11 forward:"));
        this.choiceX11 = new Choice();
        this.choiceX11.add(this.bool[0]);
        this.choiceX11.add(this.bool[1]);
        panel.add(this.choiceX11);
        panel.add(new Label("Use priv. src. port:"));
        this.choicePrvPrt = new Choice();
        this.choicePrvPrt.add(this.bool[0]);
        this.choicePrvPrt.add(this.bool[1]);
        panel.add(this.choicePrvPrt);
        panel.add(new Label("Allow remote conn.:"));
        this.choiceRemFwd = new Choice();
        this.choiceRemFwd.add(this.bool[0]);
        this.choiceRemFwd.add(this.bool[1]);
        panel.add(this.choiceRemFwd);
        panel.add(new Label("Check ID of server:"));
        this.choiceIdHost = new Choice();
        this.choiceIdHost.add(this.bool[0]);
        this.choiceIdHost.add(this.bool[1]);
        panel.add(this.choiceIdHost);
        this.settingsDialog.add((Component)panel, "Center");
        panel = new Panel(new GridLayout(2, 1, 3, 3));
        this.lblAlert = new Label("", 1);
        panel.add(this.lblAlert);
        Panel panel2 = new Panel(new FlowLayout());
        Button button = new Button("Cancel");
        panel2.add(button);
        button.addActionListener(new 9());
        button = new Button("OK");
        panel2.add(button);
        button.addActionListener(new 10());
        panel.add(panel2);
        this.settingsDialog.add((Component)panel, "South");
        this.settingsDialog.setResizable(false);
        this.settingsDialog.pack();
        ((TextComponent)this.textSrv).setText(this.client.getProperty("server"));
        this.lblSrv.setText(this.client.getProperty("server"));
        if (!this.client.isConnected) {
            this.srvCard.first(this.srvPanel);
        } else {
            this.srvCard.last(this.srvPanel);
        }
        ((TextComponent)this.textPort).setText(this.client.getProperty("port"));
        ((TextComponent)this.textUser).setText(this.client.getProperty("usrname"));
        this.choiceCipher.select(this.client.getProperty("cipher"));
        this.choiceAuthTyp.select(this.client.getProperty("authtyp"));
        ((TextComponent)this.textId).setText(this.client.getProperty("idfile"));
        ((TextComponent)this.textDisp).setText(this.client.getProperty("display"));
        ((TextComponent)this.textMtu).setText(this.client.getProperty("mtu"));
        this.choiceX11.select(this.client.getProperty("x11fwd"));
        this.choicePrvPrt.select(this.client.getProperty("prvport"));
        this.choiceRemFwd.select(this.client.getProperty("remfwd"));
        this.choiceIdHost.select(this.client.getProperty("idhost"));
        this.lblAlert.setText("");
        this.placeDialog(this.settingsDialog);
        ((Component)this.settingsDialog).setVisible(true);
    }

    public final void sshTunnelsMenu() {
        if (this.tunnelDialog == null) {
            this.tunnelDialog = new 11(this.parent, "SSH Tunnels", true);
            this.tunnelDialog.setLayout(new BorderLayout(5, 5));
            this.localEdit = new TunnelEditor("Local: ([/plug/]<loc-prt>:<rem-host>:<rem-prt>)", new 12());
            this.tunnelDialog.add((Component)this.localEdit, "North");
            this.remoteEdit = new TunnelEditor("Remote: ([/plug/]<rem-prt>:<loc-host>:<loc-prt>)", new 13());
            this.tunnelDialog.add((Component)this.remoteEdit, "Center");
            Panel panel = new Panel(new FlowLayout());
            Button button = new Button("Cancel");
            panel.add(button);
            button.addActionListener(new 14());
            button = new Button("OK");
            panel.add(button);
            button.addActionListener(new 15());
            this.tunnelDialog.add((Component)panel, "South");
            this.tunnelDialog.setResizable(false);
            this.tunnelDialog.pack();
        } else {
            this.localEdit.removeAll();
            this.remoteEdit.removeAll();
        }
        int n = 0;
        while (n < this.client.getNumOfLocalForwards()) {
            this.localEdit.addToList(this.client.getProperty("local" + n));
            ++n;
        }
        n = 0;
        while (n < this.client.getNumOfRemoteForwards()) {
            this.remoteEdit.addToList(this.client.getProperty("remote" + n));
            ++n;
        }
        this.placeDialog(this.tunnelDialog);
        ((Component)this.tunnelDialog).setVisible(true);
    }

    void placeDialog(Dialog dialog) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = dialog.getSize();
        int n = dimension.width / 2 - dimension2.width / 2;
        int n2 = dimension.height / 2 - dimension2.height / 2;
        ((Component)dialog).setLocation(n, n2);
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SSHMenuHandler.this.client.forcedDisconnect();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SSHMenuHandler.this.client.loadDefaultProperties();
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SSHMenuHandler.this.client.saveDefaultProperties();
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SSHMenuHandler.this.client.console.println("");
            SSHMenuHandler.this.client.console.println("** hit a key to enter local command-shell **");
            ((SSHStdIO)SSHMenuHandler.this.client.console).wantCommandShell();
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SSHMenuHandler.this.sshSettingsMenu();
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SSHMenuHandler.this.sshTunnelsMenu();
        }

        /* synthetic */ 7() {
        }
    }

    private final class 8
    extends Dialog {
        public Insets getInsets() {
            Insets insets = super.getInsets();
            insets.left = 5;
            insets.right = 5;
            insets.bottom += 5;
            insets.top += 5;
            return insets;
        }

        /* synthetic */ 8(Frame frame, String string, boolean bl) {
            super(frame, string, bl);
        }
    }

    private final class 9
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ((Component)SSHMenuHandler.this.settingsDialog).setVisible(false);
        }

        /* synthetic */ 9() {
        }
    }

    private final class 10
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (!SSHMenuHandler.this.client.isConnected) {
                    SSHMenuHandler.this.client.setProperty("server", SSHMenuHandler.this.textSrv.getText());
                }
                SSHMenuHandler.this.client.setProperty("port", SSHMenuHandler.this.textPort.getText());
                SSHMenuHandler.this.client.setProperty("usrname", SSHMenuHandler.this.textUser.getText());
                SSHMenuHandler.this.client.setProperty("cipher", SSHMenuHandler.this.cipher[SSHMenuHandler.this.choiceCipher.getSelectedIndex()]);
                SSHMenuHandler.this.client.setProperty("authtyp", SSHMenuHandler.this.authtyp[SSHMenuHandler.this.choiceAuthTyp.getSelectedIndex()]);
                SSHMenuHandler.this.client.setProperty("idfile", SSHMenuHandler.this.textId.getText());
                SSHMenuHandler.this.client.setProperty("display", SSHMenuHandler.this.textDisp.getText());
                SSHMenuHandler.this.client.setProperty("mtu", SSHMenuHandler.this.textMtu.getText());
                SSHMenuHandler.this.client.setProperty("x11fwd", SSHMenuHandler.this.bool[SSHMenuHandler.this.choiceX11.getSelectedIndex()]);
                SSHMenuHandler.this.client.setProperty("prvport", SSHMenuHandler.this.bool[SSHMenuHandler.this.choicePrvPrt.getSelectedIndex()]);
                SSHMenuHandler.this.client.setProperty("remfwd", SSHMenuHandler.this.bool[SSHMenuHandler.this.choiceRemFwd.getSelectedIndex()]);
                SSHMenuHandler.this.client.setProperty("idhost", SSHMenuHandler.this.bool[SSHMenuHandler.this.choiceIdHost.getSelectedIndex()]);
                ((Component)SSHMenuHandler.this.settingsDialog).setVisible(false);
                return;
            }
            catch (Exception exception) {
                SSHMenuHandler.this.lblAlert.setText(exception.getMessage());
                return;
            }
        }

        /* synthetic */ 10() {
        }
    }

    private final class 11
    extends Dialog {
        public Insets getInsets() {
            Insets insets = super.getInsets();
            insets.left = 5;
            insets.right = 5;
            insets.bottom += 5;
            insets.top += 5;
            return insets;
        }

        /* synthetic */ 11(Frame frame, String string, boolean bl) {
            super(frame, string, bl);
        }
    }

    private final class 12
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                SSHMenuHandler.this.client.addLocalPortForward(SSHMenuHandler.this.localEdit.getText(), false);
                SSHMenuHandler.this.localEdit.addToList(SSHMenuHandler.this.localEdit.getText());
                return;
            }
            catch (Exception exception) {
                SSHMenuHandler.this.localEdit.selectText();
                return;
            }
        }

        /* synthetic */ 12() {
        }
    }

    private final class 13
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                SSHMenuHandler.this.client.addRemotePortForward(SSHMenuHandler.this.remoteEdit.getText(), false);
                SSHMenuHandler.this.remoteEdit.addToList(SSHMenuHandler.this.remoteEdit.getText());
                return;
            }
            catch (Exception exception) {
                SSHMenuHandler.this.remoteEdit.selectText();
                return;
            }
        }

        /* synthetic */ 13() {
        }
    }

    private final class 14
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ((Component)SSHMenuHandler.this.tunnelDialog).setVisible(false);
        }

        /* synthetic */ 14() {
        }
    }

    private final class 15
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int n = 0;
            while (n < SSHMenuHandler.this.localEdit.getItemCount()) {
                SSHMenuHandler.this.client.setProperty("local" + n, SSHMenuHandler.this.localEdit.getItem(n));
                ++n;
            }
            n = 0;
            while (n < SSHMenuHandler.this.remoteEdit.getItemCount()) {
                SSHMenuHandler.this.client.setProperty("remote" + n, SSHMenuHandler.this.remoteEdit.getItem(n));
                ++n;
            }
            ((Component)SSHMenuHandler.this.tunnelDialog).setVisible(false);
        }

        /* synthetic */ 15() {
        }
    }

    protected class TunnelEditor
    extends Panel {
        List list;
        TextField text;
        boolean isLocal;

        public TunnelEditor(String string, ActionListener actionListener) {
            super(new BorderLayout(5, 5));
            SSHMenuHandler.this = SSHMenuHandler.this;
            this.add((Component)new Label(string), "North");
            this.list = new List(5, false);
            this.add((Component)this.list, "Center");
            Panel panel = new Panel(new FlowLayout());
            this.text = new TextField("", 18);
            panel.add(this.text);
            Button button = new Button("Add");
            panel.add(button);
            button.addActionListener(actionListener);
            button = new Button("Delete");
            panel.add(button);
            button.addActionListener(new 16(this));
            this.add((Component)panel, "South");
            this.list.addActionListener(new 17(this));
        }

        public int getItemCount() {
            return this.list.getItemCount();
        }

        public String getItem(int n) {
            return this.list.getItem(n);
        }

        public void addToList(String string) {
            this.list.add(string);
        }

        public void selectText() {
            this.text.selectAll();
        }

        public String getText() {
            return this.text.getText();
        }

        public void removeAll() {
            this.list.removeAll();
        }
    }
}

