/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import mindbright.security.Cipher;
import mindbright.ssh.SSH;
import mindbright.ssh.SSHDataInputStream;
import mindbright.ssh.SSHPdu;
import mindbright.util.CRC32;

public class SSHPduInputStream
extends SSHDataInputStream
implements SSHPdu {
    public int type;
    public int length;
    byte[] bytes;
    Cipher cipher;

    SSHPduInputStream(int n, Cipher cipher) {
        super(null);
        this.type = n;
        this.cipher = cipher;
    }

    boolean validChecksum() throws IOException {
        int n = this.length + 8 & 0xFFFFFFF8;
        this.skip(n - 4);
        int n2 = this.readInt();
        this.reset();
        int n3 = (int)CRC32.getValue(this.bytes, 0, n - 4);
        return n3 == n2;
    }

    public SSHPdu createPdu() {
        return new SSHPduInputStream(this.type, this.cipher);
    }

    public void readFrom(InputStream inputStream) throws IOException {
        SSHDataInputStream sSHDataInputStream = new SSHDataInputStream(inputStream);
        int n = sSHDataInputStream.readInt();
        int n2 = n + 8 & 0xFFFFFFF8;
        if (n2 > 256000) {
            throw new IOException("Corrupt incoming packet, too large");
        }
        byte[] byArray = new byte[n2];
        sSHDataInputStream.readFully(byArray);
        if (this.cipher != null) {
            byArray = this.cipher.decrypt(byArray);
        }
        this.in = new PduByteArrayInputStream(byArray);
        this.bytes = byArray;
        this.length = n;
        if (!this.validChecksum()) {
            throw new IOException("Invalid checksum in packet");
        }
        this.skip(8 - n % 8);
        byte by = this.readByte();
        if (by == 36) {
            SSH.logDebug("MSG_DEBUG: " + this.readString());
            this.readFrom(inputStream);
            return;
        }
        if (by == 32) {
            SSH.logIgnore(this);
            this.readFrom(inputStream);
            return;
        }
        if (this.type != -1 && this.type != by) {
            if (by == 1) {
                throw new IOException("Server disconnected: " + this.readString());
            }
            throw new IOException("Invalid type: " + by + " (expected: " + this.type + ")");
        }
        this.type = by;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (this.type != 23 && this.type != 17 && this.type != 18) {
            throw new IOException("Trying to write raw data from non-data PDU");
        }
        int n = this.readInt();
        PduByteArrayInputStream pduByteArrayInputStream = (PduByteArrayInputStream)this.in;
        outputStream.write(this.bytes, pduByteArrayInputStream.getPos(), n);
        outputStream.flush();
    }

    public byte[] rawData() {
        return this.bytes;
    }

    public void rawSetData(byte[] byArray) {
        PduByteArrayInputStream pduByteArrayInputStream = (PduByteArrayInputStream)this.in;
        this.bytes = new byte[byArray.length + 4];
        pduByteArrayInputStream.setPos(0);
        int n = byArray.length;
        int n2 = 0;
        this.bytes[n2++] = (byte)(n >>> 24 & 0xFF);
        this.bytes[n2++] = (byte)(n >>> 16 & 0xFF);
        this.bytes[n2++] = (byte)(n >>> 8 & 0xFF);
        this.bytes[n2++] = (byte)(n & 0xFF);
        System.arraycopy(byArray, 0, this.bytes, n2, byArray.length);
        pduByteArrayInputStream.setBuf(this.bytes);
    }

    public int rawOffset() {
        PduByteArrayInputStream pduByteArrayInputStream = (PduByteArrayInputStream)this.in;
        return pduByteArrayInputStream.getPos() + 4;
    }

    public int rawSize() {
        PduByteArrayInputStream pduByteArrayInputStream = (PduByteArrayInputStream)this.in;
        int n = pduByteArrayInputStream.getPos();
        int n2 = this.bytes[n++] + 256 & 0xFF;
        int n3 = this.bytes[n++] + 256 & 0xFF;
        int n4 = this.bytes[n++] + 256 & 0xFF;
        int n5 = this.bytes[n] + 256 & 0xFF;
        return (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
    }

    public void rawAdjustSize(int n) {
        PduByteArrayInputStream pduByteArrayInputStream = (PduByteArrayInputStream)this.in;
        int n2 = this.rawSize();
        if (n >= n2) {
            return;
        }
        int n3 = pduByteArrayInputStream.getPos() + (n2 - n);
        pduByteArrayInputStream.setPos(n3);
        this.bytes[n3++] = (byte)(n >>> 24 & 0xFF);
        this.bytes[n3++] = (byte)(n >>> 16 & 0xFF);
        this.bytes[n3++] = (byte)(n >>> 8 & 0xFF);
        this.bytes[n3++] = (byte)(n & 0xFF);
    }

    static class PduByteArrayInputStream
    extends ByteArrayInputStream {
        PduByteArrayInputStream(byte[] byArray) {
            super(byArray);
        }

        public int getPos() {
            return this.pos;
        }

        public void setPos(int n) {
            this.pos = n;
        }

        public byte[] getBuf() {
            return this.buf;
        }

        public void setBuf(byte[] byArray) {
            this.buf = byArray;
        }
    }
}

