/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import mindbright.security.Cipher;
import mindbright.security.SecureRandom;
import mindbright.ssh.SSH;
import mindbright.ssh.SSHDataOutputStream;
import mindbright.ssh.SSHPdu;
import mindbright.util.CRC32;

public class SSHPduOutputStream
extends SSHDataOutputStream
implements SSHPdu {
    public static final int SSH_DEFAULT_PKT_LEN = 8192;
    public static int mtu = 8192;
    byte[] readFromRawData;
    int readFromOff;
    int readFromSize;
    public int type;
    public Cipher cipher;

    public static synchronized void setMTU(int n) {
        mtu = n;
    }

    public static synchronized int getMTU() {
        return mtu;
    }

    SSHPduOutputStream(Cipher cipher) {
        super(null);
        this.cipher = cipher;
    }

    SSHPduOutputStream(int n, Cipher cipher) throws IOException {
        super(new PduByteArrayOutputStream(SSHPduOutputStream.getMTU()));
        this.type = n;
        this.cipher = cipher;
        if (cipher != null) {
            SecureRandom secureRandom = SSH.secureRandom();
            byte[] byArray = new byte[8];
            secureRandom.nextBytes(byArray);
            int n2 = 0;
            while (n2 < 8) {
                this.write(byArray[n2]);
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < 8) {
                this.write(0);
                ++n3;
            }
        }
        this.write(n);
    }

    public SSHPdu createPdu() {
        SSHPduOutputStream sSHPduOutputStream;
        try {
            sSHPduOutputStream = new SSHPduOutputStream(this.type, this.cipher);
        }
        catch (IOException iOException) {
            sSHPduOutputStream = null;
        }
        return sSHPduOutputStream;
    }

    public void readFrom(InputStream inputStream) throws IOException {
        if (this.type != 23 && this.type != 16) {
            throw new IOException("Trying to read raw data into non-data PDU");
        }
        PduByteArrayOutputStream pduByteArrayOutputStream = (PduByteArrayOutputStream)this.out;
        this.readFromRawData = pduByteArrayOutputStream.getBuf();
        this.readFromOff = pduByteArrayOutputStream.size() + 4;
        this.readFromSize = inputStream.read(this.readFromRawData, this.readFromOff, SSHPduOutputStream.getMTU() - this.readFromOff);
        if (this.readFromSize == -1) {
            throw new IOException("EOF");
        }
        this.writeInt(this.readFromSize);
        pduByteArrayOutputStream.setCount(this.readFromOff + this.readFromSize);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        PduByteArrayOutputStream pduByteArrayOutputStream = (PduByteArrayOutputStream)this.out;
        int n = (pduByteArrayOutputStream.size() + 4) % 8;
        byte[] byArray = new byte[pduByteArrayOutputStream.size() + 4 - n];
        int n2 = (int)CRC32.getValue(pduByteArrayOutputStream.getBuf(), n, pduByteArrayOutputStream.size() - n);
        this.writeInt(n2);
        System.arraycopy(pduByteArrayOutputStream.getBuf(), n, byArray, 0, byArray.length);
        if (this.cipher != null) {
            byArray = this.cipher.encrypt(byArray);
        }
        pduByteArrayOutputStream = new PduByteArrayOutputStream();
        pduByteArrayOutputStream.setBuf(byArray);
        pduByteArrayOutputStream.setCount(byArray.length);
        this.out = pduByteArrayOutputStream;
        outputStream = new SSHDataOutputStream(outputStream);
        ((SSHDataOutputStream)outputStream).writeInt(pduByteArrayOutputStream.getCount() - (8 - n));
        pduByteArrayOutputStream.writeTo(outputStream);
        outputStream.flush();
    }

    public byte[] rawData() {
        return this.readFromRawData;
    }

    public void rawSetData(byte[] byArray) {
    }

    public int rawOffset() {
        return this.readFromOff;
    }

    public int rawSize() {
        byte[] byArray = this.readFromRawData;
        int n = this.readFromOff - 4;
        int n2 = byArray[n++] + 256 & 0xFF;
        int n3 = byArray[n++] + 256 & 0xFF;
        int n4 = byArray[n++] + 256 & 0xFF;
        int n5 = byArray[n] + 256 & 0xFF;
        return (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
    }

    public void rawAdjustSize(int n) {
        PduByteArrayOutputStream pduByteArrayOutputStream = (PduByteArrayOutputStream)this.out;
        pduByteArrayOutputStream.setCount(n);
    }

    static class PduByteArrayOutputStream
    extends ByteArrayOutputStream {
        PduByteArrayOutputStream() {
        }

        PduByteArrayOutputStream(int n) {
            super(n);
        }

        public byte[] getBuf() {
            return this.buf;
        }

        public int getCount() {
            return this.count;
        }

        public void setBuf(byte[] byArray) {
            this.buf = byArray;
        }

        public void setCount(int n) {
            this.count = n;
        }
    }
}

