/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.util.Vector;
import mindbright.ssh.SSHPdu;

public final class SSHPduQueue {
    Vector queue = new Vector();
    boolean isWaiting = false;
    int maxDepth = 65535;
    int curDepth = 0;

    public void setMaxDepth(int n) {
        Vector vector = this.queue;
        synchronized (vector) {
            this.maxDepth = n;
            return;
        }
    }

    public void addLast(SSHPdu sSHPdu) {
        Vector vector = this.queue;
        synchronized (vector) {
            if (this.curDepth++ < this.maxDepth) {
                this.queue.addElement(sSHPdu);
            }
            if (this.isWaiting) {
                this.queue.notify();
            }
            return;
        }
    }

    public void addFirst(SSHPdu sSHPdu) {
        Vector vector = this.queue;
        synchronized (vector) {
            if (this.curDepth++ < this.maxDepth) {
                this.queue.insertElementAt(sSHPdu, 0);
            }
            if (this.isWaiting) {
                this.queue.notify();
            }
            return;
        }
    }

    public void release() {
        Vector vector = this.queue;
        synchronized (vector) {
            if (this.isWaiting) {
                this.queue.notify();
            }
            return;
        }
    }

    public boolean isEmpty() {
        boolean bl;
        Vector vector = this.queue;
        synchronized (vector) {
            bl = this.queue.isEmpty();
        }
        return bl;
    }

    public SSHPdu getFirst() {
        SSHPdu sSHPdu = null;
        Vector vector = this.queue;
        synchronized (vector) {
            if (this.queue.isEmpty()) {
                this.isWaiting = true;
                try {
                    this.queue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.isWaiting = false;
            try {
                sSHPdu = (SSHPdu)this.queue.firstElement();
                this.queue.removeElementAt(0);
                --this.curDepth;
            }
            catch (Exception exception) {
                sSHPdu = null;
            }
        }
        return sSHPdu;
    }
}

