/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Vector;
import mindbright.security.RSAPublicKey;
import mindbright.ssh.SSH;
import mindbright.ssh.SSHRSAPublicKeyString;

public class SSHRSAPublicKeyFile {
    Vector pubKeyList;

    public SSHRSAPublicKeyFile(String string, boolean bl) throws IOException {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        this.pubKeyList = new Vector();
        while ((string2 = bufferedReader.readLine()) != null) {
            String string3;
            if ((string2 = string2.trim()).equals("") || string2.charAt(0) == '#') continue;
            if (bl) {
                int n = string2.indexOf(32);
                string3 = string2.substring(0, n);
                string2 = string2.substring(n);
            } else {
                string3 = "";
            }
            try {
                SSHRSAPublicKeyString sSHRSAPublicKeyString = SSHRSAPublicKeyString.createKey(string3, string2);
                this.pubKeyList.addElement(sSHRSAPublicKeyString);
            }
            catch (Exception exception) {
                throw new IOException("Corrupt public keys file: " + string);
            }
        }
        fileInputStream.close();
    }

    public void saveToFile(String string) throws IOException {
        FileWriter fileWriter = new FileWriter(string);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        SSHRSAPublicKeyString sSHRSAPublicKeyString = null;
        Enumeration enumeration = this.elements();
        try {
            while (enumeration.hasMoreElements()) {
                sSHRSAPublicKeyString = (SSHRSAPublicKeyString)enumeration.nextElement();
                String string2 = sSHRSAPublicKeyString.toString();
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.newLine();
            }
        }
        catch (Exception exception) {
            throw new IOException("Error while writing public-keys-file: " + string);
        }
        bufferedWriter.flush();
        bufferedWriter.close();
        fileWriter.close();
    }

    public Enumeration elements() {
        return this.pubKeyList.elements();
    }

    public RSAPublicKey getPublic(BigInteger bigInteger, String string) {
        SSHRSAPublicKeyString sSHRSAPublicKeyString = null;
        Enumeration enumeration = this.pubKeyList.elements();
        while (enumeration.hasMoreElements()) {
            sSHRSAPublicKeyString = (SSHRSAPublicKeyString)enumeration.nextElement();
            if (sSHRSAPublicKeyString.getN().equals(bigInteger)) break;
            sSHRSAPublicKeyString = null;
        }
        return sSHRSAPublicKeyString;
    }

    public int checkPublic(BigInteger bigInteger, String string) {
        SSHRSAPublicKeyString sSHRSAPublicKeyString = null;
        int n = SSH.SRV_HOSTKEY_NEW;
        Enumeration enumeration = this.pubKeyList.elements();
        while (enumeration.hasMoreElements()) {
            sSHRSAPublicKeyString = (SSHRSAPublicKeyString)enumeration.nextElement();
            if (!sSHRSAPublicKeyString.getOpts().equals(string)) continue;
            if (sSHRSAPublicKeyString.getN().equals(bigInteger)) {
                n = SSH.SRV_HOSTKEY_KNOWN;
                break;
            }
            n = SSH.SRV_HOSTKEY_CHANGED;
            break;
        }
        return n;
    }

    public void addPublic(String string, String string2, BigInteger bigInteger, BigInteger bigInteger2) {
        SSHRSAPublicKeyString sSHRSAPublicKeyString = new SSHRSAPublicKeyString(string, string2, bigInteger, bigInteger2);
        this.pubKeyList.addElement(sSHRSAPublicKeyString);
    }

    public void removePublic(String string) {
        SSHRSAPublicKeyString sSHRSAPublicKeyString = null;
        Enumeration enumeration = this.pubKeyList.elements();
        while (enumeration.hasMoreElements()) {
            sSHRSAPublicKeyString = (SSHRSAPublicKeyString)enumeration.nextElement();
            if (!sSHRSAPublicKeyString.getOpts().equals(string)) continue;
            this.pubKeyList.removeElement(sSHRSAPublicKeyString);
            return;
        }
    }
}

