/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.awt.Container;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import mindbright.security.Cipher;
import mindbright.security.KeyPair;
import mindbright.ssh.SSH;
import mindbright.ssh.SSHChannelController;
import mindbright.ssh.SSHClient;
import mindbright.ssh.SSHConsole;
import mindbright.ssh.SSHInteractiveClient;
import mindbright.terminal.Terminal;
import mindbright.terminal.TerminalListener;
import mindbright.terminal.TerminalWin;

public final class SSHStdIO
implements TerminalListener,
SSHConsole {
    static Toolkit toolkit = Toolkit.getDefaultToolkit();
    Container ownerContainer;
    SSHChannelController controller = null;
    SSHInteractiveClient client;
    Terminal term;
    Cipher sndCipher = null;
    String ownerName;
    int escapeIdx;
    String escapeString = "~$";
    boolean escapeForced = false;
    Boolean readLineLock = new Boolean(false);
    boolean pressedCtrlD;
    boolean isReadingLine;
    boolean echoStar;
    String readLineStr;
    protected boolean isConnected = false;

    public boolean isConnected() {
        return this.isConnected;
    }

    public void setTerminal(Terminal terminal) {
        this.term = terminal;
        if (terminal != null) {
            terminal.addTerminalListener(this);
        }
    }

    public void setClient(SSHInteractiveClient sSHInteractiveClient) {
        this.client = sSHInteractiveClient;
    }

    public void setOwnerContainer(Container container) {
        this.ownerContainer = container;
    }

    public void setOwnerName(String string) {
        this.ownerName = string;
    }

    public String readLine(String string) {
        Boolean bl = this.readLineLock;
        synchronized (bl) {
            if (string != null) {
                this.readLineStr = string;
                this.term.write(string);
            } else {
                this.readLineStr = "";
            }
            this.isReadingLine = true;
            try {
                this.readLineLock.wait();
            }
            catch (InterruptedException interruptedException) {}
            this.isReadingLine = false;
        }
        return this.readLineStr;
    }

    public String promptLine(String string, String string2, boolean bl) throws IOException {
        String string3 = null;
        this.pressedCtrlD = false;
        if (this.term != null) {
            this.term.setAttribute(1, true);
            this.term.write(string);
            this.term.setAttribute(1, false);
            this.echoStar = bl;
            string3 = this.readLine(string2);
            this.echoStar = false;
        } else {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            System.out.print(string);
            string3 = bufferedReader.readLine();
            if (string3 == null || string3.charAt(0) == '\u0004') {
                this.pressedCtrlD = true;
            }
        }
        if (this.pressedCtrlD) {
            this.pressedCtrlD = false;
            throw new CtrlDPressedException();
        }
        return string3;
    }

    public void updateTitle() {
        int n = 0;
        int n2 = 0;
        if (this.term == null || this.ownerContainer == null) {
            return;
        }
        String string = null;
        if (this.term instanceof TerminalWin) {
            string = ((TerminalWin)this.term).getTitle();
        }
        if (string == null) {
            n = this.term.rows();
            n2 = this.term.cols();
            string = String.valueOf(this.ownerName) + " - ";
            if (this.client.getProperty("usrname") != null) {
                string = String.valueOf(string) + this.client.getProperty("usrname");
            }
            if (this.client.getProperty("server") != null) {
                string = String.valueOf(string) + "@" + this.client.getProperty("server");
                string = this.client.getServerVersion() != null ? String.valueOf(string) + " <" + this.client.getServerVersion() + ">" : String.valueOf(string) + " <not connected>";
            } else {
                string = String.valueOf(string) + " <server not known>";
            }
            string = String.valueOf(string) + " [" + n2 + "x" + n + "]";
        }
        if (this.ownerContainer instanceof Frame) {
            ((Frame)this.ownerContainer).setTitle(string);
        }
    }

    public String getNextArg(String string) {
        int n = string.indexOf(32);
        if (n > -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public String[] makeArgv(String string) {
        String[] stringArray = new String[32];
        int n = 0;
        while (string != null) {
            stringArray[n++] = this.getNextArg(string);
            int n2 = string.indexOf(32);
            if (n2 > -1) {
                string = string.substring(n2);
                string = string.trim();
                continue;
            }
            string = null;
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        return stringArray2;
    }

    public void doHelp() {
        this.println("The following commands are available:");
        this.println("");
        this.println("go                                    Start SSH-session with current settings.");
        this.println("quit                                  Quit program (or disconnect if connected).");
        this.println("add <l|r> [/<plug>/]<port>:<host>:<port>  (see below).");
        this.println("del <l|r> <listen-port>|*             Delete local/remote forward (* = all).");
        this.println("list [ssh | term]                     Lists ssh- and/or terminal-settings.");
        this.println("set [<parameter> <value>]             Set value of a ssh-parameter.");
        this.println("tset [<parameter> <value>]            Set value of a terminal-parameter.");
        this.println("key [<bits>]                          Generate RSA key-pair (of length <bits>).");
        this.println("help                                  Display this list, but you knew that :-).");
        this.println("");
        this.println("(do 'set' without arguments to list parameter-usage)");
        this.println("");
        this.println("Examples of adding a remote/local tunnel:");
        this.println("> add r 4711:www.foo.com:80           Adds a remote tunnel at port 4711 back to");
        this.println("                                      www.foo.com port 80 without a plugin,");
        this.println("                                      i.e. default tunneling behaviour.");
        this.println("> add l /ftp/4711:ftp.bar.com:21      Adds a local tunnel going to ftp.bar.com");
        this.println("                                      port 21 using the ftp protocol-plugin to");
        this.println("                                      handle protocol specific needs.");
        this.println("");
        this.println("NOTE: The first character of the command can be used instead of the full word.");
        this.println("NOTE2: Sometimes ftp-forward to localhost/127.0.0.1 fails, use hostname instead.");
        this.println("");
    }

    public void doHelpSet() {
        this.println("SSH-parameters:");
        this.println("");
        int n = 0;
        while (n < SSHInteractiveClient.defaultPropDesc.length) {
            this.println(String.valueOf(SSHInteractiveClient.defaultPropDesc[n][0]) + "\t: " + SSHInteractiveClient.defaultPropDesc[n][2]);
            ++n;
        }
        this.println("(to see possible parameter-values use 'list')");
    }

    public void doHelpTSet() {
        this.println("Terminal-parameters:");
        this.println("");
        int n = 0;
        while (n < TerminalWin.defaultPropDesc.length) {
            this.println(String.valueOf(TerminalWin.defaultPropDesc[n][0]) + "\t: " + TerminalWin.defaultPropDesc[n][2]);
            ++n;
        }
        this.println("(to see possible parameter-values use 'list')");
    }

    public void doAdd(String[] stringArray) {
        if (stringArray.length < 3 || !stringArray[1].equals("l") && !stringArray[1].equals("r")) {
            this.doHelp();
            return;
        }
        try {
            if (stringArray[1].equals("l")) {
                this.client.setProperty("local" + this.client.getNumOfLocalForwards(), stringArray[2]);
                return;
            }
            this.client.setProperty("remote" + this.client.getNumOfRemoteForwards(), stringArray[2]);
            return;
        }
        catch (Exception exception) {
            this.doHelp();
            return;
        }
    }

    public void doDel(String[] stringArray) {
        if (stringArray.length < 3 || !stringArray[1].equals("l") && !stringArray[1].equals("r")) {
            this.doHelp();
            return;
        }
        try {
            int n = stringArray[2].equals("*") ? -1 : Integer.parseInt(stringArray[2]);
            if (stringArray[1].equals("l")) {
                this.client.delLocalPortForward(n);
                return;
            }
            this.client.delRemotePortForward(n);
            return;
        }
        catch (Exception exception) {
            this.doHelp();
            return;
        }
    }

    public void doListSSH() {
        Object object;
        this.println("");
        if (this.term != null) {
            this.term.setAttribute(1, true);
        }
        this.println("SSH settings:");
        if (this.term != null) {
            this.term.setAttribute(1, false);
        }
        int n = 0;
        while (n < SSHInteractiveClient.defaultPropDesc.length) {
            object = SSHInteractiveClient.defaultPropDesc[n][0];
            String string = this.client.getProperty((String)object);
            this.println(String.valueOf(object) + "\t: " + (string.equals("") ? "<not set>" : string) + " " + SSHInteractiveClient.defaultPropDesc[n][3]);
            ++n;
        }
        this.println("");
        this.println("local tunnels:");
        n = 0;
        while (n < this.client.localForwards.size()) {
            object = (SSHClient.LocalForward)this.client.localForwards.elementAt(n);
            this.println("\tlocal:  " + ((SSHClient.LocalForward)object).localPort + "\tremote: " + ((SSHClient.LocalForward)object).remoteHost + "/" + ((SSHClient.LocalForward)object).remotePort + " (plugin: " + ((SSHClient.LocalForward)object).plugin + ")");
            ++n;
        }
        if (n == 0) {
            this.println("\t<none>");
        }
        this.println("remote tunnels:");
        n = 0;
        while (n < this.client.remoteForwards.size()) {
            object = (SSHClient.RemoteForward)this.client.remoteForwards.elementAt(n);
            this.println("\tremote: " + ((SSHClient.RemoteForward)object).remotePort + "\tlocal:  " + ((SSHClient.RemoteForward)object).localHost + "/" + ((SSHClient.RemoteForward)object).localPort + " (plugin: " + ((SSHClient.RemoteForward)object).plugin + ")");
            ++n;
        }
        if (n == 0) {
            this.println("\t<none>");
        }
        this.println("");
        if (this.client.isConnected) {
            if (this.term != null) {
                this.term.setAttribute(1, true);
            }
            this.println("Currently active tunnels:");
            if (this.term != null) {
                this.term.setAttribute(1, false);
            }
            if (((String)(object = this.controller.listTunnels())).equals("")) {
                this.print("<none>");
            } else {
                this.print((String)object);
            }
            this.println("");
        }
    }

    public void doListTerm() {
        this.println("");
        if (this.term != null) {
            TerminalWin terminalWin = (TerminalWin)this.term;
            this.term.setAttribute(1, true);
            this.println("Terminal settings:");
            this.term.setAttribute(1, false);
            int n = 0;
            while (n < TerminalWin.defaultPropDesc.length) {
                String string = TerminalWin.defaultPropDesc[n][0];
                this.println(String.valueOf(string) + "\t: " + terminalWin.getProperty(string) + " " + TerminalWin.defaultPropDesc[n][3]);
                ++n;
            }
            this.println("");
        }
    }

    public void doSet(String[] stringArray) {
        if (stringArray.length < 3) {
            this.doHelpSet();
            return;
        }
        try {
            String string = stringArray[1];
            String string2 = stringArray[2];
            this.client.setProperty(string, string2);
            return;
        }
        catch (Exception exception) {
            this.println(exception.getMessage());
            this.println("(use 'set' without parameters to get help on available parameters)");
            return;
        }
    }

    public void doTSet(String[] stringArray) {
        if (stringArray.length < 3) {
            this.doHelpTSet();
            return;
        }
        String string = stringArray[1];
        String string2 = stringArray[2];
        TerminalWin terminalWin = null;
        if (this.term instanceof TerminalWin) {
            terminalWin = (TerminalWin)this.term;
        }
        if (terminalWin != null) {
            try {
                terminalWin.setProperty(string, string2);
                return;
            }
            catch (Exception exception) {
                this.println(exception.getMessage());
                this.println("(use 'tset' without parameters to get help on available parameters)");
                return;
            }
        }
        this.println("Can't set terminal-parameters in dumb-console mode.");
    }

    public void doGenKey(String[] stringArray) {
        int n = 1024;
        this.println("");
        if (stringArray.length > 1) {
            try {
                n = Integer.parseInt(stringArray[1]);
            }
            catch (Exception exception) {
                this.println("(invalid <bits>, using default 1024)");
            }
        }
        try {
            String string;
            this.println("The key-pair will be stored in a file with the name you enter.");
            this.println("Files are stored in '" + this.client.getSSHHomeDir() + "' if no path is given.");
            this.println("(note: the public key will also be stored in a file with ext. '.pub')");
            String string2 = this.promptLine("Filename to save identity in: ", "", false);
            if (!string2.startsWith(File.separator)) {
                string2 = String.valueOf(this.client.getSSHHomeDir()) + string2;
            }
            while (!(string = this.promptLine("Password to protect private key: ", "", true)).equals(this.promptLine("Password again: ", "", true))) {
            }
            String string3 = this.promptLine("Comment to store in key-files: ", "", false);
            this.print("Generating identity of length " + n + "...");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            KeyPair keyPair = SSH.generateRSAKeyPair(n);
            this.println("done");
            SSH.generateKeyFiles(keyPair, string2, string, string3);
        }
        catch (Exception exception) {
            this.println("An error occured while generating key...");
        }
        this.println("");
    }

    public boolean doCommandShell() {
        boolean bl = true;
        this.println("");
        this.println("...entering local command-shell (type 'h' for help).");
        this.println("");
        try {
            boolean bl2 = true;
            while (bl2) {
                String string = this.promptLine("mindterm> ", null, false);
                string = string.toLowerCase();
                if ((string = string.trim()).equals("")) continue;
                String[] stringArray = this.makeArgv(string);
                String string2 = stringArray[0];
                if (string2.equals("l") || string2.equals("list")) {
                    if (stringArray.length > 1) {
                        if (stringArray[1].equals("ssh") || stringArray[1].equals("term")) {
                            if (stringArray[1].equals("ssh")) {
                                this.doListSSH();
                            } else {
                                this.doListTerm();
                            }
                            this.println("(permitted values are in parentheses on the right)");
                            this.println("");
                            continue;
                        }
                        this.println("usage: 'list [ssh | term]'");
                        continue;
                    }
                    this.doListSSH();
                    this.doListTerm();
                    this.println("(permitted values are in parentheses on the right)");
                    this.println("");
                    continue;
                }
                if (string2.equals("a") || string2.equals("add")) {
                    this.doAdd(stringArray);
                    continue;
                }
                if (string2.equals("d") || string2.equals("del")) {
                    this.doDel(stringArray);
                    continue;
                }
                if (string2.equals("s") || string2.equals("set")) {
                    this.doSet(stringArray);
                    continue;
                }
                if (string2.equals("t") || string2.equals("ts") || string2.equals("tset")) {
                    this.doTSet(stringArray);
                    continue;
                }
                if (string2.equals("help") || string2.equals("?") || string2.equals("h")) {
                    this.doHelp();
                    continue;
                }
                if (string2.equals("go") || string2.equals("g")) {
                    bl = true;
                    bl2 = false;
                    continue;
                }
                if (string2.equals("key")) {
                    this.doGenKey(stringArray);
                    continue;
                }
                if (string2.equals("q") || string2.equals("quit")) {
                    bl = false;
                    bl2 = false;
                    continue;
                }
                this.doHelp();
            }
        }
        catch (CtrlDPressedException ctrlDPressedException) {
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    void launchCommandShell() {
        new Thread(new 1()).start();
    }

    public void wantCommandShell() {
        this.escapeForced = true;
    }

    boolean escapeSequenceTyped(char c) {
        if (this.escapeForced) {
            this.escapeForced = false;
            return true;
        }
        this.escapeIdx = c == this.escapeString.charAt(this.escapeIdx) ? ++this.escapeIdx : 0;
        if (this.escapeIdx == this.escapeString.length()) {
            this.escapeIdx = 0;
            return true;
        }
        return false;
    }

    public Terminal getTerminal() {
        return this.term;
    }

    public void stdoutWriteString(String string) {
        if (this.isConnected) {
            this.print(string);
        }
    }

    public void stderrWriteString(String string) {
        if (this.isConnected) {
            this.print(string);
        }
    }

    public void print(String string) {
        if (this.term != null) {
            this.term.write(string);
            return;
        }
        System.out.print(string);
    }

    public void println(String string) {
        if (this.term != null) {
            this.term.write(String.valueOf(string) + "\n\r");
            return;
        }
        System.out.println(string);
    }

    public void serverConnect(SSHChannelController sSHChannelController, Cipher cipher) {
        this.controller = sSHChannelController;
        this.sndCipher = cipher;
        this.isConnected = true;
    }

    public void serverDisconnect(String string) {
        this.controller = null;
        this.sndCipher = null;
        this.isConnected = false;
        this.println(string);
    }

    public void typedChar(char c) {
        if (this.isConnected) {
            if (this.escapeSequenceTyped(c)) {
                this.launchCommandShell();
                return;
            }
            this.client.stdinWriteChar(c);
            return;
        }
        Boolean bl = this.readLineLock;
        synchronized (bl) {
            if (this.isReadingLine) {
                if (c == '\u0004') {
                    this.pressedCtrlD = true;
                    this.readLineLock.notify();
                } else if (c == '\u007f' || c == '\b') {
                    if (this.readLineStr.length() > 0) {
                        this.readLineStr = this.readLineStr.substring(0, this.readLineStr.length() - 1);
                        this.term.write('\b');
                        this.term.write(' ');
                        this.term.write('\b');
                    } else {
                        this.term.doBell();
                    }
                } else if (c == '\r') {
                    this.readLineLock.notify();
                    this.term.write("\n\r");
                } else {
                    this.readLineStr = String.valueOf(this.readLineStr) + c;
                    if (this.echoStar) {
                        this.term.write('*');
                    } else {
                        this.term.write(c);
                    }
                }
            }
            return;
        }
    }

    public void sendBytes(byte[] byArray) {
        if (this.isConnected) {
            this.client.stdinWriteString(byArray);
            return;
        }
        int n = 0;
        while (n < byArray.length) {
            this.typedChar((char)byArray[n]);
            ++n;
        }
    }

    public void signalWindowChanged(int n, int n2, int n3, int n4) {
        if (this.isConnected) {
            this.client.signalWindowChanged(n, n2, n3, n4);
        }
        this.updateTitle();
    }

    public void setSelection(String string) {
        Clipboard clipboard = this.ownerContainer.getToolkit().getSystemClipboard();
        if (clipboard == null || this.term == null) {
            return;
        }
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, stringSelection);
    }

    public String getSelection() {
        Clipboard clipboard = toolkit.getSystemClipboard();
        String string = null;
        if (clipboard == null || this.term == null) {
            return string;
        }
        Transferable transferable = clipboard.getContents(this);
        if (transferable != null) {
            try {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                toolkit.beep();
            }
        } else {
            toolkit.beep();
        }
        return string;
    }

    public static class CtrlDPressedException
    extends IOException {
    }

    private final class 1
    implements Runnable {
        public void run() {
            SSHStdIO.this.isConnected = false;
            if (!SSHStdIO.this.doCommandShell()) {
                SSHStdIO.this.controller.sendDisconnect("exit");
                return;
            }
            SSHStdIO.this.isConnected = true;
            SSHStdIO.this.typedChar('\f');
        }

        /* synthetic */ 1() {
        }
    }
}

