/*
 * Decompiled with CFR 0.152.
 */
package mindbright.terminal;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Scrollbar;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import mindbright.terminal.Terminal;
import mindbright.terminal.TerminalDumb;
import mindbright.terminal.TerminalInterpreter;
import mindbright.terminal.TerminalListener;
import mindbright.terminal.TerminalXTerm;

public final class TerminalWin
extends Canvas
implements Terminal,
KeyListener,
AdjustmentListener {
    boolean enterKeyKludge = false;
    boolean metaKeyKludge = false;
    boolean ctrlKeyKludge = false;
    static final boolean DEBUG = false;
    public static final int GRAVITY_SOUTHWEST = 0;
    public static final int GRAVITY_NORTHWEST = 1;
    public static final int MIN_ROWS = 2;
    public static final int MIN_COLS = 8;
    public static final int MAX_COLS = 512;
    public static final int MAX_ROWS = 512;
    public static final int MAJOR_DIRTY_AREA = 120;
    public static final int UPDATE_DIRTY_AREA = 2;
    TerminalListener listener;
    TerminalInterpreter interpreter;
    Scrollbar scrollbar;
    PopupMenu popupmenu;
    Panel myPanel;
    Frame ownerFrame;
    String title;
    Properties props;
    byte bsCharacter;
    boolean repaintPending;
    boolean cursorDrawn;
    boolean complexScroll;
    boolean fullRefresh;
    int dirtyCount;
    int dirtyTop;
    int dirtyBottom;
    int dirtyLeft;
    int dirtyRight;
    int resizeGravity;
    int rows;
    int cols;
    int vpixels;
    int hpixels;
    int borderWidth = 2;
    int borderHeight = 2;
    int windowTop;
    int windowBottom;
    int windowLeft;
    int windowRight;
    int charWidth;
    int charHeight;
    int charMaxAscent;
    int charMaxDescent;
    int charLeading;
    int curRow;
    int curCol;
    int lastWriteRow;
    int lastWriteCol;
    int lastCursorRow;
    int lastCursorCol;
    int selectRowAnchor;
    int selectColAnchor;
    int selectRowLast;
    int selectColLast;
    boolean hasSelection;
    boolean selectReverse;
    int curAttr;
    int curRowSave;
    int curColSave;
    int curAttrSave;
    Color origBgColor;
    Color origFgColor;
    int curFGCol;
    int curBGCol;
    public static final Color[] termColors = new Color[]{Color.black, Color.red, Color.green, Color.yellow, Color.blue, Color.magenta, Color.cyan, Color.white, Color.black.brighter(), Color.red.brighter(), Color.green.brighter(), Color.yellow.brighter(), Color.blue.brighter(), Color.magenta.brighter(), Color.cyan.brighter(), Color.white.brighter()};
    char[][] screen;
    int[][] attributes;
    int saveLines;
    int visTop;
    public static final int ATTR_CHARNOTDRAWN = 0;
    public static final int ATTR_LINEDRAW = 256;
    public static final int ATTR_SELECTED = 4096;
    public static final int ATTR_CHARDRAWN = 32768;
    public static final int IDX_ATTR = 0;
    public static final int IDX_FGCOL = 1;
    public static final int IDX_BGCOL = 2;
    public static final int IDX_LAST = 3;
    public static final char[] spacerow = new char[512];
    public static final int[] zerorow = new int[1536];
    static final String[] settingsMenu;
    static final String[] optionsMenu;
    Object[] optionsItems;
    boolean[] termOptions;
    public static final int PROP_NAME = 0;
    public static final int PROP_VALUE = 1;
    public static final int PROP_DESC = 2;
    public static final int PROP_ALLOWED = 3;
    public static Properties defaultProperties;
    public static final String[][] defaultPropDesc;
    Image memImage;
    Graphics memGraphics;
    Dimension memImageSize;
    public Font plainFont;
    public Font boldFont;
    Dialog settingsDialog;
    Choice choiceTE;
    Choice choiceFN;
    Choice choiceSB;
    Choice choiceRG;
    Choice choiceBS;
    TextField textFS;
    TextField textSL;
    TextField textFG;
    TextField textBG;
    Label lblAlert;
    String[] te;
    String[] fn;
    String[] sb;
    String[] rg;
    String[] bs;

    public TerminalWin(Frame frame, int n, int n2, TerminalInterpreter terminalInterpreter) {
        this.ownerFrame = frame;
        this.title = null;
        this.curAttr = 32768;
        this.curRow = 0;
        this.curCol = 0;
        this.resizeGravity = 0;
        this.cursorDrawn = false;
        this.saveLines = 0;
        this.visTop = 0;
        this.repaintPending = true;
        this.setWindowSize(n2, n);
        this.resetWindow();
        this.clearScreen();
        if (terminalInterpreter == null) {
            terminalInterpreter = new TerminalDumb();
        }
        this.interpreter = terminalInterpreter;
        terminalInterpreter.setTerminal(this);
        this.scrollbar = null;
        this.createPopupMenu();
        this.termOptions = new boolean[15];
        try {
            this.copyProperties(defaultProperties);
        }
        catch (NoSuchElementException noSuchElementException) {
            System.out.println("!!! Can't happen, a field in TerminalWin.java must be misspelled...");
        }
        this.addKeyListener(this);
        this.addComponentListener(new 1());
        this.addMouseMotionListener(new 2());
        this.addMouseListener(new 3());
    }

    public static String fontList() {
        String[] stringArray = Toolkit.getDefaultToolkit().getFontList();
        String string = "";
        int n = 0;
        while (n < stringArray.length) {
            string = String.valueOf(string) + stringArray[n];
            if (n < stringArray.length - 1) {
                string = String.valueOf(string) + ", ";
            }
            ++n;
        }
        return string;
    }

    public void copyProperties(Properties properties) throws NoSuchElementException {
        this.props = new Properties(properties);
        int n = 0;
        while (n < defaultPropDesc.length) {
            String string = defaultPropDesc[n][0];
            String string2 = defaultPropDesc[n][1];
            this.setProperty(string, string2, false);
            ++n;
        }
    }

    public Properties getProperties() {
        return this.props;
    }

    public void setProperty(String string, String string2) throws IllegalArgumentException, NoSuchElementException {
        this.setProperty(string, string2, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperty(String string, String string2, boolean bl) throws IllegalArgumentException, NoSuchElementException {
        String string3;
        if (bl && (string3 = this.getProperty(string)) != null && string3.equals(string2)) {
            return;
        }
        int n = 0;
        while (n < this.termOptions.length) {
            if (defaultPropDesc[n][0].equals(string)) break;
            ++n;
        }
        if (n < this.termOptions.length) {
            if (!string2.equals("true") && !string2.equals("false")) {
                throw new IllegalArgumentException("value for " + string + " must be 'true' or 'false'");
            }
            ((Hashtable)this.props).put(string, string2);
            this.setOption(n, new Boolean(string2));
        } else if (string.equals("te")) {
            if (this.interpreter instanceof TerminalXTerm) {
                ((TerminalXTerm)this.interpreter).setTerminalType(string2);
            }
        } else if (string.equals("fn")) {
            this.setFont(string2, Integer.parseInt(this.getProperty("fs")));
        } else if (string.equals("fs")) {
            try {
                this.setFont(this.getProperty("fn"), Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("value for " + string + " must be an integer");
            }
        } else if (string.equals("sl")) {
            try {
                this.setSaveLines(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("value for " + string + " must be an integer");
            }
        } else if (string.equals("sb")) {
            if (this.myPanel != null) {
                if (string2.equals("left") || string2.equals("right")) {
                    if (this.scrollbar != null) {
                        this.myPanel.remove(this.scrollbar);
                    }
                    if (string2.equals("right")) {
                        this.myPanel.add((Component)this.scrollbar, "East");
                    } else {
                        this.myPanel.add((Component)this.scrollbar, "West");
                    }
                    this.ownerFrame.pack();
                } else {
                    if (!string2.equals("none")) throw new IllegalArgumentException("scrollbar can be right, left or none");
                    if (this.scrollbar != null) {
                        this.myPanel.remove(this.scrollbar);
                    }
                    this.ownerFrame.pack();
                }
            }
        } else if (string.equals("bg") || string.equals("fg")) {
            try {
                Color color;
                if (string2.charAt(0) == '#') {
                    color = termColors[Integer.parseInt(string2.substring(1))];
                } else {
                    int n2 = string2.indexOf(44);
                    int n3 = string2.lastIndexOf(44);
                    int n4 = Integer.parseInt(string2.substring(0, n2).trim());
                    int n5 = Integer.parseInt(string2.substring(n2 + 1, n3).trim());
                    int n6 = Integer.parseInt(string2.substring(n3 + 1).trim());
                    color = new Color(n4, n5, n6);
                }
                if (string.equals("bg")) {
                    this.origBgColor = color;
                    this.setBackground(this.origBgColor);
                }
                this.origFgColor = color;
                this.setForeground(this.origFgColor);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("valid colors: '#<0-15>' or '<r>,<g>,<b>'");
            }
        } else if (string.equals("rg")) {
            int n7;
            if (string2.equals("northwest")) {
                n7 = 1;
            } else {
                if (!string2.equals("southwest")) throw new IllegalArgumentException("reszize gravity can be 'northwest' or 'southwest'");
                n7 = 0;
            }
            this.resizeGravity = n7;
        } else {
            if (!string.equals("bs")) throw new NoSuchElementException("unknown terminal-property '" + string + "'");
            if (string2.equals("DEL")) {
                this.bsCharacter = (byte)127;
            } else {
                if (!string2.equals("BS")) throw new IllegalArgumentException("backspace character can be 'DEL' or 'BS'");
                this.bsCharacter = (byte)8;
            }
        }
        ((Hashtable)this.props).put(string, string2);
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    private final void setFont(String string, int n) {
        this.plainFont = new Font(string, 0, n);
        this.boldFont = new Font(string, 1, n);
        super.setFont(this.plainFont);
        this.getDimensionOfText(0, 0);
        if (this.isShowing()) {
            this.componentResized(null);
        }
    }

    public void setFont(Font font) {
        this.setFont(font.getName(), font.getSize());
    }

    public void setTitle(String string) {
        this.title = string;
        this.signalWindowChanged(this.rows, this.cols, this.vpixels, this.hpixels);
    }

    public String getTitle() {
        return this.title;
    }

    void createPopupMenu() {
        if (this.popupmenu != null) {
            return;
        }
        this.popupmenu = new PopupMenu("Main menu");
        this.add(this.popupmenu);
        4 var3_1 = new 4();
        MenuItem menuItem = new MenuItem(settingsMenu[0]);
        menuItem.addActionListener(var3_1);
        this.popupmenu.add(menuItem);
        Menu menu = new Menu(optionsMenu[0]);
        5 var5_4 = new 5();
        this.optionsItems = new Object[optionsMenu.length - 1];
        int n = 1;
        while (n < optionsMenu.length) {
            CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(optionsMenu[n]);
            this.optionsItems[n - 1] = checkboxMenuItem;
            checkboxMenuItem.addItemListener(var5_4);
            menu.add(checkboxMenuItem);
            ++n;
        }
        this.popupmenu.add(menu);
        ((CheckboxMenuItem)this.optionsItems[12]).setEnabled(false);
    }

    public void addMenuItem(MenuItem menuItem) {
        if (this.popupmenu == null) {
            return;
        }
        if (menuItem == null) {
            this.popupmenu.addSeparator();
            return;
        }
        this.popupmenu.add(menuItem);
    }

    void updateScrollbarValues() {
        if (this.scrollbar != null) {
            this.scrollbar.setMinimum(0);
            this.scrollbar.setMaximum(this.saveLines + this.rows);
            this.scrollbar.setVisibleAmount(this.rows);
            this.scrollbar.setBlockIncrement(this.rows);
            this.scrollbar.setValue(this.visTop);
        }
    }

    public Panel getPanelWithScrollbar() {
        if (this.myPanel != null) {
            return this.myPanel;
        }
        this.scrollbar = new Scrollbar(1);
        this.updateScrollbarValues();
        this.scrollbar.addAdjustmentListener(this);
        this.myPanel = new Panel(new BorderLayout());
        this.myPanel.add((Component)this, "Center");
        String string = this.getProperty("sb");
        if (string.equals("left")) {
            this.myPanel.add((Component)this.scrollbar, "West");
        } else if (string.equals("right")) {
            this.myPanel.add((Component)this.scrollbar, "East");
        }
        return this.myPanel;
    }

    private final void setSaveLines(int n) {
        int n2 = this.saveLines;
        n = n < 0 ? 0 : n;
        int n3 = n = n > 32168 ? 32168 : n;
        if (this.saveLines != n) {
            int n4;
            int n5;
            int n6;
            char[][] cArray = this.screen;
            int[][] nArray = this.attributes;
            this.saveLines = n;
            this.visTop = n;
            this.setWindowSize(this.rows, this.cols);
            if (n2 < this.saveLines) {
                n6 = 0;
                n5 = this.saveLines - n2;
                n4 = n2 + this.rows;
            } else {
                n6 = n2 - this.saveLines;
                n5 = 0;
                n4 = this.saveLines + this.rows;
            }
            System.arraycopy(cArray, n6, this.screen, n5, n4);
            System.arraycopy(nArray, n6, this.attributes, n5, n4);
            this.updateScrollbarValues();
        }
    }

    public void setWindowSize(int n, int n2) {
        this.rows = n;
        this.cols = n2;
        this.screen = new char[n + this.saveLines][n2];
        this.attributes = new int[n + this.saveLines][n2 * 3];
    }

    public void setInterpreter(TerminalInterpreter terminalInterpreter) {
        if (terminalInterpreter != null) {
            this.interpreter = terminalInterpreter;
        }
    }

    public String terminalType() {
        return this.interpreter.terminalType();
    }

    public int rows() {
        return this.rows;
    }

    public int cols() {
        return this.cols;
    }

    public int vpixels() {
        return this.vpixels;
    }

    public int hpixels() {
        return this.hpixels;
    }

    protected final void makeAllDirty() {
        this.dirtyCount = 2;
        this.updateDirtyArea(0, 0, this.rows, this.cols);
        this.repaintPending = true;
        this.repaint();
    }

    protected final void updateDirtyArea(int n, int n2, int n3, int n4) {
        if (n < this.dirtyTop) {
            this.dirtyTop = n;
        }
        if (n3 > this.dirtyBottom) {
            this.dirtyBottom = n3;
        }
        if (n2 < this.dirtyLeft) {
            this.dirtyLeft = n2;
        }
        if (n4 > this.dirtyRight) {
            this.dirtyRight = n4;
        }
    }

    public final synchronized void write(char c) {
        int n;
        if (this.visTop != this.saveLines && this.termOptions[6]) {
            this.dirtyCount = 2;
            this.repaintPending = false;
            this.visTop = this.saveLines;
            if (this.scrollbar != null) {
                this.scrollbar.setValue(this.visTop);
            }
            this.updateDirtyArea(0, 0, this.rows, this.cols);
        }
        if ((n = this.interpreter.interpretChar(c)) != -1) {
            c = (char)n;
            if (this.curCol == this.cols) {
                if (this.termOptions[1]) {
                    ++this.curRow;
                    this.curCol = 0;
                    if (this.curRow == this.windowBottom) {
                        this.scrollUp(1);
                        this.curRow = this.windowBottom - 1;
                    }
                } else {
                    --this.curCol;
                }
            }
            if (this.termOptions[3]) {
                this.insertChars(1);
            }
            ++this.dirtyCount;
            this.lastWriteRow = this.curRow;
            this.lastWriteCol = this.curCol;
            this.updateDirtyArea(this.curRow, this.curCol, this.curRow + 1, this.curCol + 1);
            int n2 = this.curCol * 3;
            int n3 = this.visTop + this.curRow;
            this.attributes[n3][n2] = this.curAttr;
            if ((this.curAttr & 0x40) != 0) {
                this.attributes[n3][n2 + 1] = this.curFGCol;
            }
            if ((this.curAttr & 0x80) != 0) {
                this.attributes[n3][n2 + 2] = this.curBGCol;
            }
            this.screen[this.visTop + this.curRow][this.curCol++] = c;
        }
        if (this.curRow == this.windowBottom) {
            this.scrollUp(1);
            this.curRow = this.windowBottom - 1;
        }
        if (!this.repaintPending) {
            this.repaintPending = true;
            this.repaint();
        }
    }

    public final void write(char[] cArray, int n, int n2) {
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            this.write(cArray[n4]);
            ++n4;
        }
    }

    public final void write(String string) {
        char[] cArray = string.toCharArray();
        this.write(cArray, 0, cArray.length);
    }

    public void writeLineDrawChar(char c) {
        if (this.curCol == this.cols) {
            if (this.termOptions[1]) {
                ++this.curRow;
                this.curCol = 0;
                if (this.curRow == this.windowBottom) {
                    this.scrollUp(1);
                    this.curRow = this.windowBottom - 1;
                }
            } else {
                --this.curCol;
            }
        }
        ++this.dirtyCount;
        this.lastWriteRow = this.curRow;
        this.lastWriteCol = this.curCol;
        this.updateDirtyArea(this.curRow, this.curCol, this.curRow + 1, this.curCol + 1);
        int n = this.curCol * 3;
        int n2 = this.visTop + this.curRow;
        this.attributes[n2][n] = this.curAttr | 0x100;
        this.attributes[n2][n + 1] = this.curFGCol;
        this.attributes[n2][n + 2] = this.curBGCol;
        this.screen[this.visTop + this.curRow][this.curCol++] = c;
    }

    public void addTerminalListener(TerminalListener terminalListener) {
        this.listener = terminalListener;
    }

    public final void sendBytes(byte[] byArray) {
        if (this.listener != null) {
            this.listener.sendBytes(byArray);
        }
    }

    public void doBell() {
        if (this.termOptions[13]) {
            this.setOption(0, !this.termOptions[0]);
            this.paint(this.getGraphics());
            this.setOption(0, !this.termOptions[0]);
            return;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit != null) {
            toolkit.beep();
        }
    }

    public void doBS() {
        this.cursorBackward(1);
    }

    public void doTab() {
        int n = this.curCol + (8 - this.curCol % 8);
        if (n > this.windowRight) {
            n = this.windowRight;
        }
        this.curCol = n;
    }

    public void doCR() {
        this.curCol = this.windowLeft;
    }

    public void doLF() {
        ++this.curRow;
        if (this.termOptions[11] && this.termOptions[4]) {
            this.doCR();
        }
    }

    public void resetWindow() {
        this.windowTop = 0;
        this.windowBottom = this.rows;
        this.windowLeft = 0;
        this.windowRight = this.cols;
        this.complexScroll = false;
    }

    public void setWindow(int n, int n2) {
        this.setWindow(n, 0, n2, this.cols);
    }

    public void setWindow(int n, int n2, int n3, int n4) {
        this.windowTop = n;
        this.windowLeft = n2;
        this.windowBottom = n3;
        this.windowRight = n4;
        if (this.hasSelection) {
            int n5 = this.selectRowAnchor - this.visTop;
            int n6 = this.selectRowLast - this.visTop;
            if (n != 0 && (n5 >= 0 || n6 >= 0)) {
                if (!(n5 < n && n6 < n || n5 >= n3 && n6 >= n3)) {
                    this.clearSelection();
                }
            } else if (n5 >= n3 || n6 >= n3) {
                this.clearSelection();
            }
        }
        if (this.windowLeft != 0 || this.windowRight != this.cols) {
            this.complexScroll = true;
            return;
        }
        this.complexScroll = false;
    }

    public int getWindowTop() {
        return this.windowTop;
    }

    public int getWindowBottom() {
        return this.windowBottom;
    }

    public int getWindowLeft() {
        return this.windowLeft;
    }

    public int getWindowRight() {
        return this.windowRight;
    }

    public int getCursorV() {
        return this.curRow;
    }

    public int getCursorH() {
        return this.curCol;
    }

    public void cursorSetPos(int n, int n2, boolean bl) {
        int n3 = this.rows - 1;
        int n4 = this.cols - 1;
        int n5 = 0;
        int n6 = 0;
        if (bl) {
            n += this.windowTop;
            n3 = this.windowBottom - 1;
            n5 = this.windowTop;
            n2 += this.windowLeft;
            n4 = this.windowRight - 1;
            n6 = this.windowLeft;
        }
        if (n < n5) {
            n = n5;
        }
        if (n2 < n6) {
            n2 = n6;
        }
        if (n > n3) {
            n = n3;
        }
        if (n2 > n4) {
            n2 = n4;
        }
        this.curRow = n;
        this.curCol = n2;
    }

    public void cursorUp(int n) {
        int n2 = this.curRow < this.windowTop ? 0 : this.windowTop;
        this.curRow -= n;
        if (this.curRow < n2) {
            this.curRow = n2;
        }
    }

    public void cursorDown(int n) {
        int n2 = this.curRow > this.windowBottom - 1 ? this.rows - 1 : this.windowBottom - 1;
        this.curRow += n;
        if (this.curRow > n2) {
            this.curRow = n2;
        }
    }

    public void cursorForward(int n) {
        this.curCol += n;
        if (this.curCol > this.windowRight) {
            this.curCol = this.windowRight;
        }
    }

    public void cursorBackward(int n) {
        this.curCol -= n;
        if (this.curCol < this.windowLeft) {
            if (this.termOptions[2]) {
                this.curCol = this.windowRight - (this.windowLeft - this.curCol);
                this.cursorUp(1);
                return;
            }
            this.curCol = this.windowLeft;
        }
    }

    public void cursorIndex(int n) {
        if (this.curRow > this.windowBottom || this.curRow + n <= this.windowBottom) {
            this.cursorDown(n);
            return;
        }
        int n2 = this.windowBottom - this.curRow;
        this.cursorDown(n2);
        this.scrollUp(n - n2);
    }

    public void cursorIndexRev(int n) {
        if (this.curRow < this.windowTop || this.curRow - n >= this.windowTop) {
            this.cursorUp(n);
            return;
        }
        int n2 = this.curRow - this.windowTop;
        this.scrollDown(n - n2);
        this.cursorUp(n2);
    }

    public void cursorSave() {
        this.curRowSave = this.curRow;
        this.curColSave = this.curCol;
        this.curAttrSave = this.curAttr;
    }

    public void cursorRestore() {
        this.curRow = this.curRowSave;
        this.curCol = this.curColSave;
        this.curAttr = this.curAttrSave;
    }

    public void scrollUp(int n) {
        int n2 = this.windowBottom - this.windowTop;
        int n3 = this.windowTop;
        if (this.complexScroll) {
            int n4;
            if (n < n2) {
                n3 = n2 - n + this.windowTop;
                n4 = this.windowTop;
                while (n4 < n3) {
                    System.arraycopy(this.screen[this.saveLines + n4 + n], this.windowLeft, this.screen[this.saveLines + n4], this.windowLeft, this.windowRight - this.windowLeft);
                    System.arraycopy(this.attributes[this.saveLines + n4 + n], this.windowLeft * 3, this.attributes[this.saveLines + n4], this.windowLeft * 3, (this.windowRight - this.windowLeft) * 3);
                    ++n4;
                }
            }
            n4 = n3;
            while (n4 < this.windowBottom) {
                System.arraycopy(spacerow, 0, this.screen[this.saveLines + n4], this.windowLeft, this.windowRight - this.windowLeft);
                System.arraycopy(zerorow, 0, this.attributes[this.saveLines + n4], this.windowLeft * 3, (this.windowRight - this.windowLeft) * 3);
                ++n4;
            }
        } else {
            if (this.hasSelection) {
                if (this.windowTop == 0 && this.selectRowAnchor - n >= 0 && this.selectRowLast - n >= 0) {
                    this.selectRowAnchor -= n;
                    this.selectRowLast -= n;
                } else {
                    this.clearSelection();
                }
            }
            if (this.windowTop == 0 && this.saveLines > 0) {
                int n5 = n < n2 ? n : n2;
                int n6 = n2 - n5;
                System.arraycopy(this.screen, n5, this.screen, 0, this.saveLines + n6);
                System.arraycopy(this.attributes, n5, this.attributes, 0, this.saveLines + n6);
                int n7 = n2 - n5;
                while (n7 < n2) {
                    this.screen[this.saveLines + n7] = new char[this.cols];
                    this.attributes[this.saveLines + n7] = new int[this.cols * 3];
                    ++n7;
                }
            } else {
                if (n < n2) {
                    n3 = n2 - n + this.windowTop;
                    System.arraycopy(this.screen, this.saveLines + this.windowTop + n, this.screen, this.saveLines + this.windowTop, n2 - n);
                    System.arraycopy(this.attributes, this.saveLines + this.windowTop + n, this.attributes, this.saveLines + this.windowTop, n2 - n);
                }
                int n8 = n3;
                while (n8 < this.windowBottom) {
                    this.screen[this.saveLines + n8] = new char[this.cols];
                    this.attributes[this.saveLines + n8] = new int[this.cols * 3];
                    ++n8;
                }
            }
        }
        this.dirtyCount = 2;
        this.updateDirtyArea(this.windowTop, this.windowLeft, this.windowBottom, this.windowRight);
    }

    public void scrollDown(int n) {
        int n2 = this.windowBottom - this.windowTop;
        int n3 = this.windowBottom;
        if (this.complexScroll) {
            int n4;
            if (n < n2) {
                n3 = this.windowTop + n;
                n4 = this.windowBottom - 1;
                while (n4 >= n3) {
                    System.arraycopy(this.screen[this.saveLines + n4 - n], this.windowLeft, this.screen[this.saveLines + n4], this.windowLeft, this.windowRight - this.windowLeft);
                    System.arraycopy(this.attributes[this.saveLines + n4 - n], this.windowLeft * 3, this.attributes[this.saveLines + n4], this.windowLeft * 3, (this.windowRight - this.windowLeft) * 3);
                    --n4;
                }
            }
            n4 = this.windowTop;
            while (n4 < n3) {
                System.arraycopy(spacerow, 0, this.screen[this.saveLines + n4], this.windowLeft, this.windowRight - this.windowLeft);
                System.arraycopy(zerorow, 0, this.attributes[this.saveLines + n4], this.windowLeft * 3, (this.windowRight - this.windowLeft) * 3);
                ++n4;
            }
        } else {
            if (n < n2) {
                n3 = this.windowTop + n;
                System.arraycopy(this.screen, this.saveLines + this.windowTop, this.screen, this.saveLines + this.windowTop + n, n2 - n);
                System.arraycopy(this.attributes, this.saveLines + this.windowTop, this.attributes, this.saveLines + this.windowTop + n, n2 - n);
            }
            int n5 = this.windowTop;
            while (n5 < n3) {
                this.screen[this.saveLines + n5] = new char[this.cols];
                this.attributes[this.saveLines + n5] = new int[this.cols * 3];
                ++n5;
            }
        }
        this.dirtyCount = 2;
        this.updateDirtyArea(this.windowTop, 0, this.windowBottom, this.cols);
    }

    public void clearBelow() {
        this.clearRight();
        int n = this.curRow + 1;
        while (n < this.windowBottom) {
            this.screen[this.saveLines + n] = new char[this.cols];
            this.attributes[this.saveLines + n] = new int[this.cols * 3];
            ++n;
        }
        this.dirtyCount = 2;
        this.updateDirtyArea(this.curRow, 0, this.windowBottom, this.cols);
    }

    public void clearAbove() {
        this.clearLeft();
        int n = this.windowTop;
        while (n < this.curRow) {
            this.screen[this.saveLines + n] = new char[this.cols];
            this.attributes[this.saveLines + n] = new int[this.cols * 3];
            ++n;
        }
        this.dirtyCount = 2;
        this.updateDirtyArea(this.windowTop, 0, this.curRow, this.cols);
    }

    public void clearScreen() {
        int n = this.windowTop;
        while (n < this.windowBottom) {
            this.screen[this.saveLines + n] = new char[this.cols];
            this.attributes[this.saveLines + n] = new int[this.cols * 3];
            ++n;
        }
        this.dirtyCount = 2;
        this.dirtyTop = 0;
        this.dirtyBottom = this.rows;
        this.dirtyLeft = 0;
        this.dirtyRight = this.cols;
    }

    public void clearRight() {
        System.arraycopy(spacerow, 0, this.screen[this.saveLines + this.curRow], this.curCol, this.cols - this.curCol);
        System.arraycopy(zerorow, 0, this.attributes[this.saveLines + this.curRow], this.curCol * 3, (this.cols - this.curCol) * 3);
        this.dirtyCount = 2;
        this.updateDirtyArea(this.curRow, this.curCol, this.curRow + 1, this.cols);
    }

    public void clearLeft() {
        System.arraycopy(spacerow, 0, this.screen[this.saveLines + this.curRow], 0, this.curCol);
        System.arraycopy(zerorow, 0, this.attributes[this.saveLines + this.curRow], 0, this.curCol * 3);
        this.dirtyCount = 2;
        this.dirtyLeft = 0;
        this.updateDirtyArea(this.curRow, 0, this.curRow + 1, this.curCol);
    }

    public void clearLine() {
        this.screen[this.saveLines + this.curRow] = new char[this.cols];
        this.attributes[this.saveLines + this.curRow] = new int[this.cols * 3];
        this.dirtyCount = 2;
        this.dirtyLeft = 0;
        this.dirtyRight = this.cols;
        this.updateDirtyArea(this.curRow, 0, this.curRow + 1, this.cols);
    }

    public void insertChars(int n) {
        int n2 = this.windowRight;
        if (this.curCol < this.windowLeft || this.curCol > this.windowRight) {
            return;
        }
        if (this.curCol + n < this.windowRight) {
            n2 = this.curCol + n;
            System.arraycopy(this.screen[this.saveLines + this.curRow], this.curCol, this.screen[this.saveLines + this.curRow], n2, this.windowRight - n2);
            System.arraycopy(this.attributes[this.saveLines + this.curRow], this.curCol * 3, this.attributes[this.saveLines + this.curRow], n2 * 3, (this.windowRight - n2) * 3);
        }
        System.arraycopy(spacerow, 0, this.screen[this.saveLines + this.curRow], this.curCol, n2 - this.curCol);
        System.arraycopy(zerorow, 0, this.attributes[this.saveLines + this.curRow], this.curCol * 3, (n2 - this.curCol) * 3);
        this.dirtyCount = 2;
        this.updateDirtyArea(this.curRow, this.curCol, this.curRow + 1, this.windowRight);
    }

    public void deleteChars(int n) {
        int n2 = this.curCol;
        if (this.curCol < this.windowLeft || this.curCol > this.windowRight) {
            return;
        }
        if (this.curCol + n < this.windowRight) {
            n2 = this.windowRight - n;
            System.arraycopy(this.screen[this.saveLines + this.curRow], this.curCol + n, this.screen[this.saveLines + this.curRow], this.curCol, n2 - this.curCol);
            System.arraycopy(this.attributes[this.saveLines + this.curRow], (this.curCol + n) * 3, this.attributes[this.saveLines + this.curRow], this.curCol * 3, (n2 - this.curCol) * 3);
        }
        System.arraycopy(spacerow, 0, this.screen[this.saveLines + this.curRow], n2, this.windowRight - n2);
        System.arraycopy(zerorow, 0, this.attributes[this.saveLines + this.curRow], n2 * 3, (this.windowRight - n2) * 3);
        this.dirtyCount = 2;
        this.updateDirtyArea(this.curRow, this.curCol, this.curRow + 1, this.windowRight);
    }

    public void insertLines(int n) {
        int n2 = this.windowBottom;
        if (this.curRow < this.windowTop || this.curRow > this.windowBottom) {
            return;
        }
        if (this.complexScroll) {
            int n3;
            if (this.curRow + n < this.windowBottom) {
                n2 = this.curRow + n;
                n3 = this.windowBottom - 1;
                while (n3 >= n2) {
                    System.arraycopy(this.screen[this.saveLines + n3 - n], this.windowLeft, this.screen[this.saveLines + n3], this.windowLeft, this.windowRight - this.windowLeft);
                    System.arraycopy(this.attributes[this.saveLines + n3 - n], this.windowLeft * 3, this.attributes[this.saveLines + n3], this.windowLeft * 3, (this.windowRight - this.windowLeft) * 3);
                    --n3;
                }
            }
            n3 = this.curRow;
            while (n3 < n2) {
                System.arraycopy(spacerow, 0, this.screen[this.saveLines + n3], this.windowLeft, this.windowRight - this.windowLeft);
                System.arraycopy(zerorow, 0, this.attributes[this.saveLines + n3], this.windowLeft * 3, (this.windowRight - this.windowLeft) * 3);
                ++n3;
            }
        } else {
            if (this.curRow + n < this.windowBottom) {
                n2 = this.curRow + n;
                System.arraycopy(this.screen, this.saveLines + this.curRow, this.screen, this.saveLines + n2, this.windowBottom - n2);
                System.arraycopy(this.attributes, this.saveLines + this.curRow, this.attributes, this.saveLines + n2, this.windowBottom - n2);
            }
            int n4 = this.curRow;
            while (n4 < n2) {
                this.screen[this.saveLines + n4] = new char[this.cols];
                this.attributes[this.saveLines + n4] = new int[this.cols * 3];
                ++n4;
            }
        }
        this.dirtyCount = 2;
        this.updateDirtyArea(this.curRow, 0, this.windowBottom, this.cols);
    }

    public void deleteLines(int n) {
        int n2 = this.curRow;
        if (this.curRow < this.windowTop || this.curRow > this.windowBottom) {
            return;
        }
        if (this.complexScroll) {
            int n3;
            if (this.curRow + n < this.windowBottom) {
                n2 = this.windowBottom - n - 1;
                n3 = this.curRow;
                while (n3 <= n2) {
                    System.arraycopy(this.screen[this.saveLines + n3 + n], this.windowLeft, this.screen[this.saveLines + n3], this.windowLeft, this.windowRight - this.windowLeft);
                    System.arraycopy(this.attributes[this.saveLines + n3 + n], this.windowLeft * 3, this.attributes[this.saveLines + n3], this.windowLeft * 3, (this.windowRight - this.windowLeft) * 3);
                    ++n3;
                }
            }
            n3 = n2;
            while (n3 < this.windowBottom) {
                System.arraycopy(spacerow, 0, this.screen[this.saveLines + n3], this.windowLeft, this.windowRight - this.windowLeft);
                System.arraycopy(zerorow, 0, this.attributes[this.saveLines + n3], this.windowLeft * 3, (this.windowRight - this.windowLeft) * 3);
                ++n3;
            }
        } else {
            if (this.curRow + n < this.windowBottom) {
                n2 = this.windowBottom - n;
                System.arraycopy(this.screen, this.saveLines + this.curRow + n, this.screen, this.saveLines + this.curRow, n2 - this.curRow);
                System.arraycopy(this.attributes, this.saveLines + this.curRow + n, this.attributes, this.saveLines + this.curRow, n2 - this.curRow);
            }
            int n4 = n2;
            while (n4 < this.windowBottom) {
                this.screen[this.saveLines + n4] = new char[this.cols];
                this.attributes[this.saveLines + n4] = new int[this.cols * 3];
                ++n4;
            }
        }
        this.dirtyCount = 2;
        this.updateDirtyArea(this.curRow, 0, this.windowBottom, this.cols);
    }

    public void setOption(int n, boolean bl) {
        if (n > this.termOptions.length || n < 0) {
            return;
        }
        switch (n) {
            case 0: {
                if (bl == this.termOptions[n]) break;
                this.termOptions[n] = bl;
                Color color = this.origBgColor;
                this.origBgColor = this.origFgColor;
                this.origFgColor = color;
                this.makeAllDirty();
                break;
            }
            case 9: {
                this.repaintPending = true;
                this.repaint();
                break;
            }
        }
        this.termOptions[n] = bl;
        if (this.popupmenu != null && this.optionsItems != null) {
            ((CheckboxMenuItem)this.optionsItems[n]).setState(bl);
        }
    }

    public boolean getOption(int n) {
        if (n > this.termOptions.length || n < 0) {
            return false;
        }
        return this.termOptions[n];
    }

    public void setAttribute(int n, boolean bl) {
        if (bl) {
            this.curAttr |= n;
            return;
        }
        this.curAttr &= ~n;
    }

    public boolean getAttribute(int n) {
        return (this.curAttr & n) == n;
    }

    public void setForegroundColor(int n) {
        if (n >= 0 && n < 8) {
            if ((this.curAttr & 1) != 0) {
                n += 8;
            }
            this.curFGCol = n;
            this.curAttr |= 0x40;
            return;
        }
        this.curAttr &= 0xFFFFFFBF;
    }

    public void setBackgroundColor(int n) {
        if (n >= 0 && n < 8) {
            this.curBGCol = n;
            this.curAttr |= 0x80;
            return;
        }
        this.curAttr &= 0xFFFFFF7F;
    }

    public void clearAllAttributes() {
        this.curAttr = 32768;
    }

    public void signalWindowChanged(int n, int n2, int n3, int n4) {
        if (this.listener != null) {
            this.listener.signalWindowChanged(n, n2, n3, n4);
        }
    }

    public void typedChar(char c) {
    }

    public final boolean keyKludgeFilter(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c > '\u00ff') {
            switch (c) {
                case '\ufe53': {
                    keyEvent.setKeyChar('~');
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        switch (c) {
            case ' ': {
                if (!this.termOptions[14] || !this.ctrlKeyKludge) break;
                keyEvent.setKeyChar('\u0000');
                break;
            }
            case '\n': {
                if (!this.enterKeyKludge) break;
                keyEvent.setKeyChar('\r');
                break;
            }
            case '\u00a8': {
                keyEvent.setKeyChar('~');
                break;
            }
            case '\b': 
            case '\u007f': {
                return false;
            }
        }
        if (this.metaKeyKludge && this.listener != null) {
            this.listener.typedChar('\u001b');
        }
        return true;
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (!this.keyKludgeFilter(keyEvent)) {
            return;
        }
        int n = keyEvent.getKeyChar();
        if (this.termOptions[11]) {
            this.write((char)n);
        }
        if (this.listener != null) {
            if ((n == 10 || n == 13) && this.termOptions[4]) {
                n = 10;
                this.listener.typedChar('\r');
            }
            this.listener.typedChar((char)n);
        } else {
            this.typedChar((char)n);
        }
        if (this.visTop != this.saveLines && this.termOptions[5]) {
            this.visTop = this.saveLines;
            if (this.scrollbar != null) {
                this.scrollbar.setValue(this.visTop);
            }
            this.makeAllDirty();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                this.enterKeyKludge = true;
                return;
            }
            case 18: {
                if (this.ctrlKeyKludge) {
                    this.ctrlKeyKludge = false;
                    return;
                }
                this.metaKeyKludge = true;
                return;
            }
            case 17: {
                this.ctrlKeyKludge = true;
                return;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        this.interpreter.keyHandler(n);
        switch (n) {
            case 10: {
                this.enterKeyKludge = false;
                return;
            }
            case 18: {
                this.metaKeyKludge = false;
                return;
            }
            case 17: {
                this.ctrlKeyKludge = false;
                return;
            }
            case 8: {
                byte[] byArray = new byte[]{this.bsCharacter};
                this.sendBytes(byArray);
                return;
            }
            case 127: {
                byte[] byArray = new byte[]{127};
                this.sendBytes(byArray);
                return;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                this.localPageCtrlKeys(n);
                return;
            }
        }
    }

    public final void localPageCtrlKeys(int n) {
        if (!this.termOptions[7]) {
            return;
        }
        switch (n) {
            case 33: {
                this.visTop -= this.rows;
                if (this.visTop < 0) {
                    this.visTop = 0;
                }
                this.updateScrollbarValues();
                this.makeAllDirty();
                return;
            }
            case 34: {
                this.visTop += this.rows;
                if (this.visTop > this.saveLines) {
                    this.visTop = this.saveLines;
                }
                this.updateScrollbarValues();
                this.makeAllDirty();
                return;
            }
            case 36: {
                this.visTop = 0;
                this.updateScrollbarValues();
                this.makeAllDirty();
                return;
            }
            case 35: {
                this.visTop = this.saveLines;
                this.updateScrollbarValues();
                this.makeAllDirty();
                return;
            }
        }
    }

    public synchronized void componentResized(ComponentEvent componentEvent) {
        Dimension dimension = this.getSize();
        int n = (dimension.width - 2 * this.borderWidth) / this.charWidth;
        int n2 = (dimension.height - 2 * this.borderHeight) / this.charHeight;
        int n3 = this.cols;
        int n4 = this.rows;
        char[][] cArray = this.screen;
        int[][] nArray = this.attributes;
        this.vpixels = dimension.height;
        this.hpixels = dimension.width;
        if (n != n3) {
            this.clearSelection();
        }
        this.setWindowSize(n2, n);
        this.resetWindow();
        this.clearScreen();
        int n5 = n3 = n3 < n ? n3 : n;
        if (this.resizeGravity == 1) {
            int n6 = (n4 < n2 ? n4 : n2) + this.saveLines;
            int n7 = 0;
            while (n7 < n6) {
                System.arraycopy(cArray[n7], 0, this.screen[n7], 0, n3);
                System.arraycopy(nArray[n7], 0, this.attributes[n7], 0, n3 * 3);
                ++n7;
            }
        } else {
            int n8;
            int n9;
            int n10;
            if (this.hasSelection) {
                this.selectRowAnchor += n2 - n4;
                this.selectRowLast += n2 - n4;
            }
            if (n4 < n2) {
                n10 = n4 + this.saveLines;
                n9 = 0;
                n8 = n2 - n4;
                this.curRow += n8;
            } else {
                n10 = n2 + this.saveLines;
                n9 = n4 - n2;
                n8 = 0;
                this.curRow -= n9;
            }
            int n11 = 0;
            while (n11 < n10) {
                System.arraycopy(cArray[n11 + n9], 0, this.screen[n11 + n8], 0, n3);
                System.arraycopy(nArray[n11 + n9], 0, this.attributes[n11 + n8], 0, n3 * 3);
                ++n11;
            }
        }
        if (this.curRow >= n2) {
            this.curRow = n2 - 1;
        }
        if (this.curCol >= n) {
            this.curCol = n - 1;
        }
        this.updateScrollbarValues();
        this.signalWindowChanged(this.rows, this.cols, this.vpixels, this.hpixels);
        this.memGraphics = null;
        this.repaintPending = false;
        this.repaint();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n = adjustmentEvent.getValue();
        if (n >= 0 && n <= this.saveLines) {
            this.visTop = n;
            this.makeAllDirty();
        }
    }

    public void makeSelection(int n, int n2, int n3, int n4) {
        if (n != n3) {
            int n5 = n2;
            while (n5 < this.cols) {
                int[] nArray = this.attributes[n];
                int n6 = n5 * 3;
                nArray[n6] = nArray[n6] | 0x1000;
                ++n5;
            }
            n5 = n + 1;
            while (n5 < n3) {
                int n7 = 0;
                while (n7 < this.cols) {
                    int[] nArray = this.attributes[n5];
                    int n8 = n7 * 3;
                    nArray[n8] = nArray[n8] | 0x1000;
                    ++n7;
                }
                ++n5;
            }
            n5 = 0;
            while (n5 <= n4) {
                int[] nArray = this.attributes[n3];
                int n9 = n5 * 3;
                nArray[n9] = nArray[n9] | 0x1000;
                ++n5;
            }
        } else {
            int n10 = n2;
            while (n10 <= n4) {
                int[] nArray = this.attributes[n];
                int n11 = n10 * 3;
                nArray[n11] = nArray[n11] | 0x1000;
                ++n10;
            }
        }
        n3 -= this.visTop;
        if ((n -= this.visTop) < 0) {
            n = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        this.updateDirtyArea(n, 0, n3 + 1, this.cols);
        if (!this.repaintPending) {
            this.dirtyCount = 2;
            this.repaintPending = true;
            this.repaint();
        }
    }

    public void clearSelection(int n, int n2, int n3, int n4) {
        if (n != n3) {
            int n5 = n2;
            while (n5 < this.cols) {
                int[] nArray = this.attributes[n];
                int n6 = n5 * 3;
                nArray[n6] = nArray[n6] & 0xFFFFEFFF;
                ++n5;
            }
            n5 = n + 1;
            while (n5 < n3) {
                int n7 = 0;
                while (n7 < this.cols) {
                    int[] nArray = this.attributes[n5];
                    int n8 = n7 * 3;
                    nArray[n8] = nArray[n8] & 0xFFFFEFFF;
                    ++n7;
                }
                ++n5;
            }
            n5 = 0;
            while (n5 <= n4) {
                int[] nArray = this.attributes[n3];
                int n9 = n5 * 3;
                nArray[n9] = nArray[n9] & 0xFFFFEFFF;
                ++n5;
            }
        } else {
            int n10 = n2;
            while (n10 <= n4) {
                int[] nArray = this.attributes[n];
                int n11 = n10 * 3;
                nArray[n11] = nArray[n11] & 0xFFFFEFFF;
                ++n10;
            }
        }
        n3 -= this.visTop;
        if ((n -= this.visTop) < 0) {
            n = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        this.updateDirtyArea(n, 0, n3 + 1, this.cols);
        if (!this.repaintPending) {
            this.dirtyCount = 2;
            this.repaintPending = true;
            this.repaint();
        }
    }

    public void clearSelection() {
        if (!this.hasSelection) {
            return;
        }
        if (this.selectReverse) {
            this.clearSelection(this.selectRowLast, this.selectColLast, this.selectRowAnchor, this.selectColAnchor);
        } else {
            this.clearSelection(this.selectRowAnchor, this.selectColAnchor, this.selectRowLast, this.selectColLast);
        }
        this.hasSelection = false;
    }

    public final void termSettingsMenu() {
        Serializable serializable;
        Object object;
        if (this.settingsDialog == null) {
            this.settingsDialog = new 6(this.ownerFrame, settingsMenu[0], true);
            this.te = TerminalXTerm.getTerminalTypes();
            object = this.getToolkit();
            this.fn = ((Toolkit)object).getFontList();
            this.sb = new String[3];
            this.sb[0] = "left";
            this.sb[1] = "right";
            this.sb[2] = "none";
            this.bs = new String[2];
            this.bs[0] = "DEL";
            this.bs[1] = "BS";
            this.rg = new String[2];
            this.rg[0] = "northwest";
            this.rg[1] = "southwest";
            this.settingsDialog.setLayout(new BorderLayout(5, 5));
            serializable = new Panel(new GridLayout(9, 2, 3, 3));
            ((Container)serializable).add(new Label("Terminal type:"));
            this.choiceTE = new Choice();
            int n = 0;
            while (n < this.te.length) {
                this.choiceTE.add(this.te[n]);
                ++n;
            }
            ((Container)serializable).add(this.choiceTE);
            ((Container)serializable).add(new Label("Font style:"));
            this.choiceFN = new Choice();
            n = 0;
            while (n < this.fn.length) {
                this.choiceFN.add(this.fn[n]);
                ++n;
            }
            ((Container)serializable).add(this.choiceFN);
            ((Container)serializable).add(new Label("Font size:"));
            this.textFS = new TextField("", 12);
            ((Container)serializable).add(this.textFS);
            ((Container)serializable).add(new Label("Scrollbar:"));
            this.choiceSB = new Choice();
            n = 0;
            while (n < this.sb.length) {
                this.choiceSB.add(this.sb[n]);
                ++n;
            }
            ((Container)serializable).add(this.choiceSB);
            ((Container)serializable).add(new Label("Backspace sends:"));
            this.choiceBS = new Choice();
            n = 0;
            while (n < this.bs.length) {
                this.choiceBS.add(this.bs[n]);
                ++n;
            }
            ((Container)serializable).add(this.choiceBS);
            ((Container)serializable).add(new Label("Resize gravity:"));
            this.choiceRG = new Choice();
            n = 0;
            while (n < this.rg.length) {
                this.choiceRG.add(this.rg[n]);
                ++n;
            }
            ((Container)serializable).add(this.choiceRG);
            ((Container)serializable).add(new Label("Savelines:"));
            this.textSL = new TextField("", 12);
            ((Container)serializable).add(this.textSL);
            ((Container)serializable).add(new Label("FG color:"));
            this.textFG = new TextField("", 12);
            ((Container)serializable).add(this.textFG);
            ((Container)serializable).add(new Label("BG color:"));
            this.textBG = new TextField("", 12);
            ((Container)serializable).add(this.textBG);
            this.settingsDialog.add((Component)serializable, "Center");
            serializable = new Panel(new GridLayout(2, 1, 2, 2));
            this.lblAlert = new Label("", 1);
            ((Container)serializable).add(this.lblAlert);
            Panel panel = new Panel(new FlowLayout());
            Button button = new Button("Cancel");
            panel.add(button);
            button.addActionListener(new 7());
            button = new Button("OK");
            panel.add(button);
            button.addActionListener(new 8());
            ((Container)serializable).add(panel);
            this.settingsDialog.add((Component)serializable, "South");
            this.settingsDialog.setResizable(false);
            this.settingsDialog.pack();
        }
        this.choiceTE.select(this.getProperty("te"));
        this.choiceFN.select(this.getProperty("fn"));
        ((TextComponent)this.textFS).setText(this.getProperty("fs"));
        this.choiceSB.select(this.getProperty("sb"));
        this.choiceBS.select(this.getProperty("bs"));
        this.choiceRG.select(this.getProperty("rg"));
        ((TextComponent)this.textSL).setText(this.getProperty("sl"));
        ((TextComponent)this.textFG).setText(this.getProperty("fg"));
        ((TextComponent)this.textBG).setText(this.getProperty("bg"));
        this.lblAlert.setText("");
        object = Toolkit.getDefaultToolkit().getScreenSize();
        serializable = this.settingsDialog.getSize();
        int n = ((Dimension)object).width / 2 - ((Dimension)serializable).width / 2;
        int n2 = ((Dimension)object).height / 2 - ((Dimension)serializable).height / 2;
        ((Component)this.settingsDialog).setLocation(n, n2);
        ((Component)this.settingsDialog).setVisible(true);
    }

    public final void termOptsItemStateChanged(int n) {
        this.setOption(n, !this.termOptions[n]);
    }

    final int mouseRow(int n) {
        int n2 = (n - this.borderHeight) / this.charHeight;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.rows) {
            n2 = this.rows - 1;
        }
        return n2;
    }

    final int mouseCol(int n) {
        int n2 = (n - this.borderWidth) / this.charWidth;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.cols) {
            n2 = this.cols - 1;
        }
        return n2;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.mouseRow(mouseEvent.getY());
        int n2 = this.mouseCol(mouseEvent.getX());
        if ((mouseEvent.getModifiers() & 6) == 6) {
            this.ctrlKeyKludge = false;
            if (this.popupmenu != null) {
                this.popupmenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            }
        }
        this.interpreter.mouseHandler(n, n2, true, mouseEvent.getModifiers());
        this.clearSelection();
        this.selectRowAnchor = n += this.visTop;
        this.selectColAnchor = n2;
        this.selectRowLast = n;
        this.selectColLast = n2;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = this.mouseRow(mouseEvent.getY());
        int n2 = this.mouseCol(mouseEvent.getX());
        if (this.listener != null) {
            String string;
            if ((mouseEvent.getModifiers() & 0x10) != 0) {
                if (this.hasSelection) {
                    this.listener.setSelection(this.getSelection());
                }
            } else if ((mouseEvent.getModifiers() & 8) != 0 && (string = this.listener.getSelection()) != null) {
                if (this.termOptions[11]) {
                    this.write(string);
                }
                this.sendBytes(string.getBytes());
            }
        }
        this.interpreter.mouseHandler(n, n2, false, mouseEvent.getModifiers());
    }

    public synchronized void mouseDragged(MouseEvent mouseEvent) {
        int n = (mouseEvent.getY() - this.borderHeight) / this.charHeight;
        int n2 = (mouseEvent.getX() - this.borderWidth) / this.charWidth;
        if (n < 0) {
            n = 0;
        } else if (n >= this.rows) {
            n = this.rows - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.cols) {
            n2 = this.cols - 1;
        }
        if ((n += this.visTop) == this.selectRowLast && n2 == this.selectColLast) {
            return;
        }
        boolean bl = this.selectRowAnchor > n || this.selectRowAnchor == n && n2 < this.selectColAnchor;
        if (bl != this.selectReverse) {
            if (this.selectReverse) {
                this.clearSelection(this.selectRowLast, this.selectColLast, this.selectRowAnchor, this.selectColAnchor);
            } else {
                this.clearSelection(this.selectRowAnchor, this.selectColAnchor, this.selectRowLast, this.selectColLast);
            }
            this.selectReverse = bl;
            this.selectRowLast = this.selectRowAnchor;
            this.selectColLast = this.selectColAnchor;
        }
        boolean bl2 = this.selectRowLast > n || this.selectRowLast == n && n2 < this.selectColLast;
        if (this.selectReverse) {
            if (bl2) {
                this.makeSelection(n, n2, this.selectRowLast, this.selectColLast);
            } else {
                this.clearSelection(this.selectRowLast, this.selectColLast, n, n2);
            }
        } else if (bl2) {
            this.clearSelection(n, n2, this.selectRowLast, this.selectColLast);
        } else {
            this.makeSelection(this.selectRowLast, this.selectColLast, n, n2);
        }
        this.selectReverse = bl;
        this.selectRowLast = n;
        this.selectColLast = n2;
        if (this.selectRowAnchor == this.selectRowLast && this.selectColAnchor == this.selectColLast) {
            this.hasSelection = false;
            return;
        }
        this.hasSelection = true;
    }

    final int nextPrintedChar(int n, int n2) {
        int n3 = n2;
        while (n3 < this.cols) {
            if (this.screen[n][n3] != '\u0000') break;
            ++n3;
        }
        return n3;
    }

    final String addSpaces(int n, int n2) {
        String string = "";
        int n3 = n2 - n;
        if (n2 == this.cols) {
            n3 = -1;
        }
        int n4 = 0;
        while (n4 <= n3) {
            string = String.valueOf(string) + " ";
            ++n4;
        }
        return string;
    }

    public String getSelection() {
        int n;
        int n2;
        int n3;
        int n4;
        if (!this.hasSelection) {
            return null;
        }
        String string = this.termOptions[8] ? "\r\n" : "\n";
        if (this.selectReverse) {
            n4 = this.selectRowLast;
            n3 = this.selectColLast;
            n2 = this.selectRowAnchor;
            n = this.selectColAnchor;
        } else {
            n4 = this.selectRowAnchor;
            n3 = this.selectColAnchor;
            n2 = this.selectRowLast;
            n = this.selectColLast;
        }
        String string2 = "";
        if (n4 != n2) {
            int n5;
            int n6 = n3;
            while (n6 < this.cols) {
                if (this.screen[n4][n6] == '\u0000') {
                    n5 = this.nextPrintedChar(n4, n6);
                    string2 = String.valueOf(string2) + this.addSpaces(n6, n5);
                    n6 = n5 - 1;
                } else {
                    string2 = String.valueOf(string2) + this.screen[n4][n6];
                }
                ++n6;
            }
            if (n6 == this.cols) {
                string2 = String.valueOf(string2) + string;
            }
            n6 = n4 + 1;
            while (n6 < n2) {
                int n7 = 0;
                while (n7 < this.cols) {
                    if (this.screen[n6][n7] == '\u0000') {
                        n5 = this.nextPrintedChar(n6, n7);
                        string2 = String.valueOf(string2) + this.addSpaces(n7, n5);
                        n7 = n5 - 1;
                    } else {
                        string2 = String.valueOf(string2) + this.screen[n6][n7];
                    }
                    ++n7;
                }
                string2 = String.valueOf(string2) + string;
                ++n6;
            }
            n6 = 0;
            while (n6 <= n) {
                if (this.screen[n2][n6] == '\u0000') {
                    n5 = this.nextPrintedChar(n2, n6);
                    string2 = String.valueOf(string2) + this.addSpaces(n6, n5);
                    n6 = n5 - 1;
                } else {
                    string2 = String.valueOf(string2) + this.screen[n2][n6];
                }
                ++n6;
            }
            if (n6 == this.cols) {
                string2 = String.valueOf(string2) + string;
            }
        } else {
            int n8 = n3;
            while (n8 <= n) {
                if (this.screen[n4][n8] == '\u0000') {
                    int n9 = this.nextPrintedChar(n4, n8);
                    string2 = String.valueOf(string2) + this.addSpaces(n8, n9);
                    n8 = n9 - 1;
                } else {
                    string2 = String.valueOf(string2) + this.screen[n4][n8];
                }
                ++n8;
            }
            if (n8 == this.cols) {
                string2 = String.valueOf(string2) + string;
            }
        }
        return string2;
    }

    public Dimension getDimensionOfText(int n, int n2) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.charWidth = -1;
        this.charHeight = fontMetrics.getHeight();
        this.charMaxAscent = fontMetrics.getMaxAscent();
        this.charMaxDescent = fontMetrics.getMaxDescent();
        this.charLeading = fontMetrics.getLeading();
        if (this.charWidth == -1) {
            this.charWidth = fontMetrics.charWidth('W');
        }
        return new Dimension(n2 * this.charWidth + 2 * this.borderHeight, n * this.charHeight + 2 * this.borderWidth);
    }

    public Dimension getPreferredSize() {
        return this.getDimensionOfText(this.rows, this.cols);
    }

    public Dimension getMinimumSize() {
        return this.getDimensionOfText(2, 8);
    }

    protected void clearDirtyClip(Graphics graphics) {
        int n = this.borderWidth + this.charWidth * this.dirtyLeft;
        int n2 = this.borderHeight + this.dirtyTop * this.charHeight;
        int n3 = this.charWidth * (this.dirtyRight - this.dirtyLeft);
        int n4 = this.charHeight * (this.dirtyBottom - this.dirtyTop);
        graphics.setColor(this.origBgColor);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(this.origFgColor);
        graphics.clipRect(n, n2, n3, n4);
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public synchronized void update(Graphics graphics) {
        int n;
        int n2;
        Dimension dimension = this.getSize();
        int n3 = this.charMaxAscent + this.charLeading - 1;
        if (!this.repaintPending) {
            this.dirtyCount = 2;
            this.dirtyTop = 0;
            this.dirtyBottom = this.rows;
            this.dirtyLeft = 0;
            this.dirtyRight = this.cols;
            graphics.setClip(0, 0, this.hpixels, this.vpixels);
        } else {
            this.repaintPending = false;
        }
        if (this.cursorDrawn) {
            n2 = this.borderWidth + this.charWidth * this.lastCursorCol;
            n = this.borderHeight + this.lastCursorRow * this.charHeight;
            graphics.setColor(this.origBgColor);
            graphics.setXORMode(this.origFgColor);
            graphics.fillRect(n2, n, this.charWidth, this.charHeight);
            graphics.setColor(this.origFgColor);
            graphics.setPaintMode();
            this.cursorDrawn = false;
        }
        if (this.dirtyCount > 1) {
            boolean bl;
            this.dirtyCount = 0;
            if (this.dirtyTop == this.rows) {
                this.dirtyTop = this.curRow;
            }
            if (this.dirtyBottom == 0) {
                this.dirtyBottom = this.curRow + 1;
            }
            if (this.dirtyRight == 0) {
                this.dirtyRight = this.curCol + 1;
            }
            if (this.dirtyLeft == this.cols) {
                this.dirtyLeft = this.curCol;
            }
            Graphics graphics2 = graphics;
            boolean bl2 = bl = (this.dirtyRight - this.dirtyLeft) * (this.dirtyBottom - this.dirtyTop) > 120;
            if (bl) {
                if (this.memGraphics == null || dimension.width != this.memImageSize.width || dimension.height != this.memImageSize.height) {
                    this.memImageSize = dimension;
                    this.memImage = this.createImage(dimension.width, dimension.height);
                    this.memGraphics = this.memImage.getGraphics();
                }
                this.clearDirtyClip(this.memGraphics);
                graphics2 = this.memGraphics;
            } else {
                this.clearDirtyClip(graphics);
            }
            int n4 = this.dirtyTop;
            while (n4 < this.dirtyBottom) {
                n = this.borderHeight + n4 * this.charHeight;
                int n5 = this.dirtyLeft;
                while (n5 < this.dirtyRight) {
                    int n6 = this.attributes[this.visTop + n4][n5 * 3];
                    if (n6 != 0) {
                        n2 = this.borderWidth + this.charWidth * n5;
                        if ((n6 & 0x10) != 0 ^ (n6 & 0x1000) != 0) {
                            graphics2.fillRect(n2, n, this.charWidth, this.charHeight);
                            graphics2.setColor(this.origBgColor);
                        } else if ((n6 & 0x80) != 0) {
                            graphics2.setColor(termColors[this.attributes[this.visTop + n4][n5 * 3 + 2]]);
                            graphics2.fillRect(n2, n, this.charWidth, this.charHeight);
                        }
                        if (n6 != 4096) {
                            if ((n6 & 0x40) != 0) {
                                graphics2.setColor(termColors[this.attributes[this.visTop + n4][n5 * 3 + 1]]);
                            }
                            if ((n6 & 0x100) != 0) {
                                this.drawLineDrawChar(graphics2, n2, n, this.screen[this.visTop + n4][n5]);
                            } else if ((n6 & 1) != 0) {
                                graphics2.setFont(this.boldFont);
                                graphics2.drawChars(this.screen[this.visTop + n4], n5, 1, n2, n + n3);
                                graphics2.setFont(this.plainFont);
                            } else {
                                graphics2.drawChars(this.screen[this.visTop + n4], n5, 1, n2, n + n3);
                            }
                            if ((n6 & 4) != 0) {
                                graphics2.drawLine(n2, n + n3, n2 + this.charWidth, n + n3);
                            }
                        }
                        graphics2.setColor(this.origFgColor);
                    }
                    ++n5;
                }
                ++n4;
            }
            if (bl) {
                this.clearDirtyClip(graphics);
                graphics.drawImage(this.memImage, 0, 0, this);
                this.memGraphics.setClip(0, 0, this.hpixels, this.vpixels);
            }
        } else if (this.dirtyCount == 1) {
            this.dirtyCount = 0;
            int n7 = this.attributes[this.visTop + this.lastWriteRow][this.lastWriteCol * 3];
            n2 = this.borderWidth + this.charWidth * this.lastWriteCol;
            n = this.borderHeight + this.lastWriteRow * this.charHeight;
            if ((n7 & 0x10) != 0) {
                graphics.fillRect(n2, n, this.charWidth, this.charHeight);
                graphics.setColor(this.origBgColor);
            } else {
                graphics.setColor(this.origBgColor);
                graphics.fillRect(n2, n, this.charWidth, this.charHeight);
                graphics.setColor(this.origFgColor);
            }
            if ((n7 & 1) != 0) {
                graphics.setFont(this.boldFont);
                graphics.drawChars(this.screen[this.visTop + this.lastWriteRow], this.lastWriteCol, 1, n2, n + n3);
                graphics.setFont(this.plainFont);
            } else {
                graphics.drawChars(this.screen[this.visTop + this.lastWriteRow], this.lastWriteCol, 1, n2, n + n3);
            }
            if ((n7 & 4) != 0) {
                graphics.drawLine(n2, n + n3, n2 + this.charWidth, n + n3);
            }
            graphics.setColor(this.origFgColor);
        }
        this.dirtyTop = this.rows;
        this.dirtyBottom = 0;
        this.dirtyLeft = this.cols;
        this.dirtyRight = 0;
        graphics.setClip(0, 0, this.hpixels, this.vpixels);
        if (this.termOptions[9]) {
            n2 = this.borderWidth + this.charWidth * this.curCol;
            n = this.borderHeight + this.curRow * this.charHeight;
            graphics.setColor(this.origFgColor);
            graphics.setXORMode(this.origBgColor);
            graphics.fillRect(n2, n, this.charWidth, this.charHeight);
            graphics.setPaintMode();
            this.cursorDrawn = true;
        }
        this.lastCursorRow = this.curRow;
        this.lastCursorCol = this.curCol;
    }

    final void drawLineDrawChar(Graphics graphics, int n, int n2, char c) {
        int n3 = n + this.charWidth / 2;
        int n4 = n2 + this.charHeight / 2;
        int n5 = n + this.charWidth;
        int n6 = n2 + this.charHeight;
        switch (c) {
            case '`': {
                graphics.drawLine(n3, n2, n5, n4);
                graphics.drawLine(n5, n4, n3, n6);
                graphics.drawLine(n3, n6, n, n4);
                graphics.drawLine(n, n4, n3, n2);
                return;
            }
            case 'o': {
                graphics.drawLine(n, n2, n5, n2);
                return;
            }
            case 's': {
                graphics.drawLine(n, n6, n5, n6);
                return;
            }
            case 'l': {
                graphics.drawLine(n3, n6, n3, n4);
                graphics.drawLine(n3, n4, n5, n4);
                return;
            }
            case 'k': {
                graphics.drawLine(n, n4, n3, n4);
                graphics.drawLine(n3, n4, n3, n6);
                return;
            }
            case 'm': {
                graphics.drawLine(n3, n2, n3, n4);
                graphics.drawLine(n3, n4, n5, n4);
                return;
            }
            case 'j': {
                graphics.drawLine(n3, n2, n3, n4);
                graphics.drawLine(n3, n4, n, n4);
                return;
            }
            case 'q': {
                graphics.drawLine(n, n4, n5, n4);
                return;
            }
            case 'x': {
                graphics.drawLine(n3, n2, n3, n6);
                return;
            }
            case 'n': {
                graphics.drawLine(n3, n2, n3, n6);
                graphics.drawLine(n, n4, n5, n4);
                return;
            }
            case 'u': {
                graphics.drawLine(n3, n2, n3, n6);
                graphics.drawLine(n, n4, n3, n4);
                return;
            }
            case 't': {
                graphics.drawLine(n3, n2, n3, n6);
                graphics.drawLine(n3, n4, n5, n4);
                return;
            }
            case 'v': {
                graphics.drawLine(n, n4, n5, n4);
                graphics.drawLine(n3, n4, n3, n2);
                return;
            }
            case 'w': {
                graphics.drawLine(n, n4, n5, n4);
                graphics.drawLine(n3, n4, n3, n6);
                return;
            }
            default: {
                System.out.println("Unknown line-draw-char: " + c + " (" + c + ")");
            }
            case ' ': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '0': 
            case '_': 
            case 'a': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'p': 
            case 'r': 
            case 'y': 
            case 'z': 
            case '{': 
            case '|': 
            case '}': 
            case '~': 
        }
    }

    static {
        int n = 0;
        while (n < 512) {
            TerminalWin.spacerow[n] = 32;
            int n2 = 0;
            while (n2 < 3) {
                TerminalWin.zerorow[n * 3 + n2] = 0;
                ++n2;
            }
            ++n;
        }
        settingsMenu = new String[]{"Terminal Settings", "Emulation", "Resize gravity", "Font", "Savelines", "Scrollbar", "Colors", "Backspace"};
        optionsMenu = new String[]{"Terminal Options", "Reverse Video", "Auto Wraparound", "Reverse Wraparound", "Insert mode", "Auto Linefeed", "Scroll to Bottom on Key Press", "Scroll to Bottom on Tty Output", "Local Page-ctrl Keys", "Copy <CR><NL> instead of <NL>", "Visible Cursor", "ASCII Line-draw-characters", "Local Echo", "Scale Font on Resize", "Visual Bell", "Map <CTRL>+<SPC> to <NUL>"};
        defaultProperties = new Properties();
        defaultPropDesc = new String[][]{{"rv", "false", "reverse video", "(true/false)"}, {"aw", "true", "autowrap of line if output reaches edge of window", "(true/false)"}, {"rw", "false", "reverse autowrap when going off left edge of window", "(true/false)"}, {"im", "false", "insert mode", "(true/false)"}, {"al", "false", "do auto-linefeed", "(true/false)"}, {"sk", "true", "reposition scroll-area to bottom on keyboard input", "(true/false)"}, {"si", "true", "reposition scroll-area to bottom on output to screen", "(true/false)"}, {"lp", "false", "use PgUp, PgDn, Home, End keys locally or escape them to shell", "(true/false)"}, {"sc", "false", "put <CR><NL> instead of <NL> at end of lines when selecting", "(true/false)"}, {"vi", "true", "visible cursor", "(true/false)"}, {"ad", "false", "ASCII Line-draw-characters", "(true/false)"}, {"le", "false", "do local echo", "(true/false)"}, {"sf", "false", "scale font when resizing window", "(true/false)"}, {"vb", "false", "visual bell", "(true/false)"}, {"ct", "true", "map <ctrl>+<space> to <NUL>", "(true/false)"}, {"te", TerminalXTerm.terminalTypes[0], "name of terminal to emulate", "(" + TerminalXTerm.listAvailableTerminalTypes() + ")"}, {"fn", "Courier", "name of font to use in terminal", "(" + TerminalWin.fontList() + ")"}, {"fs", "12", "size of font to use in terminal", "(system dep.)"}, {"sl", "1024", "number of lines to save in \"scrollback\" buffer", "(0 - 32k)"}, {"sb", "right", "scrollbar position", "(none/left/right)"}, {"bg", "#7", "background color", "('#0'...'#15' or '<r>,<g>,<b>')"}, {"fg", "#0", "foreground color", "('#0'...'#15' or '<r>,<g>,<b>')"}, {"rg", "southwest", "resize gravity, fixpoint of screen when resizing", "(southwest/northwest)"}, {"bs", "DEL", "character to send on BACKSPACE", "('BS' or 'DEL')"}};
        n = 0;
        while (n < defaultPropDesc.length) {
            ((Hashtable)defaultProperties).put(defaultPropDesc[n][0], defaultPropDesc[n][1]);
            ++n;
        }
    }

    private final class 1
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            TerminalWin.this.componentResized(componentEvent);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent mouseEvent) {
            TerminalWin.this.mouseDragged(mouseEvent);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            TerminalWin.this.mousePressed(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            TerminalWin.this.mouseReleased(mouseEvent);
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            TerminalWin.this.termSettingsMenu();
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            int n = 0;
            while (n < TerminalWin.this.optionsItems.length) {
                if (TerminalWin.this.optionsItems[n] == itemEvent.getItemSelectable()) break;
                ++n;
            }
            if (n >= TerminalWin.this.optionsItems.length) {
                return;
            }
            TerminalWin.this.termOptsItemStateChanged(n);
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    extends Dialog {
        public Insets getInsets() {
            Insets insets = super.getInsets();
            insets.left = 5;
            insets.right = 5;
            insets.bottom += 5;
            insets.top += 5;
            return insets;
        }

        /* synthetic */ 6(Frame frame, String string, boolean bl) {
            super(frame, string, bl);
        }
    }

    private final class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ((Component)TerminalWin.this.settingsDialog).setVisible(false);
        }

        /* synthetic */ 7() {
        }
    }

    private final class 8
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                TerminalWin.this.setProperty("te", TerminalWin.this.te[TerminalWin.this.choiceTE.getSelectedIndex()]);
                TerminalWin.this.setProperty("fn", TerminalWin.this.fn[TerminalWin.this.choiceFN.getSelectedIndex()]);
                TerminalWin.this.setProperty("sb", TerminalWin.this.sb[TerminalWin.this.choiceSB.getSelectedIndex()]);
                TerminalWin.this.setProperty("rg", TerminalWin.this.rg[TerminalWin.this.choiceRG.getSelectedIndex()]);
                TerminalWin.this.setProperty("fs", TerminalWin.this.textFS.getText());
                TerminalWin.this.setProperty("sl", TerminalWin.this.textSL.getText());
                TerminalWin.this.setProperty("fg", TerminalWin.this.textFG.getText());
                TerminalWin.this.setProperty("bg", TerminalWin.this.textBG.getText());
                TerminalWin.this.setProperty("bs", TerminalWin.this.bs[TerminalWin.this.choiceBS.getSelectedIndex()]);
                ((Component)TerminalWin.this.settingsDialog).setVisible(false);
                return;
            }
            catch (Exception exception) {
                TerminalWin.this.lblAlert.setText(exception.getMessage());
                return;
            }
        }

        /* synthetic */ 8() {
        }
    }
}

