/*
 * Decompiled with CFR 0.152.
 */
package mindbright.terminal;

import java.util.NoSuchElementException;
import mindbright.terminal.TerminalInterpreter;
import mindbright.terminal.TerminalWin;

public class TerminalXTerm
extends TerminalInterpreter {
    public static final boolean DEBUG = false;
    public static final boolean DEBUGNOTIMPL = true;
    public static final boolean DEBUGPRINT = false;
    public static final int CASE_GROUND_STATE = 0;
    public static final int CASE_IGNORE_STATE = 1;
    public static final int CASE_IGNORE_ESC = 2;
    public static final int CASE_IGNORE = 3;
    public static final int CASE_BELL = 4;
    public static final int CASE_BS = 5;
    public static final int CASE_CR = 6;
    public static final int CASE_ESC = 7;
    public static final int CASE_VMOT = 8;
    public static final int CASE_TAB = 9;
    public static final int CASE_SI = 10;
    public static final int CASE_SO = 11;
    public static final int CASE_SCR_STATE = 12;
    public static final int CASE_SCS0_STATE = 13;
    public static final int CASE_SCS1_STATE = 14;
    public static final int CASE_SCS2_STATE = 15;
    public static final int CASE_SCS3_STATE = 16;
    public static final int CASE_ESC_IGNORE = 17;
    public static final int CASE_ESC_DIGIT = 18;
    public static final int CASE_ESC_SEMI = 19;
    public static final int CASE_DEC_STATE = 20;
    public static final int CASE_ICH = 21;
    public static final int CASE_CUU = 22;
    public static final int CASE_CUD = 23;
    public static final int CASE_CUF = 24;
    public static final int CASE_CUB = 25;
    public static final int CASE_CUP = 26;
    public static final int CASE_ED = 27;
    public static final int CASE_EL = 28;
    public static final int CASE_IL = 29;
    public static final int CASE_DL = 30;
    public static final int CASE_DCH = 31;
    public static final int CASE_DA1 = 32;
    public static final int CASE_TRACK_MOUSE = 33;
    public static final int CASE_TBC = 34;
    public static final int CASE_SET = 35;
    public static final int CASE_RST = 36;
    public static final int CASE_SGR = 37;
    public static final int CASE_CPR = 38;
    public static final int CASE_DECSTBM = 39;
    public static final int CASE_DECREQTPARM = 40;
    public static final int CASE_DECSET = 41;
    public static final int CASE_DECRST = 42;
    public static final int CASE_DECALN = 43;
    public static final int CASE_GSETS = 44;
    public static final int CASE_DECSC = 45;
    public static final int CASE_DECRC = 46;
    public static final int CASE_DECKPAM = 47;
    public static final int CASE_DECKPNM = 48;
    public static final int CASE_IND = 49;
    public static final int CASE_NEL = 50;
    public static final int CASE_HTS = 51;
    public static final int CASE_RI = 52;
    public static final int CASE_SS2 = 53;
    public static final int CASE_SS3 = 54;
    public static final int CASE_CSI_STATE = 55;
    public static final int CASE_OSC = 56;
    public static final int CASE_RIS = 57;
    public static final int CASE_LS2 = 58;
    public static final int CASE_LS3 = 59;
    public static final int CASE_LS3R = 60;
    public static final int CASE_LS2R = 61;
    public static final int CASE_LS1R = 62;
    public static final int CASE_PRINT = 63;
    public static final int CASE_XTERM_SAVE = 64;
    public static final int CASE_XTERM_RESTORE = 65;
    public static final int CASE_XTERM_TITLE = 66;
    public static final int CASE_DECID = 67;
    public static final int CASE_HP_MEM_LOCK = 68;
    public static final int CASE_HP_MEM_UNLOCK = 69;
    public static final int CASE_HP_BUGGY_LL = 70;
    public static final int CASE_SEQ_CAPTURE = 71;
    public static final int CASE_ESC_SEMIOSC = 72;
    public static final int CASE_XTERM_SEQ = 73;
    public static final int CASE_ENQ = 74;
    public static final int CASE_XTERMWIN = 75;
    public static final int CASE_CNL = 76;
    public static final int CASE_CPL = 77;
    public static final int CASE_CHA = 78;
    public static final int CASE_CHT = 79;
    public static final int CASE_SU = 80;
    public static final int CASE_ECH = 81;
    public static final int CASE_CBT = 82;
    public static final int CASE_HPA = 83;
    public static final int CASE_REP = 84;
    public static final int CASE_VPA = 85;
    public static final int[] asciiLineDrawChars = new int[]{32, 43, 58, 32, 32, 32, 32, 92, 35, 35, 35, 43, 43, 43, 43, 43, 126, 45, 45, 45, 95, 43, 43, 43, 43, 124, 60, 62, 42, 33, 102, 111, 62, 60, 94, 118};
    public static final int XVK_UP = 0;
    public static final int XVK_DOWN = 1;
    public static final int XVK_RIGHT = 2;
    public static final int XVK_LEFT = 3;
    public static final int XVK_PAGE_UP = 4;
    public static final int XVK_PAGE_DOWN = 5;
    public static final int XVK_END = 6;
    public static final int XVK_HOME = 7;
    public static final int XVK_F1 = 8;
    public static final int XVK_F2 = 9;
    public static final int XVK_F3 = 10;
    public static final int XVK_F4 = 11;
    public static final int XVK_F5 = 12;
    public static final int XVK_F6 = 13;
    public static final int XVK_F7 = 14;
    public static final int XVK_F8 = 15;
    public static final int XVK_F9 = 16;
    public static final int XVK_F10 = 17;
    public static final int XVK_F11 = 18;
    public static final int XVK_F12 = 19;
    public static final int XVK_NUMPAD0 = 20;
    public static final int XVK_NUMPAD1 = 21;
    public static final int XVK_NUMPAD2 = 22;
    public static final int XVK_NUMPAD3 = 23;
    public static final int XVK_NUMPAD4 = 24;
    public static final int XVK_NUMPAD5 = 25;
    public static final int XVK_NUMPAD6 = 26;
    public static final int XVK_NUMPAD7 = 27;
    public static final int XVK_NUMPAD8 = 28;
    public static final int XVK_NUMPAD9 = 29;
    public static final int XVK_MULTIPLY = 30;
    public static final int XVK_ADD = 31;
    public static final int XVK_SUBTRACT = 32;
    public static final int XVK_DIVIDE = 33;
    public static final int XVK_MAX = 34;
    public final int[] vk2xvk = new int[]{38, 40, 39, 37, 33, 34, 35, 36, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 109, 111};
    public static final int EMUL_XTERM = 0;
    public static final int EMUL_LINUX = 1;
    public static final int EMUL_SCOANSI = 2;
    public static final int EMUL_ATT6386 = 3;
    public static final int EMUL_SUN = 4;
    public static final int EMUL_VT220 = 5;
    public static final int EMUL_VT100 = 6;
    public static final int EMUL_ANSI = 7;
    public static final int EMUL_VT52 = 8;
    public static final int EMUL_ALTERNATENAME = 9;
    public static final int EMUL_XTERMCOL = 9;
    public static final int EMUL_LINUXLAT = 10;
    public static final int EMUL_VT102 = 15;
    public static final int DEFAULT_TERM = 0;
    public static final String[] terminalTypes = new String[]{"xterm", "linux", "scoansi", "att6386", "sun", "vt220", "vt100", "ansi", "vt52", "xterm-color", "linux-lat", "", "at386", "", "", "vt102"};
    int whoAmI;
    public static final String[][] specialKeyMap = new String[][]{{"A", "A", "A", "A", "A", "A", "A", "A", "A"}, {"B", "B", "B", "B", "B", "B", "B", "B", "B"}, {"C", "C", "C", "C", "C", "C", "C", "C", "C"}, {"D", "D", "D", "D", "D", "D", "D", "D", "D"}, {"5~", "5~", "I", "V", "216z", "5~", "5~", "5~", "5~"}, {"6~", "6~", "G", "U", "222z", "6~", "6~", "6~", "6~"}, {"4~", "4~", "F", "Y", "220z", "4~", "4~", "4~", "4~"}, {"@", "1~", "H", "H", "214z", "1~", "1~", "1~", "1~"}, {"11~", "[A", "M", "P", "224z", "P", "P", "P", "P"}, {"12~", "[B", "N", "Q", "225z", "Q", "Q", "Q", "Q"}, {"13~", "[C", "O", "R", "226z", "R", "R", "R", "R"}, {"14~", "[D", "P", "S", "227z", "S", "S", "S", "S"}, {"15~", "[E", "Q", "T", "228z", "17~", null, null, null}, {"17~", "17~", "R", "U", "229z", "18~", null, null, null}, {"18~", "18~", "S", "V", "230z", "19~", null, null, null}, {"19~", "19~", "T", "W", "231z", "20~", null, null, null}, {"20~", "20~", "U", "X", "232z", "21~", null, null, null}, {"21~", "21~", "V", "Y", "233z", "29~", null, null, null}, {"23~", "23~", null, "Z", "234z", null, null, null, null}, {"24~", "24~", null, "A", "235z", null, null, null, null}};
    public static final int R_ESC = 0;
    public static final int R_SS2 = 1;
    public static final int R_SS3 = 2;
    public static final int R_DCS = 3;
    public static final int R_CSI = 4;
    public static final int R_OSC = 5;
    public static final int R_PM = 6;
    public static final int R_APC = 7;
    public static final String[] replyTypes = new String[]{"\u001b", "\u001bN", "\u001bO", "\u001bP", "\u001b[", "\u001b]", "\u001b^", "\u001b_"};
    public static final char CHARSET_UK = 'A';
    public static final char CHARSET_ASCII = 'B';
    public static final char CHARSET_LINES = '0';
    char[] gSets = new char[4];
    int scsType;
    int curGL;
    int curSS;
    String xtermSeq;
    String reply;
    public static final int PARAMNOTUSED = -1;
    int[] parseState;
    boolean windowRelative;
    boolean keypadAppl;
    boolean cursorKeysMode;
    public static final int MOUSE_DONTSEND = 0;
    public static final int MOUSE_X10COMP = 1;
    public static final int MOUSE_DECVT200 = 2;
    public static final int MOUSE_HLTRACK = 3;
    int sendMousePos;
    int[] param = new int[10];
    int nparam;
    public static final int[] groundTable;
    public static final int[] csiTable;
    public static final int[] decTable;
    public static final int[] oscTable;
    public static final int[] xtermSeqTable;
    public static final int[] eigTable;
    public static final int[] escTable;
    public static final int[] iesTable;
    public static final int[] ignTable;
    public static final int[] scrTable;
    public static final int[] scsTable;

    public TerminalXTerm() {
        this(0);
    }

    public TerminalXTerm(int n) {
        this.whoAmI = n;
        this.vtReset();
    }

    public static String listAvailableTerminalTypes() {
        String string = " ";
        int n = 0;
        while (n < terminalTypes.length) {
            string = String.valueOf(string) + terminalTypes[n] + " ";
            ++n;
        }
        return string;
    }

    public static String[] getTerminalTypes() {
        int n = 0;
        int n2 = 0;
        while (n2 < terminalTypes.length) {
            if (!terminalTypes[n2].equals("")) {
                ++n;
            }
            ++n2;
        }
        String[] stringArray = new String[n];
        n = 0;
        n2 = 0;
        while (n2 < terminalTypes.length) {
            if (!terminalTypes[n2].equals("")) {
                stringArray[n++] = terminalTypes[n2];
            }
            ++n2;
        }
        return stringArray;
    }

    public String terminalType() {
        return terminalTypes[this.whoAmI];
    }

    protected void setTerminalType(String string) throws NoSuchElementException {
        int n = 0;
        while (n < terminalTypes.length) {
            if (terminalTypes[n].equals(string)) break;
            ++n;
        }
        if (n < terminalTypes.length) {
            this.whoAmI = n;
            this.vtReset();
            return;
        }
        throw new NoSuchElementException(String.valueOf(string) + " is not a supported terminal-emulation");
    }

    final int mapLineDrawToAscii(char c) {
        if (c >= '_' && c <= '~') {
            c = (char)asciiLineDrawChars[c - 95];
        } else if (c >= '+' && c <= '.') {
            c = (char)asciiLineDrawChars[c - 43 + 32];
        } else if (c != ' ') {
            this.notImplemented("ASCII line-draw-char: " + c + " (" + c + ")");
        }
        return c;
    }

    final char mapLineDrawToLinux(char c) {
        switch (c) {
            case ' ': {
                c = (char)32;
                break;
            }
            case '\u0004': {
                c = (char)96;
                break;
            }
            case '\u00b1': {
                c = (char)97;
                break;
            }
            case '\u00f8': {
                c = (char)102;
                break;
            }
            case '\u00f1': {
                c = (char)103;
                break;
            }
            case '\u00b0': {
                c = (char)104;
                break;
            }
            case '\u0089': 
            case '\u00d9': {
                c = (char)106;
                break;
            }
            case '\u008c': 
            case '\u00bf': {
                c = (char)107;
                break;
            }
            case '\u0086': 
            case '\u00da': {
                c = (char)108;
                break;
            }
            case '\u0083': 
            case '\u00c0': {
                c = (char)109;
                break;
            }
            case '\u00c5': {
                c = (char)110;
                break;
            }
            case '\u008a': 
            case '\u00c4': {
                c = (char)113;
                break;
            }
            case '\u00f2': {
                c = (char)114;
                break;
            }
            case '\u0087': 
            case '\u00c3': {
                c = (char)116;
                break;
            }
            case '\u008d': 
            case '\u00b4': {
                c = (char)117;
                break;
            }
            case '\u00c1': {
                c = (char)118;
                break;
            }
            case '\u00c2': {
                c = (char)119;
                break;
            }
            case '\u0085': 
            case '\u00b3': {
                c = (char)120;
                break;
            }
            case '\u00f3': 
            case '\u00f9': {
                c = (char)121;
                break;
            }
            case '\u00fa': {
                c = (char)122;
                break;
            }
            case '\u00e3': 
            case '\u00fb': {
                c = (char)123;
                break;
            }
            case '\u00d8': 
            case '\u00fc': {
                c = (char)124;
                break;
            }
            case '\u009c': 
            case '\u00fd': {
                c = (char)125;
                break;
            }
            case '\u00fe': {
                c = (char)126;
                break;
            }
            case '\u0019': {
                c = (char)46;
                break;
            }
            case '\u00db': {
                c = (char)43;
                break;
            }
            case '\u0018': {
                c = (char)45;
                break;
            }
            default: {
                this.notImplemented("linux line-draw-char: " + c + " (" + c + ")");
            }
        }
        return c;
    }

    final char mapLineDrawToATT6386(char c) {
        switch (c) {
            case ' ': {
                c = (char)32;
                break;
            }
            case '`': {
                c = (char)96;
                break;
            }
            case '1': {
                c = (char)97;
                break;
            }
            case 'x': {
                c = (char)102;
                break;
            }
            case 'q': {
                c = (char)103;
                break;
            }
            case '0': {
                c = (char)104;
                break;
            }
            case 'Y': {
                c = (char)106;
                break;
            }
            case '?': {
                c = (char)107;
                break;
            }
            case 'Z': {
                c = (char)108;
                break;
            }
            case '@': {
                c = (char)109;
                break;
            }
            case 'E': {
                c = (char)110;
                break;
            }
            case 'o': {
                c = (char)111;
                break;
            }
            case 'p': {
                c = (char)112;
                break;
            }
            case 'D': {
                c = (char)113;
                break;
            }
            case 'r': {
                c = (char)114;
                break;
            }
            case 's': {
                c = (char)115;
                break;
            }
            case 'C': {
                c = (char)116;
                break;
            }
            case '4': {
                c = (char)117;
                break;
            }
            case 'A': {
                c = (char)118;
                break;
            }
            case 'B': {
                c = (char)119;
                break;
            }
            case '3': {
                c = (char)120;
                break;
            }
            case 'y': {
                c = (char)121;
                break;
            }
            case 'z': {
                c = (char)122;
                break;
            }
            case '{': {
                c = (char)123;
                break;
            }
            case '|': {
                c = (char)124;
                break;
            }
            case '}': {
                c = (char)125;
                break;
            }
            case '~': {
                c = (char)126;
                break;
            }
            default: {
                this.notImplemented("att6386 line-draw-char: " + c + " (" + c + ")");
            }
        }
        return c;
    }

    public int interpretChar(char c) {
        if (c > '\u00ff') {
            return c;
        }
        switch (this.parseState[c]) {
            case 63: {
                char c2 = this.gSets[this.curGL];
                int n = -1;
                switch (c2) {
                    case 'A': {
                        if (c != '#') break;
                        n = 30;
                        break;
                    }
                    case 'B': {
                        n = c;
                        break;
                    }
                    case '0': {
                        if (!this.term.getOption(10)) {
                            if (this.whoAmI == 1 || this.whoAmI == 10) {
                                c = this.mapLineDrawToLinux(c);
                            } else if (this.whoAmI == 3) {
                                c = this.mapLineDrawToATT6386(c);
                            }
                            this.term.writeLineDrawChar(c);
                            break;
                        }
                        n = this.mapLineDrawToAscii(c);
                        break;
                    }
                    default: {
                        this.notImplemented("unknown char-set: " + c2 + " (" + c2 + ")");
                    }
                }
                return n;
            }
            case 0: {
                this.parseState = groundTable;
                break;
            }
            case 1: {
                this.parseState = ignTable;
                break;
            }
            case 2: {
                this.parseState = iesTable;
                break;
            }
            case 4: {
                this.term.doBell();
                break;
            }
            case 5: {
                this.term.doBS();
                break;
            }
            case 6: {
                this.term.doCR();
                this.parseState = groundTable;
                break;
            }
            case 7: {
                this.parseState = escTable;
                break;
            }
            case 8: {
                this.term.doLF();
                this.parseState = groundTable;
                break;
            }
            case 9: {
                this.term.doTab();
                break;
            }
            case 10: {
                this.curGL = 0;
                break;
            }
            case 11: {
                this.curGL = 1;
                break;
            }
            case 12: {
                this.parseState = scrTable;
                break;
            }
            case 13: {
                this.scsType = 0;
                this.parseState = scsTable;
                break;
            }
            case 14: {
                this.scsType = 1;
                this.parseState = scsTable;
                break;
            }
            case 15: {
                this.scsType = 2;
                this.parseState = scsTable;
                break;
            }
            case 16: {
                this.scsType = 3;
                this.parseState = scsTable;
                break;
            }
            case 17: {
                this.parseState = eigTable;
                break;
            }
            case 18: {
                int n = this.param[this.nparam - 1];
                if (n == -1) {
                    n = 0;
                }
                this.param[this.nparam - 1] = 10 * n + (c - 48);
                break;
            }
            case 19: {
                this.param[this.nparam++] = -1;
                break;
            }
            case 72: {
                this.param[this.nparam++] = -1;
                this.xtermSeq = "";
                this.parseState = xtermSeqTable;
                break;
            }
            case 20: {
                this.parseState = decTable;
                break;
            }
            case 21: {
                int n = this.param[0];
                if (n < 1) {
                    n = 1;
                }
                this.term.insertChars(n);
                this.parseState = groundTable;
                break;
            }
            case 22: 
            case 77: {
                int n = this.param[0];
                if (n < 1) {
                    n = 1;
                }
                this.term.cursorUp(n);
                this.parseState = groundTable;
                break;
            }
            case 23: 
            case 76: {
                int n = this.param[0];
                if (n < 1) {
                    n = 1;
                }
                this.term.cursorDown(n);
                this.parseState = groundTable;
                break;
            }
            case 24: {
                int n = this.param[0];
                if (n < 1) {
                    n = 1;
                }
                this.term.cursorForward(n);
                this.parseState = groundTable;
                break;
            }
            case 25: {
                int n = this.param[0];
                if (n < 1) {
                    n = 1;
                }
                this.term.cursorBackward(n);
                this.parseState = groundTable;
                break;
            }
            case 26: {
                int n = this.param[0];
                int n2 = this.param[1];
                if (n < 1) {
                    n = 1;
                }
                if (this.nparam < 2 || n2 < 1) {
                    n2 = 1;
                }
                this.term.cursorSetPos(n - 1, n2 - 1, this.windowRelative);
                this.parseState = groundTable;
                break;
            }
            case 27: {
                switch (this.param[0]) {
                    case -1: 
                    case 0: {
                        this.term.clearBelow();
                        break;
                    }
                    case 1: {
                        this.term.clearAbove();
                        break;
                    }
                    case 2: {
                        this.term.clearScreen();
                        this.term.cursorSetPos(0, 0, this.windowRelative);
                        break;
                    }
                }
                this.parseState = groundTable;
                break;
            }
            case 28: {
                switch (this.param[0]) {
                    case -1: 
                    case 0: {
                        this.term.clearRight();
                        break;
                    }
                    case 1: {
                        this.term.clearLeft();
                        break;
                    }
                    case 2: {
                        this.term.clearLine();
                        break;
                    }
                }
                this.parseState = groundTable;
                break;
            }
            case 29: {
                int n = this.param[0];
                if (n < 1) {
                    n = 1;
                }
                this.term.insertLines(n);
                this.parseState = groundTable;
                break;
            }
            case 30: {
                int n = this.param[0];
                if (n < 1) {
                    n = 1;
                }
                this.term.deleteLines(n);
                this.parseState = groundTable;
                break;
            }
            case 31: {
                int n = this.param[0];
                if (n < 1) {
                    n = 1;
                }
                this.term.deleteChars(n);
                this.parseState = groundTable;
                break;
            }
            case 67: {
                this.notImplemented("DECID");
                this.param[0] = -1;
                break;
            }
            case 32: {
                this.reply = String.valueOf(replyTypes[4]) + "?1;2c";
                this.term.sendBytes(this.reply.getBytes());
                this.parseState = groundTable;
                break;
            }
            case 33: {
                this.notImplemented("TRACK_MOUSE");
                break;
            }
            case 34: {
                this.notImplemented("TBC");
                this.parseState = groundTable;
                break;
            }
            case 35: {
                this.ansiModes(true);
                this.parseState = groundTable;
                break;
            }
            case 36: {
                this.ansiModes(false);
                this.parseState = groundTable;
                break;
            }
            case 37: {
                this.sgrModes();
                this.parseState = groundTable;
                break;
            }
            case 38: {
                this.reply = null;
                if (this.param[0] == 5) {
                    this.reply = String.valueOf(replyTypes[4]) + "0n";
                } else if (this.param[0] == 6) {
                    this.reply = String.valueOf(replyTypes[4]) + (this.term.getCursorV() + 1) + ";" + (this.term.getCursorH() + 1) + "R";
                }
                if (this.reply != null) {
                    this.term.sendBytes(this.reply.getBytes());
                }
                this.parseState = groundTable;
                break;
            }
            case 39: {
                int n = this.param[0];
                int n3 = this.param[1];
                if (n < 1) {
                    n = 1;
                }
                if (this.nparam < 2 || n3 == -1 || n3 == 0 || n3 > this.term.rows()) {
                    n3 = this.term.rows();
                }
                if (n3 > n) {
                    this.term.setWindow(n - 1, n3);
                    this.term.cursorSetPos(0, 0, this.windowRelative);
                }
                this.parseState = groundTable;
                break;
            }
            case 40: {
                if (this.param[0] == -1 || this.param[0] == 1 || this.param[0] == 0) {
                    this.reply = String.valueOf(replyTypes[4]) + String.valueOf(this.term.getCursorV() + 2) + ";1;1;112;112;1;0x";
                }
                if (this.reply != null) {
                    this.term.sendBytes(this.reply.getBytes());
                }
                this.parseState = groundTable;
                break;
            }
            case 41: {
                this.dpModes(true);
                this.parseState = groundTable;
                break;
            }
            case 42: {
                this.dpModes(false);
                this.parseState = groundTable;
                break;
            }
            case 43: {
                this.notImplemented("DECALN");
                this.parseState = groundTable;
                break;
            }
            case 44: {
                this.gSets[this.scsType] = c;
                this.parseState = groundTable;
                break;
            }
            case 45: {
                this.term.cursorSave();
                this.parseState = groundTable;
                break;
            }
            case 46: {
                this.term.cursorRestore();
                this.parseState = groundTable;
                break;
            }
            case 47: {
                this.keypadAppl = true;
                this.parseState = groundTable;
                break;
            }
            case 48: {
                this.keypadAppl = false;
                this.parseState = groundTable;
                break;
            }
            case 49: {
                this.term.cursorIndex(1);
                this.parseState = groundTable;
                break;
            }
            case 50: {
                this.term.cursorIndex(1);
                this.term.doCR();
                this.parseState = groundTable;
                break;
            }
            case 51: {
                this.notImplemented("HTS");
                this.parseState = groundTable;
                break;
            }
            case 52: {
                this.term.cursorIndexRev(1);
                this.parseState = groundTable;
                break;
            }
            case 53: {
                this.curSS = 2;
                this.parseState = groundTable;
                break;
            }
            case 54: {
                this.curSS = 3;
                this.parseState = groundTable;
                break;
            }
            case 55: {
                this.param[0] = -1;
                this.nparam = 1;
                this.parseState = csiTable;
                break;
            }
            case 56: {
                this.param[0] = -1;
                this.nparam = 1;
                this.parseState = oscTable;
                break;
            }
            case 57: {
                this.vtReset();
                this.parseState = groundTable;
                break;
            }
            case 58: {
                this.curGL = 2;
                this.parseState = groundTable;
                break;
            }
            case 59: {
                this.curGL = 3;
                this.parseState = groundTable;
                break;
            }
            case 60: {
                this.notImplemented("LS3R");
                this.parseState = groundTable;
                break;
            }
            case 61: {
                this.notImplemented("LS2R");
                this.parseState = groundTable;
                break;
            }
            case 62: {
                this.notImplemented("LS1R");
                this.parseState = groundTable;
                break;
            }
            case 64: {
                this.xtermSavemodes();
                this.parseState = groundTable;
                break;
            }
            case 65: {
                this.xtermRestoremodes();
                this.parseState = groundTable;
                break;
            }
            case 66: {
                this.notImplemented("XTERM_TITLE");
                break;
            }
            case 68: {
                this.notImplemented("HP_MEM_LOCK");
                this.parseState = groundTable;
                break;
            }
            case 69: {
                this.notImplemented("HP_MEM_UNLOCK");
                this.parseState = groundTable;
                break;
            }
            case 70: {
                this.notImplemented("HP_BUGGY_LL");
                this.parseState = groundTable;
                break;
            }
            case 73: {
                this.xtermModes();
                this.parseState = groundTable;
                break;
            }
            case 71: {
                this.xtermSeq = String.valueOf(this.xtermSeq) + c;
                break;
            }
            case 74: {
                this.term.sendBytes(this.terminalType().getBytes());
                break;
            }
            case 75: {
                this.xtermWinCtrl();
                this.parseState = groundTable;
            }
            case 79: {
                this.notImplemented("CHT");
                this.parseState = groundTable;
                break;
            }
            case 80: {
                this.notImplemented("SU");
                this.parseState = groundTable;
                break;
            }
            case 81: {
                this.notImplemented("ECH");
                this.parseState = groundTable;
                break;
            }
            case 82: {
                this.notImplemented("CBT");
                this.parseState = groundTable;
                break;
            }
            case 78: 
            case 83: {
                int n = this.param[0];
                if (n < 1) {
                    n = 1;
                }
                this.term.cursorSetPos(this.term.getCursorV(), n - 1, false);
                this.parseState = groundTable;
                break;
            }
            case 84: {
                this.notImplemented("REP");
                this.parseState = groundTable;
                break;
            }
            case 85: {
                int n = this.param[0];
                if (n < 1) {
                    n = 1;
                }
                this.term.cursorSetPos(n - 1, this.term.getCursorH(), false);
                this.parseState = groundTable;
                break;
            }
            default: {
                System.out.println("** Unknown state !!!");
            }
            case 3: 
        }
        return -1;
    }

    protected void ansiModes(boolean bl) {
        int n = 0;
        while (n < this.nparam) {
            switch (this.param[n]) {
                case 2: {
                    this.notImplemented("ANSI_AM");
                    break;
                }
                case 4: {
                    this.term.setOption(3, bl);
                    break;
                }
                case 12: {
                    this.notImplemented("ANSI_SRM");
                    break;
                }
                case 20: {
                    this.term.setOption(4, bl);
                    break;
                }
                default: {
                    this.notImplemented("ansi-mode: " + this.param[n] + "(" + bl + ")");
                }
            }
            ++n;
        }
    }

    protected void sgrModes() {
        int n = 0;
        while (n < this.nparam) {
            switch (this.param[n]) {
                case -1: 
                case 0: {
                    this.term.clearAllAttributes();
                    break;
                }
                case 1: 
                case 5: {
                    this.term.setAttribute(1, true);
                    break;
                }
                case 4: {
                    this.term.setAttribute(4, true);
                    break;
                }
                case 7: {
                    this.term.setAttribute(16, true);
                    break;
                }
                case 8: {
                    this.notImplemented("SGR invisible");
                    break;
                }
                case 22: {
                    this.term.setAttribute(1, false);
                    break;
                }
                case 24: {
                    this.term.setAttribute(4, false);
                    break;
                }
                case 25: {
                    this.term.setAttribute(1, false);
                    break;
                }
                case 27: {
                    this.term.setAttribute(16, false);
                    break;
                }
                case 28: {
                    this.notImplemented("SGR visible");
                    break;
                }
                case 10: {
                    this.gSets[this.scsType] = 66;
                    break;
                }
                case 11: 
                case 12: {
                    this.gSets[this.scsType] = 48;
                    break;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    this.term.setForegroundColor(this.param[n] - 30);
                    break;
                }
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: {
                    this.term.setForegroundColor(this.param[n] - 90);
                    break;
                }
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: {
                    this.term.setBackgroundColor(this.param[n] - 40);
                    break;
                }
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    this.term.setBackgroundColor(this.param[n] - 100);
                    break;
                }
                case 39: {
                    this.term.setForegroundColor(-1);
                    break;
                }
                case 49: {
                    this.term.setBackgroundColor(-1);
                    break;
                }
                default: {
                    this.notImplemented("SGR: " + this.param[n]);
                }
            }
            ++n;
        }
    }

    protected void dpModes(boolean bl) {
        int n = 0;
        while (n < this.nparam) {
            switch (this.param[n]) {
                case 1: {
                    this.cursorKeysMode = bl;
                    break;
                }
                case 2: {
                    if (!bl) break;
                    this.resetGSets();
                    break;
                }
                case 3: {
                    this.notImplemented("DECCOLM");
                    break;
                }
                case 4: {
                    this.notImplemented("DECSCLM");
                    break;
                }
                case 5: {
                    this.term.setOption(0, !bl);
                    break;
                }
                case 6: {
                    this.windowRelative = bl;
                    break;
                }
                case 7: {
                    this.term.setOption(1, bl);
                    break;
                }
                case 9: {
                    if (bl) {
                        this.sendMousePos = 1;
                        break;
                    }
                    this.sendMousePos = 0;
                    break;
                }
                case 18: {
                    this.notImplemented("DECPFF");
                    break;
                }
                case 19: {
                    this.notImplemented("DECPEF");
                    break;
                }
                case 25: {
                    this.term.setOption(9, bl);
                    break;
                }
                case 38: {
                    this.notImplemented("DECTEK");
                    break;
                }
                case 40: {
                    this.notImplemented("DEC132COLS");
                    break;
                }
                case 41: {
                    this.notImplemented("DECCUR-HACK");
                    break;
                }
                case 42: {
                    this.notImplemented("DECNRCM");
                    break;
                }
                case 44: {
                    this.notImplemented("DECMRGBEL");
                    break;
                }
                case 45: {
                    this.term.setOption(2, bl);
                    break;
                }
                case 46: {
                    this.notImplemented("DECLOG");
                    break;
                }
                case 47: {
                    this.toggleAlternateBuffer(bl);
                    break;
                }
                case 67: {
                    this.notImplemented("DECBKM");
                    break;
                }
                case 1000: {
                    if (bl) {
                        this.sendMousePos = 2;
                        break;
                    }
                    this.sendMousePos = 0;
                    break;
                }
                case 1001: {
                    this.notImplemented("MOUSE_HLTRACK");
                    if (bl) {
                        this.sendMousePos = 3;
                        break;
                    }
                    this.sendMousePos = 0;
                    break;
                }
                case 1002: {
                    this.notImplemented("Cell Motion Mouse Tracking");
                    break;
                }
                case 1003: {
                    this.notImplemented("All Motion Mouse Tracking");
                    break;
                }
                case 1047: {
                    this.notImplemented("Use Alternate Screen Buffer");
                    break;
                }
                case 1048: {
                    this.notImplemented("Save cursor as in DECSC");
                    break;
                }
                case 1049: {
                    this.notImplemented("Save cursor as in DECSC + Use Alternate Screen Buffer");
                    break;
                }
                default: {
                    this.notImplemented("DEC-private: " + this.param[n] + "(" + bl + ")");
                }
                case 8: 
            }
            ++n;
        }
    }

    protected void xtermModes() {
        switch (this.param[0]) {
            case 0: 
            case 1: 
            case 2: {
                if (!(this.term instanceof TerminalWin)) break;
                ((TerminalWin)this.term).setTitle(this.xtermSeq);
                return;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                this.notImplemented("XTERM-Change colors: " + this.xtermSeq);
                return;
            }
            case 20: {
                this.notImplemented("XITERM-Change bg-pixmap: " + this.xtermSeq);
                return;
            }
            case 39: {
                this.notImplemented("XITERM-Change fg-color: " + this.xtermSeq);
                return;
            }
            case 49: {
                this.notImplemented("XITERM-Change bg-color: " + this.xtermSeq);
                return;
            }
            case 46: {
                this.notImplemented("XTERM-new log-file: " + this.xtermSeq);
                return;
            }
            case 50: {
                this.notImplemented("XTERM-set font: " + this.xtermSeq);
                return;
            }
            default: {
                this.notImplemented("XTERM-unknown: " + this.xtermSeq);
            }
        }
    }

    protected void xtermWinCtrl() {
        int n = 0;
        while (n < this.nparam) {
            switch (this.param[n]) {
                case 1: {
                    this.notImplemented("XTERM-deiconify");
                    break;
                }
                case 2: {
                    this.notImplemented("XTERM-iconify");
                    break;
                }
                case 3: {
                    this.notImplemented("XTERM-move (x,y): " + this.param[++n] + ", " + this.param[++n]);
                    break;
                }
                case 4: {
                    this.notImplemented("XTERM-resize (h,w): " + this.param[++n] + ", " + this.param[++n]);
                    break;
                }
                case 5: {
                    this.notImplemented("XTERM-raise");
                    break;
                }
                case 6: {
                    this.notImplemented("XTERM-lower");
                    break;
                }
                case 7: {
                    this.notImplemented("XTERM-refresh");
                    break;
                }
                case 8: {
                    this.notImplemented("XTERM-resize-txt (h,w): " + this.param[++n] + ", " + this.param[++n]);
                    break;
                }
                case 11: {
                    this.notImplemented("XTERM-report state");
                    break;
                }
                case 13: {
                    this.notImplemented("XTERM-report pos.");
                    break;
                }
                case 14: {
                    this.notImplemented("XTERM-report size");
                    break;
                }
                case 18: {
                    this.notImplemented("XTERM-report size-txt");
                    break;
                }
                case 20: {
                    this.notImplemented("XTERM-report icon-label");
                    break;
                }
                case 21: {
                    this.notImplemented("XTERM-report title");
                    break;
                }
                default: {
                    this.notImplemented("XTERM-resize to lines: " + this.param[n]);
                    break;
                }
            }
            ++n;
        }
    }

    protected void xtermSavemodes() {
    }

    protected void xtermRestoremodes() {
    }

    protected void toggleAlternateBuffer(boolean bl) {
    }

    protected final void resetGSets() {
        int n = 0;
        while (n < 4) {
            this.gSets[n] = 66;
            ++n;
        }
        this.curGL = 0;
    }

    protected void vtReset() {
        this.resetGSets();
        this.curSS = 0;
        this.parseState = groundTable;
        this.windowRelative = false;
        this.keypadAppl = false;
        this.cursorKeysMode = false;
        this.sendMousePos = 0;
        if (this.term != null) {
            this.term.resetWindow();
            this.term.clearScreen();
            this.term.cursorSetPos(0, 0, false);
        }
    }

    protected void notImplemented(String string) {
        System.out.println("not implemented: " + string);
    }

    final int mapVKToXVK(int n) {
        int n2 = 0;
        while (n2 < 34) {
            if (this.vk2xvk[n2] == n) break;
            ++n2;
        }
        return n2;
    }

    public final String mapSpecialKeys(int n) {
        int n2 = this.mapVKToXVK(n);
        if (this.whoAmI >= 9) {
            return specialKeyMap[n2][this.whoAmI - 9];
        }
        return specialKeyMap[n2][this.whoAmI];
    }

    public void keyHandler(int n) {
        String string = null;
        String string2 = "";
        switch (n) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                string2 = this.cursorKeysMode ? replyTypes[2] : replyTypes[4];
                string = this.mapSpecialKeys(n);
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                if (this.term.getOption(7)) break;
                string2 = replyTypes[4];
                string = this.mapSpecialKeys(n);
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                string2 = this.whoAmI == 6 || this.whoAmI == 7 || this.whoAmI == 3 ? replyTypes[2] : (this.whoAmI == 5 ? (n > 115 ? replyTypes[4] : replyTypes[2]) : (this.whoAmI == 8 ? replyTypes[0] : replyTypes[4]));
                string = this.mapSpecialKeys(n);
                break;
            }
        }
        if (string != null) {
            string = String.valueOf(string2) + string;
            this.term.sendBytes(string.getBytes());
        }
    }

    int xButton(int n) {
        int n2 = 0;
        if ((n & 0x10) != 0) {
            n2 = 0;
        } else if ((n & 8) != 0) {
            n2 = 1;
        } else if ((n & 4) != 0) {
            n2 = 2;
        }
        return n2;
    }

    int xKeyState(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 8) != 0) {
            n2 |= 2;
        }
        if ((n & 2) != 0) {
            n2 |= 4;
        }
        return n2 << 2;
    }

    public void mouseHandler(int n, int n2, boolean bl, int n3) {
        switch (this.sendMousePos) {
            case 1: {
                if (!bl) break;
                this.term.sendBytes(("\u001b[M" + (char)(32 + this.xButton(n3)) + (char)(32 + n2 + 1) + (char)(32 + n + 1)).getBytes());
                return;
            }
            case 2: {
                this.term.sendBytes(("\u001b[M" + (char)(32 + (bl ? this.xButton(n3) | this.xKeyState(n3) : 3)) + (char)(32 + n2 + 1) + (char)(32 + n + 1)).getBytes());
                return;
            }
        }
    }

    static {
        int[] nArray = new int[256];
        nArray[0] = 63;
        nArray[1] = 63;
        nArray[2] = 63;
        nArray[3] = 63;
        nArray[4] = 63;
        nArray[5] = 74;
        nArray[6] = 63;
        nArray[7] = 4;
        nArray[8] = 5;
        nArray[9] = 9;
        nArray[10] = 8;
        nArray[11] = 8;
        nArray[12] = 8;
        nArray[13] = 6;
        nArray[14] = 11;
        nArray[15] = 10;
        nArray[16] = 63;
        nArray[17] = 63;
        nArray[18] = 63;
        nArray[19] = 63;
        nArray[20] = 63;
        nArray[21] = 63;
        nArray[22] = 63;
        nArray[23] = 63;
        nArray[24] = 63;
        nArray[25] = 63;
        nArray[26] = 63;
        nArray[27] = 7;
        nArray[28] = 63;
        nArray[29] = 63;
        nArray[30] = 63;
        nArray[31] = 63;
        nArray[32] = 63;
        nArray[33] = 63;
        nArray[34] = 63;
        nArray[35] = 63;
        nArray[36] = 63;
        nArray[37] = 63;
        nArray[38] = 63;
        nArray[39] = 63;
        nArray[40] = 63;
        nArray[41] = 63;
        nArray[42] = 63;
        nArray[43] = 63;
        nArray[44] = 63;
        nArray[45] = 63;
        nArray[46] = 63;
        nArray[47] = 63;
        nArray[48] = 63;
        nArray[49] = 63;
        nArray[50] = 63;
        nArray[51] = 63;
        nArray[52] = 63;
        nArray[53] = 63;
        nArray[54] = 63;
        nArray[55] = 63;
        nArray[56] = 63;
        nArray[57] = 63;
        nArray[58] = 63;
        nArray[59] = 63;
        nArray[60] = 63;
        nArray[61] = 63;
        nArray[62] = 63;
        nArray[63] = 63;
        nArray[64] = 63;
        nArray[65] = 63;
        nArray[66] = 63;
        nArray[67] = 63;
        nArray[68] = 63;
        nArray[69] = 63;
        nArray[70] = 63;
        nArray[71] = 63;
        nArray[72] = 63;
        nArray[73] = 63;
        nArray[74] = 63;
        nArray[75] = 63;
        nArray[76] = 63;
        nArray[77] = 63;
        nArray[78] = 63;
        nArray[79] = 63;
        nArray[80] = 63;
        nArray[81] = 63;
        nArray[82] = 63;
        nArray[83] = 63;
        nArray[84] = 63;
        nArray[85] = 63;
        nArray[86] = 63;
        nArray[87] = 63;
        nArray[88] = 63;
        nArray[89] = 63;
        nArray[90] = 63;
        nArray[91] = 63;
        nArray[92] = 63;
        nArray[93] = 63;
        nArray[94] = 63;
        nArray[95] = 63;
        nArray[96] = 63;
        nArray[97] = 63;
        nArray[98] = 63;
        nArray[99] = 63;
        nArray[100] = 63;
        nArray[101] = 63;
        nArray[102] = 63;
        nArray[103] = 63;
        nArray[104] = 63;
        nArray[105] = 63;
        nArray[106] = 63;
        nArray[107] = 63;
        nArray[108] = 63;
        nArray[109] = 63;
        nArray[110] = 63;
        nArray[111] = 63;
        nArray[112] = 63;
        nArray[113] = 63;
        nArray[114] = 63;
        nArray[115] = 63;
        nArray[116] = 63;
        nArray[117] = 63;
        nArray[118] = 63;
        nArray[119] = 63;
        nArray[120] = 63;
        nArray[121] = 63;
        nArray[122] = 63;
        nArray[123] = 63;
        nArray[124] = 63;
        nArray[125] = 63;
        nArray[126] = 63;
        nArray[128] = 63;
        nArray[129] = 63;
        nArray[130] = 63;
        nArray[131] = 63;
        nArray[132] = 63;
        nArray[133] = 63;
        nArray[134] = 63;
        nArray[135] = 63;
        nArray[136] = 63;
        nArray[137] = 63;
        nArray[138] = 63;
        nArray[139] = 63;
        nArray[140] = 63;
        nArray[141] = 63;
        nArray[142] = 63;
        nArray[143] = 63;
        nArray[144] = 63;
        nArray[145] = 63;
        nArray[146] = 63;
        nArray[147] = 63;
        nArray[148] = 63;
        nArray[149] = 63;
        nArray[150] = 63;
        nArray[151] = 63;
        nArray[152] = 63;
        nArray[153] = 63;
        nArray[154] = 63;
        nArray[155] = 63;
        nArray[156] = 63;
        nArray[157] = 63;
        nArray[158] = 63;
        nArray[159] = 63;
        nArray[160] = 63;
        nArray[161] = 63;
        nArray[162] = 63;
        nArray[163] = 63;
        nArray[164] = 63;
        nArray[165] = 63;
        nArray[166] = 63;
        nArray[167] = 63;
        nArray[168] = 63;
        nArray[169] = 63;
        nArray[170] = 63;
        nArray[171] = 63;
        nArray[172] = 63;
        nArray[173] = 63;
        nArray[174] = 63;
        nArray[175] = 63;
        nArray[176] = 63;
        nArray[177] = 63;
        nArray[178] = 63;
        nArray[179] = 63;
        nArray[180] = 63;
        nArray[181] = 63;
        nArray[182] = 63;
        nArray[183] = 63;
        nArray[184] = 63;
        nArray[185] = 63;
        nArray[186] = 63;
        nArray[187] = 63;
        nArray[188] = 63;
        nArray[189] = 63;
        nArray[190] = 63;
        nArray[191] = 63;
        nArray[192] = 63;
        nArray[193] = 63;
        nArray[194] = 63;
        nArray[195] = 63;
        nArray[196] = 63;
        nArray[197] = 63;
        nArray[198] = 63;
        nArray[199] = 63;
        nArray[200] = 63;
        nArray[201] = 63;
        nArray[202] = 63;
        nArray[203] = 63;
        nArray[204] = 63;
        nArray[205] = 63;
        nArray[206] = 63;
        nArray[207] = 63;
        nArray[208] = 63;
        nArray[209] = 63;
        nArray[210] = 63;
        nArray[211] = 63;
        nArray[212] = 63;
        nArray[213] = 63;
        nArray[214] = 63;
        nArray[215] = 63;
        nArray[216] = 63;
        nArray[217] = 63;
        nArray[218] = 63;
        nArray[219] = 63;
        nArray[220] = 63;
        nArray[221] = 63;
        nArray[222] = 63;
        nArray[223] = 63;
        nArray[224] = 63;
        nArray[225] = 63;
        nArray[226] = 63;
        nArray[227] = 63;
        nArray[228] = 63;
        nArray[229] = 63;
        nArray[230] = 63;
        nArray[231] = 63;
        nArray[232] = 63;
        nArray[233] = 63;
        nArray[234] = 63;
        nArray[235] = 63;
        nArray[236] = 63;
        nArray[237] = 63;
        nArray[238] = 63;
        nArray[239] = 63;
        nArray[240] = 63;
        nArray[241] = 63;
        nArray[242] = 63;
        nArray[243] = 63;
        nArray[244] = 63;
        nArray[245] = 63;
        nArray[246] = 63;
        nArray[247] = 63;
        nArray[248] = 63;
        nArray[249] = 63;
        nArray[250] = 63;
        nArray[251] = 63;
        nArray[252] = 63;
        nArray[253] = 63;
        nArray[254] = 63;
        nArray[255] = 63;
        groundTable = nArray;
        int[] nArray2 = new int[256];
        nArray2[0] = 3;
        nArray2[1] = 3;
        nArray2[2] = 3;
        nArray2[3] = 3;
        nArray2[4] = 3;
        nArray2[5] = 3;
        nArray2[6] = 3;
        nArray2[7] = 4;
        nArray2[8] = 5;
        nArray2[9] = 9;
        nArray2[10] = 8;
        nArray2[11] = 8;
        nArray2[12] = 8;
        nArray2[13] = 6;
        nArray2[14] = 11;
        nArray2[15] = 10;
        nArray2[16] = 3;
        nArray2[17] = 3;
        nArray2[18] = 3;
        nArray2[19] = 3;
        nArray2[20] = 3;
        nArray2[21] = 3;
        nArray2[22] = 3;
        nArray2[23] = 3;
        nArray2[24] = 3;
        nArray2[25] = 3;
        nArray2[26] = 3;
        nArray2[27] = 7;
        nArray2[28] = 3;
        nArray2[29] = 3;
        nArray2[30] = 3;
        nArray2[31] = 3;
        nArray2[32] = 17;
        nArray2[33] = 17;
        nArray2[34] = 17;
        nArray2[35] = 17;
        nArray2[36] = 17;
        nArray2[37] = 17;
        nArray2[38] = 17;
        nArray2[39] = 17;
        nArray2[40] = 17;
        nArray2[41] = 17;
        nArray2[42] = 17;
        nArray2[43] = 17;
        nArray2[44] = 17;
        nArray2[45] = 17;
        nArray2[46] = 17;
        nArray2[47] = 17;
        nArray2[48] = 18;
        nArray2[49] = 18;
        nArray2[50] = 18;
        nArray2[51] = 18;
        nArray2[52] = 18;
        nArray2[53] = 18;
        nArray2[54] = 18;
        nArray2[55] = 18;
        nArray2[56] = 18;
        nArray2[57] = 18;
        nArray2[58] = 3;
        nArray2[59] = 19;
        nArray2[60] = 3;
        nArray2[61] = 3;
        nArray2[62] = 3;
        nArray2[63] = 20;
        nArray2[64] = 21;
        nArray2[65] = 22;
        nArray2[66] = 23;
        nArray2[67] = 24;
        nArray2[68] = 25;
        nArray2[69] = 76;
        nArray2[70] = 77;
        nArray2[71] = 78;
        nArray2[72] = 26;
        nArray2[73] = 79;
        nArray2[74] = 27;
        nArray2[75] = 28;
        nArray2[76] = 29;
        nArray2[77] = 30;
        nArray2[80] = 31;
        nArray2[83] = 80;
        nArray2[84] = 33;
        nArray2[88] = 81;
        nArray2[90] = 82;
        nArray2[96] = 83;
        nArray2[98] = 84;
        nArray2[99] = 32;
        nArray2[100] = 85;
        nArray2[102] = 26;
        nArray2[103] = 34;
        nArray2[104] = 35;
        nArray2[108] = 36;
        nArray2[109] = 37;
        nArray2[110] = 38;
        nArray2[114] = 39;
        nArray2[115] = 45;
        nArray2[116] = 75;
        nArray2[117] = 46;
        nArray2[120] = 40;
        nArray2[128] = 3;
        nArray2[129] = 3;
        nArray2[130] = 3;
        nArray2[131] = 3;
        nArray2[132] = 3;
        nArray2[133] = 3;
        nArray2[134] = 3;
        nArray2[135] = 3;
        nArray2[136] = 3;
        nArray2[137] = 3;
        nArray2[138] = 3;
        nArray2[139] = 3;
        nArray2[140] = 3;
        nArray2[141] = 3;
        nArray2[142] = 3;
        nArray2[143] = 3;
        nArray2[144] = 3;
        nArray2[145] = 3;
        nArray2[146] = 3;
        nArray2[147] = 3;
        nArray2[148] = 3;
        nArray2[149] = 3;
        nArray2[150] = 3;
        nArray2[151] = 3;
        nArray2[152] = 3;
        nArray2[153] = 3;
        nArray2[154] = 3;
        nArray2[155] = 3;
        nArray2[156] = 3;
        nArray2[157] = 3;
        nArray2[158] = 3;
        nArray2[159] = 3;
        csiTable = nArray2;
        int[] nArray3 = new int[256];
        nArray3[0] = 3;
        nArray3[1] = 3;
        nArray3[2] = 3;
        nArray3[3] = 3;
        nArray3[4] = 3;
        nArray3[5] = 3;
        nArray3[6] = 3;
        nArray3[7] = 4;
        nArray3[8] = 5;
        nArray3[9] = 9;
        nArray3[10] = 8;
        nArray3[11] = 8;
        nArray3[12] = 8;
        nArray3[13] = 6;
        nArray3[14] = 11;
        nArray3[15] = 10;
        nArray3[16] = 3;
        nArray3[17] = 3;
        nArray3[18] = 3;
        nArray3[19] = 3;
        nArray3[20] = 3;
        nArray3[21] = 3;
        nArray3[22] = 3;
        nArray3[23] = 3;
        nArray3[24] = 3;
        nArray3[25] = 3;
        nArray3[26] = 3;
        nArray3[27] = 7;
        nArray3[28] = 3;
        nArray3[29] = 3;
        nArray3[30] = 3;
        nArray3[31] = 3;
        nArray3[32] = 17;
        nArray3[33] = 17;
        nArray3[34] = 17;
        nArray3[35] = 17;
        nArray3[36] = 17;
        nArray3[37] = 17;
        nArray3[38] = 17;
        nArray3[39] = 17;
        nArray3[40] = 17;
        nArray3[41] = 17;
        nArray3[42] = 17;
        nArray3[43] = 17;
        nArray3[44] = 17;
        nArray3[45] = 17;
        nArray3[46] = 17;
        nArray3[47] = 17;
        nArray3[48] = 18;
        nArray3[49] = 18;
        nArray3[50] = 18;
        nArray3[51] = 18;
        nArray3[52] = 18;
        nArray3[53] = 18;
        nArray3[54] = 18;
        nArray3[55] = 18;
        nArray3[56] = 18;
        nArray3[57] = 18;
        nArray3[58] = 3;
        nArray3[59] = 19;
        nArray3[104] = 41;
        nArray3[108] = 42;
        nArray3[114] = 65;
        nArray3[115] = 64;
        nArray3[128] = 3;
        nArray3[129] = 3;
        nArray3[130] = 3;
        nArray3[131] = 3;
        nArray3[132] = 3;
        nArray3[133] = 3;
        nArray3[134] = 3;
        nArray3[135] = 3;
        nArray3[136] = 3;
        nArray3[137] = 3;
        nArray3[138] = 3;
        nArray3[139] = 3;
        nArray3[140] = 3;
        nArray3[141] = 3;
        nArray3[142] = 3;
        nArray3[143] = 3;
        nArray3[144] = 3;
        nArray3[145] = 3;
        nArray3[146] = 3;
        nArray3[147] = 3;
        nArray3[148] = 3;
        nArray3[149] = 3;
        nArray3[150] = 3;
        nArray3[151] = 3;
        nArray3[152] = 3;
        nArray3[153] = 3;
        nArray3[154] = 3;
        nArray3[155] = 3;
        nArray3[156] = 3;
        nArray3[157] = 3;
        nArray3[158] = 3;
        nArray3[159] = 3;
        decTable = nArray3;
        int[] nArray4 = new int[256];
        nArray4[0] = 3;
        nArray4[1] = 3;
        nArray4[2] = 3;
        nArray4[3] = 3;
        nArray4[4] = 3;
        nArray4[5] = 3;
        nArray4[6] = 3;
        nArray4[7] = 3;
        nArray4[8] = 5;
        nArray4[9] = 9;
        nArray4[10] = 8;
        nArray4[11] = 8;
        nArray4[12] = 8;
        nArray4[13] = 6;
        nArray4[14] = 11;
        nArray4[15] = 10;
        nArray4[16] = 3;
        nArray4[17] = 3;
        nArray4[18] = 3;
        nArray4[19] = 3;
        nArray4[20] = 3;
        nArray4[21] = 3;
        nArray4[22] = 3;
        nArray4[23] = 3;
        nArray4[24] = 3;
        nArray4[25] = 3;
        nArray4[26] = 3;
        nArray4[27] = 7;
        nArray4[28] = 3;
        nArray4[29] = 3;
        nArray4[30] = 3;
        nArray4[31] = 3;
        nArray4[32] = 17;
        nArray4[33] = 17;
        nArray4[34] = 17;
        nArray4[35] = 17;
        nArray4[36] = 17;
        nArray4[37] = 17;
        nArray4[38] = 17;
        nArray4[39] = 17;
        nArray4[40] = 17;
        nArray4[41] = 17;
        nArray4[42] = 17;
        nArray4[43] = 17;
        nArray4[44] = 17;
        nArray4[45] = 17;
        nArray4[46] = 17;
        nArray4[47] = 17;
        nArray4[48] = 18;
        nArray4[49] = 18;
        nArray4[50] = 18;
        nArray4[51] = 18;
        nArray4[52] = 18;
        nArray4[53] = 18;
        nArray4[54] = 18;
        nArray4[55] = 18;
        nArray4[56] = 18;
        nArray4[57] = 18;
        nArray4[58] = 3;
        nArray4[59] = 72;
        nArray4[104] = 41;
        nArray4[108] = 42;
        nArray4[114] = 65;
        nArray4[115] = 64;
        nArray4[128] = 3;
        nArray4[129] = 3;
        nArray4[130] = 3;
        nArray4[131] = 3;
        nArray4[132] = 3;
        nArray4[133] = 3;
        nArray4[134] = 3;
        nArray4[135] = 3;
        nArray4[136] = 3;
        nArray4[137] = 3;
        nArray4[138] = 3;
        nArray4[139] = 3;
        nArray4[140] = 3;
        nArray4[141] = 3;
        nArray4[142] = 3;
        nArray4[143] = 3;
        nArray4[144] = 3;
        nArray4[145] = 3;
        nArray4[146] = 3;
        nArray4[147] = 3;
        nArray4[148] = 3;
        nArray4[149] = 3;
        nArray4[150] = 3;
        nArray4[151] = 3;
        nArray4[152] = 3;
        nArray4[153] = 3;
        nArray4[154] = 3;
        nArray4[155] = 3;
        nArray4[156] = 3;
        nArray4[157] = 3;
        nArray4[158] = 3;
        nArray4[159] = 3;
        oscTable = nArray4;
        xtermSeqTable = new int[]{71, 71, 71, 71, 71, 71, 71, 73, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71};
        int[] nArray5 = new int[256];
        nArray5[0] = 3;
        nArray5[1] = 3;
        nArray5[2] = 3;
        nArray5[3] = 3;
        nArray5[4] = 3;
        nArray5[5] = 3;
        nArray5[6] = 3;
        nArray5[7] = 4;
        nArray5[8] = 5;
        nArray5[9] = 9;
        nArray5[10] = 8;
        nArray5[11] = 8;
        nArray5[12] = 8;
        nArray5[13] = 6;
        nArray5[14] = 11;
        nArray5[15] = 10;
        nArray5[16] = 3;
        nArray5[17] = 3;
        nArray5[18] = 3;
        nArray5[19] = 3;
        nArray5[20] = 3;
        nArray5[21] = 3;
        nArray5[22] = 3;
        nArray5[23] = 3;
        nArray5[24] = 3;
        nArray5[25] = 3;
        nArray5[26] = 3;
        nArray5[27] = 7;
        nArray5[28] = 3;
        nArray5[29] = 3;
        nArray5[30] = 3;
        nArray5[31] = 3;
        nArray5[32] = 3;
        nArray5[33] = 3;
        nArray5[34] = 3;
        nArray5[35] = 3;
        nArray5[36] = 3;
        nArray5[37] = 3;
        nArray5[38] = 3;
        nArray5[39] = 3;
        nArray5[40] = 3;
        nArray5[41] = 3;
        nArray5[42] = 3;
        nArray5[43] = 3;
        nArray5[44] = 3;
        nArray5[45] = 3;
        nArray5[46] = 3;
        nArray5[47] = 3;
        nArray5[128] = 3;
        nArray5[129] = 3;
        nArray5[130] = 3;
        nArray5[131] = 3;
        nArray5[132] = 3;
        nArray5[133] = 3;
        nArray5[134] = 3;
        nArray5[135] = 3;
        nArray5[136] = 3;
        nArray5[137] = 3;
        nArray5[138] = 3;
        nArray5[139] = 3;
        nArray5[140] = 3;
        nArray5[141] = 3;
        nArray5[142] = 3;
        nArray5[143] = 3;
        nArray5[144] = 3;
        nArray5[145] = 3;
        nArray5[146] = 3;
        nArray5[147] = 3;
        nArray5[148] = 3;
        nArray5[149] = 3;
        nArray5[150] = 3;
        nArray5[151] = 3;
        nArray5[152] = 3;
        nArray5[153] = 3;
        nArray5[154] = 3;
        nArray5[155] = 3;
        nArray5[156] = 3;
        nArray5[157] = 3;
        nArray5[158] = 3;
        nArray5[159] = 3;
        eigTable = nArray5;
        int[] nArray6 = new int[256];
        nArray6[0] = 3;
        nArray6[1] = 3;
        nArray6[2] = 3;
        nArray6[3] = 3;
        nArray6[4] = 3;
        nArray6[5] = 3;
        nArray6[6] = 3;
        nArray6[7] = 4;
        nArray6[8] = 5;
        nArray6[9] = 9;
        nArray6[10] = 8;
        nArray6[11] = 8;
        nArray6[12] = 8;
        nArray6[13] = 6;
        nArray6[14] = 11;
        nArray6[15] = 10;
        nArray6[16] = 3;
        nArray6[17] = 3;
        nArray6[18] = 3;
        nArray6[19] = 3;
        nArray6[20] = 3;
        nArray6[21] = 3;
        nArray6[22] = 3;
        nArray6[23] = 3;
        nArray6[24] = 3;
        nArray6[25] = 3;
        nArray6[26] = 3;
        nArray6[27] = 7;
        nArray6[28] = 3;
        nArray6[29] = 3;
        nArray6[30] = 3;
        nArray6[31] = 3;
        nArray6[32] = 17;
        nArray6[33] = 17;
        nArray6[34] = 17;
        nArray6[35] = 12;
        nArray6[36] = 17;
        nArray6[37] = 17;
        nArray6[38] = 17;
        nArray6[39] = 17;
        nArray6[40] = 13;
        nArray6[41] = 14;
        nArray6[42] = 15;
        nArray6[43] = 16;
        nArray6[44] = 17;
        nArray6[45] = 17;
        nArray6[46] = 17;
        nArray6[47] = 17;
        nArray6[55] = 45;
        nArray6[56] = 46;
        nArray6[61] = 47;
        nArray6[62] = 48;
        nArray6[68] = 49;
        nArray6[69] = 50;
        nArray6[70] = 70;
        nArray6[72] = 51;
        nArray6[77] = 52;
        nArray6[78] = 53;
        nArray6[79] = 54;
        nArray6[80] = 1;
        nArray6[84] = 66;
        nArray6[90] = 67;
        nArray6[91] = 55;
        nArray6[93] = 56;
        nArray6[94] = 1;
        nArray6[95] = 1;
        nArray6[99] = 57;
        nArray6[108] = 68;
        nArray6[109] = 69;
        nArray6[110] = 58;
        nArray6[111] = 59;
        nArray6[124] = 60;
        nArray6[125] = 61;
        nArray6[126] = 62;
        nArray6[128] = 3;
        nArray6[129] = 3;
        nArray6[130] = 3;
        nArray6[131] = 3;
        nArray6[132] = 3;
        nArray6[133] = 3;
        nArray6[134] = 3;
        nArray6[135] = 3;
        nArray6[136] = 3;
        nArray6[137] = 3;
        nArray6[138] = 3;
        nArray6[139] = 3;
        nArray6[140] = 3;
        nArray6[141] = 3;
        nArray6[142] = 3;
        nArray6[143] = 3;
        nArray6[144] = 3;
        nArray6[145] = 3;
        nArray6[146] = 3;
        nArray6[147] = 3;
        nArray6[148] = 3;
        nArray6[149] = 3;
        nArray6[150] = 3;
        nArray6[151] = 3;
        nArray6[152] = 3;
        nArray6[153] = 3;
        nArray6[154] = 3;
        nArray6[155] = 3;
        nArray6[156] = 3;
        nArray6[157] = 3;
        nArray6[158] = 3;
        nArray6[159] = 3;
        escTable = nArray6;
        int[] nArray7 = new int[256];
        nArray7[0] = 1;
        nArray7[1] = 1;
        nArray7[2] = 1;
        nArray7[3] = 1;
        nArray7[4] = 1;
        nArray7[5] = 1;
        nArray7[6] = 1;
        nArray7[7] = 1;
        nArray7[8] = 1;
        nArray7[9] = 1;
        nArray7[10] = 1;
        nArray7[11] = 1;
        nArray7[12] = 1;
        nArray7[13] = 1;
        nArray7[14] = 1;
        nArray7[15] = 1;
        nArray7[16] = 1;
        nArray7[17] = 1;
        nArray7[18] = 1;
        nArray7[19] = 1;
        nArray7[20] = 1;
        nArray7[21] = 1;
        nArray7[22] = 1;
        nArray7[23] = 1;
        nArray7[24] = 1;
        nArray7[25] = 1;
        nArray7[26] = 1;
        nArray7[27] = 1;
        nArray7[28] = 1;
        nArray7[29] = 1;
        nArray7[30] = 1;
        nArray7[31] = 1;
        nArray7[32] = 1;
        nArray7[33] = 1;
        nArray7[34] = 1;
        nArray7[35] = 1;
        nArray7[36] = 1;
        nArray7[37] = 1;
        nArray7[38] = 1;
        nArray7[39] = 1;
        nArray7[40] = 1;
        nArray7[41] = 1;
        nArray7[42] = 1;
        nArray7[43] = 1;
        nArray7[44] = 1;
        nArray7[45] = 1;
        nArray7[46] = 1;
        nArray7[47] = 1;
        nArray7[48] = 1;
        nArray7[49] = 1;
        nArray7[50] = 1;
        nArray7[51] = 1;
        nArray7[52] = 1;
        nArray7[53] = 1;
        nArray7[54] = 1;
        nArray7[55] = 1;
        nArray7[56] = 1;
        nArray7[57] = 1;
        nArray7[58] = 1;
        nArray7[59] = 1;
        nArray7[60] = 1;
        nArray7[61] = 1;
        nArray7[62] = 1;
        nArray7[63] = 1;
        nArray7[64] = 1;
        nArray7[65] = 1;
        nArray7[66] = 1;
        nArray7[67] = 1;
        nArray7[68] = 1;
        nArray7[69] = 1;
        nArray7[70] = 1;
        nArray7[71] = 1;
        nArray7[72] = 1;
        nArray7[73] = 1;
        nArray7[74] = 1;
        nArray7[75] = 1;
        nArray7[76] = 1;
        nArray7[77] = 1;
        nArray7[78] = 1;
        nArray7[79] = 1;
        nArray7[80] = 1;
        nArray7[81] = 1;
        nArray7[82] = 1;
        nArray7[83] = 1;
        nArray7[84] = 1;
        nArray7[85] = 1;
        nArray7[86] = 1;
        nArray7[87] = 1;
        nArray7[88] = 1;
        nArray7[89] = 1;
        nArray7[90] = 1;
        nArray7[91] = 1;
        nArray7[93] = 1;
        nArray7[94] = 1;
        nArray7[95] = 1;
        nArray7[96] = 1;
        nArray7[97] = 1;
        nArray7[98] = 1;
        nArray7[99] = 1;
        nArray7[100] = 1;
        nArray7[101] = 1;
        nArray7[102] = 1;
        nArray7[103] = 1;
        nArray7[104] = 1;
        nArray7[105] = 1;
        nArray7[106] = 1;
        nArray7[107] = 1;
        nArray7[108] = 1;
        nArray7[109] = 1;
        nArray7[110] = 1;
        nArray7[111] = 1;
        nArray7[112] = 1;
        nArray7[113] = 1;
        nArray7[114] = 1;
        nArray7[115] = 1;
        nArray7[116] = 1;
        nArray7[117] = 1;
        nArray7[118] = 1;
        nArray7[119] = 1;
        nArray7[120] = 1;
        nArray7[121] = 1;
        nArray7[122] = 1;
        nArray7[123] = 1;
        nArray7[124] = 1;
        nArray7[125] = 1;
        nArray7[126] = 1;
        nArray7[127] = 1;
        nArray7[128] = 3;
        nArray7[129] = 3;
        nArray7[130] = 3;
        nArray7[131] = 3;
        nArray7[132] = 3;
        nArray7[133] = 3;
        nArray7[134] = 3;
        nArray7[135] = 3;
        nArray7[136] = 3;
        nArray7[137] = 3;
        nArray7[138] = 3;
        nArray7[139] = 3;
        nArray7[140] = 3;
        nArray7[141] = 3;
        nArray7[142] = 3;
        nArray7[143] = 3;
        nArray7[144] = 3;
        nArray7[145] = 3;
        nArray7[146] = 3;
        nArray7[147] = 3;
        nArray7[148] = 3;
        nArray7[149] = 3;
        nArray7[150] = 3;
        nArray7[151] = 3;
        nArray7[152] = 3;
        nArray7[153] = 3;
        nArray7[154] = 3;
        nArray7[155] = 3;
        nArray7[156] = 3;
        nArray7[157] = 3;
        nArray7[158] = 3;
        nArray7[159] = 3;
        iesTable = nArray7;
        int[] nArray8 = new int[256];
        nArray8[0] = 3;
        nArray8[1] = 3;
        nArray8[2] = 3;
        nArray8[3] = 3;
        nArray8[4] = 3;
        nArray8[5] = 3;
        nArray8[6] = 3;
        nArray8[7] = 3;
        nArray8[8] = 3;
        nArray8[9] = 3;
        nArray8[10] = 3;
        nArray8[11] = 3;
        nArray8[12] = 3;
        nArray8[13] = 3;
        nArray8[14] = 3;
        nArray8[15] = 3;
        nArray8[16] = 3;
        nArray8[17] = 3;
        nArray8[18] = 3;
        nArray8[19] = 3;
        nArray8[20] = 3;
        nArray8[21] = 3;
        nArray8[22] = 3;
        nArray8[23] = 3;
        nArray8[25] = 3;
        nArray8[27] = 2;
        nArray8[28] = 3;
        nArray8[29] = 3;
        nArray8[30] = 3;
        nArray8[31] = 3;
        nArray8[32] = 3;
        nArray8[33] = 3;
        nArray8[34] = 3;
        nArray8[35] = 3;
        nArray8[36] = 3;
        nArray8[37] = 3;
        nArray8[38] = 3;
        nArray8[39] = 3;
        nArray8[40] = 3;
        nArray8[41] = 3;
        nArray8[42] = 3;
        nArray8[43] = 3;
        nArray8[44] = 3;
        nArray8[45] = 3;
        nArray8[46] = 3;
        nArray8[47] = 3;
        nArray8[48] = 3;
        nArray8[49] = 3;
        nArray8[50] = 3;
        nArray8[51] = 3;
        nArray8[52] = 3;
        nArray8[53] = 3;
        nArray8[54] = 3;
        nArray8[55] = 3;
        nArray8[56] = 3;
        nArray8[57] = 3;
        nArray8[58] = 3;
        nArray8[59] = 3;
        nArray8[60] = 3;
        nArray8[61] = 3;
        nArray8[62] = 3;
        nArray8[63] = 3;
        nArray8[64] = 3;
        nArray8[65] = 3;
        nArray8[66] = 3;
        nArray8[67] = 3;
        nArray8[68] = 3;
        nArray8[69] = 3;
        nArray8[70] = 3;
        nArray8[71] = 3;
        nArray8[72] = 3;
        nArray8[73] = 3;
        nArray8[74] = 3;
        nArray8[75] = 3;
        nArray8[76] = 3;
        nArray8[77] = 3;
        nArray8[78] = 3;
        nArray8[79] = 3;
        nArray8[80] = 3;
        nArray8[81] = 3;
        nArray8[82] = 3;
        nArray8[83] = 3;
        nArray8[84] = 3;
        nArray8[85] = 3;
        nArray8[86] = 3;
        nArray8[87] = 3;
        nArray8[88] = 3;
        nArray8[89] = 3;
        nArray8[90] = 3;
        nArray8[91] = 3;
        nArray8[92] = 3;
        nArray8[93] = 3;
        nArray8[94] = 3;
        nArray8[95] = 3;
        nArray8[96] = 3;
        nArray8[97] = 3;
        nArray8[98] = 3;
        nArray8[99] = 3;
        nArray8[100] = 3;
        nArray8[101] = 3;
        nArray8[102] = 3;
        nArray8[103] = 3;
        nArray8[104] = 3;
        nArray8[105] = 3;
        nArray8[106] = 3;
        nArray8[107] = 3;
        nArray8[108] = 3;
        nArray8[109] = 3;
        nArray8[110] = 3;
        nArray8[111] = 3;
        nArray8[112] = 3;
        nArray8[113] = 3;
        nArray8[114] = 3;
        nArray8[115] = 3;
        nArray8[116] = 3;
        nArray8[117] = 3;
        nArray8[118] = 3;
        nArray8[119] = 3;
        nArray8[120] = 3;
        nArray8[121] = 3;
        nArray8[122] = 3;
        nArray8[123] = 3;
        nArray8[124] = 3;
        nArray8[125] = 3;
        nArray8[126] = 3;
        nArray8[127] = 3;
        nArray8[128] = 3;
        nArray8[129] = 3;
        nArray8[130] = 3;
        nArray8[131] = 3;
        nArray8[132] = 3;
        nArray8[133] = 3;
        nArray8[134] = 3;
        nArray8[135] = 3;
        nArray8[136] = 3;
        nArray8[137] = 3;
        nArray8[138] = 3;
        nArray8[139] = 3;
        nArray8[140] = 3;
        nArray8[141] = 3;
        nArray8[142] = 3;
        nArray8[143] = 3;
        nArray8[144] = 3;
        nArray8[145] = 3;
        nArray8[146] = 3;
        nArray8[147] = 3;
        nArray8[148] = 3;
        nArray8[149] = 3;
        nArray8[150] = 3;
        nArray8[151] = 3;
        nArray8[152] = 3;
        nArray8[153] = 3;
        nArray8[154] = 3;
        nArray8[155] = 3;
        nArray8[156] = 3;
        nArray8[157] = 3;
        nArray8[158] = 3;
        nArray8[159] = 3;
        ignTable = nArray8;
        int[] nArray9 = new int[256];
        nArray9[0] = 3;
        nArray9[1] = 3;
        nArray9[2] = 3;
        nArray9[3] = 3;
        nArray9[4] = 3;
        nArray9[5] = 3;
        nArray9[6] = 3;
        nArray9[7] = 4;
        nArray9[8] = 5;
        nArray9[9] = 9;
        nArray9[10] = 8;
        nArray9[11] = 8;
        nArray9[12] = 8;
        nArray9[13] = 6;
        nArray9[14] = 11;
        nArray9[15] = 10;
        nArray9[16] = 3;
        nArray9[17] = 3;
        nArray9[18] = 3;
        nArray9[19] = 3;
        nArray9[20] = 3;
        nArray9[21] = 3;
        nArray9[22] = 3;
        nArray9[23] = 3;
        nArray9[24] = 3;
        nArray9[25] = 3;
        nArray9[26] = 3;
        nArray9[27] = 7;
        nArray9[28] = 3;
        nArray9[29] = 3;
        nArray9[30] = 3;
        nArray9[31] = 3;
        nArray9[32] = 17;
        nArray9[33] = 17;
        nArray9[34] = 17;
        nArray9[35] = 17;
        nArray9[36] = 17;
        nArray9[37] = 17;
        nArray9[38] = 17;
        nArray9[39] = 17;
        nArray9[40] = 17;
        nArray9[41] = 17;
        nArray9[42] = 17;
        nArray9[43] = 17;
        nArray9[44] = 17;
        nArray9[45] = 17;
        nArray9[46] = 17;
        nArray9[47] = 17;
        nArray9[56] = 43;
        nArray9[128] = 3;
        nArray9[129] = 3;
        nArray9[130] = 3;
        nArray9[131] = 3;
        nArray9[132] = 3;
        nArray9[133] = 3;
        nArray9[134] = 3;
        nArray9[135] = 3;
        nArray9[136] = 3;
        nArray9[137] = 3;
        nArray9[138] = 3;
        nArray9[139] = 3;
        nArray9[140] = 3;
        nArray9[141] = 3;
        nArray9[142] = 3;
        nArray9[143] = 3;
        nArray9[144] = 3;
        nArray9[145] = 3;
        nArray9[146] = 3;
        nArray9[147] = 3;
        nArray9[148] = 3;
        nArray9[149] = 3;
        nArray9[150] = 3;
        nArray9[151] = 3;
        nArray9[152] = 3;
        nArray9[153] = 3;
        nArray9[154] = 3;
        nArray9[155] = 3;
        nArray9[156] = 3;
        nArray9[157] = 3;
        nArray9[158] = 3;
        nArray9[159] = 3;
        scrTable = nArray9;
        int[] nArray10 = new int[256];
        nArray10[0] = 3;
        nArray10[1] = 3;
        nArray10[2] = 3;
        nArray10[3] = 3;
        nArray10[4] = 3;
        nArray10[5] = 3;
        nArray10[6] = 3;
        nArray10[7] = 4;
        nArray10[8] = 5;
        nArray10[9] = 9;
        nArray10[10] = 8;
        nArray10[11] = 8;
        nArray10[12] = 8;
        nArray10[13] = 6;
        nArray10[14] = 11;
        nArray10[15] = 10;
        nArray10[16] = 3;
        nArray10[17] = 3;
        nArray10[18] = 3;
        nArray10[19] = 3;
        nArray10[20] = 3;
        nArray10[21] = 3;
        nArray10[22] = 3;
        nArray10[23] = 3;
        nArray10[24] = 3;
        nArray10[25] = 3;
        nArray10[26] = 3;
        nArray10[27] = 7;
        nArray10[28] = 3;
        nArray10[29] = 3;
        nArray10[30] = 3;
        nArray10[31] = 3;
        nArray10[32] = 17;
        nArray10[33] = 17;
        nArray10[34] = 17;
        nArray10[35] = 17;
        nArray10[36] = 17;
        nArray10[37] = 17;
        nArray10[38] = 17;
        nArray10[39] = 17;
        nArray10[40] = 17;
        nArray10[41] = 17;
        nArray10[42] = 17;
        nArray10[43] = 17;
        nArray10[44] = 17;
        nArray10[45] = 17;
        nArray10[46] = 17;
        nArray10[47] = 17;
        nArray10[48] = 44;
        nArray10[49] = 44;
        nArray10[50] = 44;
        nArray10[65] = 44;
        nArray10[66] = 44;
        nArray10[128] = 3;
        nArray10[129] = 3;
        nArray10[130] = 3;
        nArray10[131] = 3;
        nArray10[132] = 3;
        nArray10[133] = 3;
        nArray10[134] = 3;
        nArray10[135] = 3;
        nArray10[136] = 3;
        nArray10[137] = 3;
        nArray10[138] = 3;
        nArray10[139] = 3;
        nArray10[140] = 3;
        nArray10[141] = 3;
        nArray10[142] = 3;
        nArray10[143] = 3;
        nArray10[144] = 3;
        nArray10[145] = 3;
        nArray10[146] = 3;
        nArray10[147] = 3;
        nArray10[148] = 3;
        nArray10[149] = 3;
        nArray10[150] = 3;
        nArray10[151] = 3;
        nArray10[152] = 3;
        nArray10[153] = 3;
        nArray10[154] = 3;
        nArray10[155] = 3;
        nArray10[156] = 3;
        nArray10[157] = 3;
        nArray10[158] = 3;
        nArray10[159] = 3;
        scsTable = nArray10;
    }
}

