/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 titlescreen.sc
 Contains the title screen room.
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script TITLESCREEN_SCRIPT)
/******************************************************************************/
(use "main")
(use "game")
(use "menubar")
(use "obj")
(use "cycle")
(use "user")
(use "controls")
(use "feature")
/******************************************************************************/
(instance public TitleScreen of Rm
	(properties
		picture scriptNumber
	)
	(method (init)
        // Set up the title screen
		ProgramControl()
		= gProgramControl FALSE
		(send gGame:setSpeed(15))
		(SL:disable())
		(TheMenuBar:hide())
		
		(super:init())
		(self:setScript(RoomScript))
		
		(send gEgo:
			posn(150 130)
			loop(1)
		)

        SetUpEgo()
		(send gEgo:
			init()
		)
  
        Animate(gEgo)
        /****************************************
         * Set up the room's music to play here *
         ****************************************/ /*
		(send gTheMusic:
			prevSignal(0)
			stop()
			number(scriptNumber)
			loop(-1)
			play()
		)       */

        /**************************************************
         * Add the rest of your initialization stuff here *
         **************************************************/

		Display(
			"Intro/Opening Screen"
			dsCOORD 90 80
			dsCOLOUR clWHITE
			dsBACKGROUND clTRANSPARENT
		)
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)     /*
    (method (changeState newState)
        = state newState
        /************************************
         * Add the state related stuff here *
         ************************************/
    //)
	(method (handleEvent pEvent)
        (var str[64], hFile, i)
        (super:handleEvent(pEvent))
        (if( not (send pEvent:claimed) )
			(if( (== (send pEvent:type) evKEYBOARD) and (== (send pEvent:message) $3C00) )
				ToggleSound()
			)(else
                /******************************************
                 * If the title screen has music, fade it *
                 ******************************************/
				//(send gTheMusic:fade())
    
        = hFile FOpen("somefile.txt" fCREATE)
/*
         // green (2) only
        (if ( <> $0004 OnControl(ocSPECIAL 0 3))
            FPuts(hFile "should be green\n")
        )
         // cyan (3) only
        (if ( <> $0008 OnControl(ocSPECIAL 0 6))
            FPuts(hFile "should be cyan\n")
        )
        // nothing (just below cyan)
        (if ( <> $0001 OnControl(ocSPECIAL 0 9))
            FPuts(hFile "should be black\n")
        )
        // 3 blue and 1 red
        FPuts(hFile Format(@str "%04x\n" OnControl(ocSPECIAL 0 0 0 3)))
         // 2 blue and 2 red
        FPuts(hFile Format(@str "%04x\n" OnControl(ocSPECIAL 0 1 0 4)))
         // 1 blue and 1 red
        FPuts(hFile Format(@str "%04x\n" OnControl(ocSPECIAL 0 2 0 3)))
         // 1 blue and 3 red
        FPuts(hFile Format(@str "%04x\n" OnControl(ocSPECIAL 0 2 0 5)))
         // 3 red and 1 cyan
        FPuts(hFile Format(@str "%04x\n" OnControl(ocSPECIAL 0 3 0 6)))
         // 1 red and 3 cyan
        FPuts(hFile Format(@str "%04x\n" OnControl(ocSPECIAL 0 5 0 8)))
         // 1 red and 1 cyan
        FPuts(hFile Format(@str "%04x\n" OnControl(ocSPECIAL 0 5 0 6)))
         // 3 cyan and 1 nothing
        FPuts(hFile Format(@str "%04x\n" OnControl(ocSPECIAL 0 6 0 9)))
         // 1 cyan and 3 nothing
        FPuts(hFile Format(@str "%04x\n" OnControl(ocSPECIAL 0 8 0 11)))
         // 1 cyan and 1 nothing
        FPuts(hFile Format(@str "%04x\n" OnControl(ocSPECIAL 0 8 0 9)))
        // all nothing (just below cyan)
        FPuts(hFile Format(@str "%04x\n" OnControl(ocSPECIAL 0 9 0 12)))

        // 3 blue and 1 red
        FPuts(hFile Format(@str "%04x\n" OnControl(ocSPECIAL 1 1 2 3)))
         // 2 blue and 2 red
        FPuts(hFile Format(@str "%04x\n" OnControl(ocSPECIAL 1 1 2 4)))
         // 1 blue and 1 red
        FPuts(hFile Format(@str "%04x\n" OnControl(ocSPECIAL 1 2 2 3)))
         // 1 blue and 3 red
        FPuts(hFile Format(@str "%04x\n" OnControl(ocSPECIAL 1 2 2 5)))
         // 3 red and 1 cyan
        FPuts(hFile Format(@str "%04x\n" OnControl(ocSPECIAL 1 3 2 6)))
         // 1 red and 3 cyan
        FPuts(hFile Format(@str "%04x\n" OnControl(ocSPECIAL 1 5 2 8)))
         // 1 red and 1 cyan
        FPuts(hFile Format(@str "%04x\n" OnControl(ocSPECIAL 1 5 2 6)))
         // 3 cyan and 1 nothing
        FPuts(hFile Format(@str "%04x\n" OnControl(ocSPECIAL 1 6 2 9)))
         // 1 cyan and 3 nothing
        FPuts(hFile Format(@str "%04x\n" OnControl(ocSPECIAL 1 8 2 11)))
         // 1 cyan and 1 nothing
        FPuts(hFile Format(@str "%04x\n" OnControl(ocSPECIAL 1 8 2 9)))
        // all nothing (just below cyan)
        FPuts(hFile Format(@str "%04x\n" OnControl(ocSPECIAL 1 9 2 12)))

        // the whole box
        FPuts(hFile Format(@str "%04x\n" OnControl(ocSPECIAL 0 0 2 12)))
*/
        //(send gCast:add(gEgo))
/*       (for (= i 0) (< i 16383) (++i)
            FPuts(hFile Format(@str "signal before Animate is %04x\n" i))
            (send gEgo:signal( i ))
            Animate((send gCast:elements) 1)
            FPuts(hFile Format(@str "signal after Animate is: %04x\n" (send gEgo:signal)))
        )
            = i $088
            FPuts(hFile Format(@str "signal before Animate is %04x\n" i))
            (send gEgo:signal( i ))
            Animate((send gCast:elements) 1)
            FPuts(hFile Format(@str "signal after Animate is: %04x\n" (send gEgo:signal)))
            = i $4000
            FPuts(hFile Format(@str "signal before Animate is %04x\n" i))
            (send gEgo:signal( i ))
            Animate((send gCast:elements) 1)
            FPuts(hFile Format(@str "signal after Animate is: %04x\n" (send gEgo:signal)))
            = i $4002
            FPuts(hFile Format(@str "signal before Animate is %04x\n" i))
            (send gEgo:signal( i ))
            Animate((send gCast:elements) 1)
            FPuts(hFile Format(@str "signal after Animate is: %04x\n" (send gEgo:signal)))
            = i $0002
            FPuts(hFile Format(@str "signal before Animate is %04x\n" i))
            (send gEgo:signal( i ))
            Animate((send gCast:elements) 1)
            FPuts(hFile Format(@str "signal after Animate is: %04x\n" (send gEgo:signal)))
            = i $0008
            FPuts(hFile Format(@str "signal before Animate is %04x\n" i))
            (send gEgo:signal( i ))
            Animate((send gCast:elements) 1)
            FPuts(hFile Format(@str "signal after Animate is: %04x\n" (send gEgo:signal)))
           = i $0066
            FPuts(hFile Format(@str "signal before Animate is %04x\n" i))
            (send gEgo:signal( i ))
            Animate((send gCast:elements) 1)
            FPuts(hFile Format(@str "signal after Animate is: %04x\n" (send gEgo:signal)))
            = i $0042
            FPuts(hFile Format(@str "signal before Animate is %04x\n" i))
            (send gEgo:signal( i ))
            Animate((send gCast:elements) 1)
            FPuts(hFile Format(@str "signal after Animate is: %04x\n" (send gEgo:signal)))
            = i $008C
            FPuts(hFile Format(@str "signal before Animate is %04x\n" i))
            (send gEgo:signal( i ))
            Animate((send gCast:elements) 1)
            FPuts(hFile Format(@str "signal after Animate is: %04x\n" (send gEgo:signal)))
*/            = i $0082
            FPuts(hFile Format(@str "signal before Animate is %04x\n" i))
            (send gEgo:signal( i ))
            Animate((send gCast:elements) 1)
            FPuts(hFile Format(@str "signal after Animate is: %04x\n" (send gEgo:signal)))


		Display(
			"Tests Done"
			dsCOORD 90 80
			dsCOLOUR clBLACK
			dsBACKGROUND clTRANSPARENT
		)
                // End the title screen, start the game
				(send gRoom:newRoom(INITROOMS_SCRIPT))
		    )
		)
	)
)
/******************************************************************************/
